/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.application.RelationshipPublisher;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.provider.SpaceIdentityProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ActivityStorageImplTestCase
extends AbstractCoreTest {
    private IdentityStorage identityStorage;
    private ActivityStorage activityStorage;
    private RelationshipStorage relationshipStorage;
    private List<ExoSocialActivity> tearDownActivityList;
    private List<Space> tearDownSpaceList;
    private SpaceStorage spaceStorage;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.activityStorage = (ActivityStorage)this.getContainer().getComponentInstanceOfType(ActivityStorage.class);
        this.relationshipStorage = (RelationshipStorage)this.getContainer().getComponentInstanceOfType(RelationshipStorage.class);
        this.spaceStorage = (SpaceStorage)this.getContainer().getComponentInstanceOfType(SpaceStorage.class);
        ActivityStorageImplTestCase.assertNotNull((Object)this.identityStorage);
        ActivityStorageImplTestCase.assertNotNull((Object)this.activityStorage);
        ActivityStorageImplTestCase.assertNotNull((Object)this.relationshipStorage);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityStorage.saveIdentity(this.rootIdentity);
        this.identityStorage.saveIdentity(this.johnIdentity);
        this.identityStorage.saveIdentity(this.maryIdentity);
        this.identityStorage.saveIdentity(this.demoIdentity);
        ActivityStorageImplTestCase.assertNotNull((Object)this.rootIdentity.getId());
        ActivityStorageImplTestCase.assertNotNull((Object)this.johnIdentity.getId());
        ActivityStorageImplTestCase.assertNotNull((Object)this.maryIdentity.getId());
        ActivityStorageImplTestCase.assertNotNull((Object)this.demoIdentity.getId());
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
        this.tearDownSpaceList = new ArrayList<Space>();
    }

    @Override
    protected void tearDown() throws Exception {
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            this.activityStorage.deleteActivity(activity.getId());
        }
        for (Space sp : this.tearDownSpaceList) {
            this.spaceStorage.deleteSpace(sp.getId());
        }
        this.identityStorage.deleteIdentity(this.rootIdentity);
        this.identityStorage.deleteIdentity(this.johnIdentity);
        this.identityStorage.deleteIdentity(this.maryIdentity);
        this.identityStorage.deleteIdentity(this.demoIdentity);
        super.tearDown();
    }

    public void testSaveActivity() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("title ");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((String)activity.getId(), (String)got.getId());
        ActivityStorageImplTestCase.assertEquals((String)activity.getTitle(), (String)got.getTitle());
        ExoSocialActivityImpl act = new ExoSocialActivityImpl();
        act.setTitle("@#$%^&*(()_+:<>?");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)act);
        ActivityStorageImplTestCase.assertNotNull((Object)act.getId());
    }

    public void testTemplateParams() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("title ");
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put("key1", "value1");
        templateParams.put("key2", "value2");
        templateParams.put("key3", "value3");
        activity.setTemplateParams(templateParams);
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        Map gotTemplateParams = got.getTemplateParams();
        ArrayList arrayList = new ArrayList(gotTemplateParams.values());
        ActivityStorageImplTestCase.assertEquals((String)"value1", (String)((String)arrayList.get(0)));
        ActivityStorageImplTestCase.assertEquals((String)"value2", (String)((String)arrayList.get(1)));
        ActivityStorageImplTestCase.assertEquals((String)"value3", (String)((String)arrayList.get(2)));
    }

    public void testUpdateActivity() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("&");
        activity.setBody("test&amp;");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        got.setBody(null);
        got.setTitle(null);
        this.activityStorage.updateActivity(got);
        ExoSocialActivity updatedActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((String)activity.getId(), (String)got.getId());
        ActivityStorageImplTestCase.assertEquals((String)activity.getTitle(), (String)got.getTitle());
    }

    public void testUpdateActivityForLike() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("a");
        activity.setBody("test");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        got.setBody(null);
        got.setTitle(null);
        got.setLikeIdentityIds(new String[]{this.maryIdentity.getId()});
        this.activityStorage.updateActivity(got);
        ExoSocialActivity updatedActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((String)got.getId(), (String)updatedActivity.getId());
        ActivityStorageImplTestCase.assertEquals((String)got.getTitle(), (String)updatedActivity.getTitle());
        ActivityStorageImplTestCase.assertEquals((String)got.getBody(), (String)updatedActivity.getBody());
    }

    public void testUpdateActivityForWrong() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("&");
        activity.setBody("test&amp;");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        got.setLikeIdentityIds(new String[]{this.maryIdentity.getId()});
        this.activityStorage.updateActivity(got);
        ExoSocialActivity updatedActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((String)got.getId(), (String)updatedActivity.getId());
        ActivityStorageImplTestCase.assertNotSame((Object)got.getTitle(), (Object)updatedActivity.getTitle());
        ActivityStorageImplTestCase.assertNotSame((Object)got.getBody(), (Object)updatedActivity.getBody());
    }

    public void testUpdateActivityForUnLike() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("title ");
        activity.setLikeIdentityIds(new String[]{this.maryIdentity.getId()});
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        got.setBody(null);
        got.setTitle(null);
        got.setLikeIdentityIds(new String[0]);
        this.activityStorage.updateActivity(got);
        ExoSocialActivity updatedActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((String)got.getId(), (String)updatedActivity.getId());
        ActivityStorageImplTestCase.assertEquals((String)got.getTitle(), (String)updatedActivity.getTitle());
        ActivityStorageImplTestCase.assertEquals((String)got.getBody(), (String)updatedActivity.getBody());
    }

    public void testUpdateActivityForUnLikeWrong() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("&");
        activity.setBody("test&amp;");
        activity.setLikeIdentityIds(new String[]{this.maryIdentity.getId()});
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        got.setLikeIdentityIds(new String[0]);
        this.activityStorage.updateActivity(got);
        ExoSocialActivity updatedActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((String)got.getId(), (String)updatedActivity.getId());
        ActivityStorageImplTestCase.assertNotSame((Object)got.getTitle(), (Object)updatedActivity.getTitle());
        ActivityStorageImplTestCase.assertNotSame((Object)got.getBody(), (Object)updatedActivity.getBody());
    }

    public void testSaveComment() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity ");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((String)activity.getId(), (String)got.getId());
        ActivityStorageImplTestCase.assertEquals((String)activity.getTitle(), (String)got.getTitle());
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("comment");
        comment.setUserId(this.rootIdentity.getId());
        this.activityStorage.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ActivityStorageImplTestCase.assertNotNull((Object)comment.getId());
        ExoSocialActivity gotComment = this.activityStorage.getActivity(comment.getId());
        ActivityStorageImplTestCase.assertEquals((String)comment.getId(), (String)gotComment.getId());
        ActivityStorageImplTestCase.assertEquals((String)comment.getTitle(), (String)gotComment.getTitle());
        ExoSocialActivity gotParentActivity = this.activityStorage.getParentActivity((ExoSocialActivity)comment);
        ActivityStorageImplTestCase.assertEquals((String)activity.getId(), (String)gotParentActivity.getId());
        ActivityStorageImplTestCase.assertEquals((String)activity.getTitle(), (String)gotParentActivity.getTitle());
        ActivityStorageImplTestCase.assertEquals((int)1, (int)activity.getReplyToId().length);
        ActivityStorageImplTestCase.assertEquals((String)comment.getId(), (String)activity.getReplyToId()[0]);
    }

    public void testActivityCount() throws Exception {
        for (int i = 0; i < 10; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        }
        ActivityStorageImplTestCase.assertEquals((int)10, (int)this.activityStorage.getNumberOfUserActivities(this.rootIdentity));
        Iterator it = this.activityStorage.getUserActivities(this.rootIdentity, 0L, 100L).iterator();
        for (int i = 0; i < 5; ++i) {
            this.activityStorage.deleteActivity(((ExoSocialActivity)it.next()).getId());
        }
        it = this.activityStorage.getUserActivities(this.rootIdentity, 0L, 100L).iterator();
        ActivityStorageImplTestCase.assertEquals((int)5, (int)this.activityStorage.getNumberOfUserActivities(this.rootIdentity));
        while (it.hasNext()) {
            this.tearDownActivityList.add((ExoSocialActivity)it.next());
        }
    }

    public void testUserPostActivityToSpace() throws ActivityStorageException {
        Space space = this.getSpaceInstance();
        SpaceIdentityProvider spaceIdentityProvider = (SpaceIdentityProvider)this.getContainer().getComponentInstanceOfType(SpaceIdentityProvider.class);
        Identity spaceIdentity = spaceIdentityProvider.createIdentity(space);
        this.identityStorage.saveIdentity(spaceIdentity);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("Space's Activity");
        activity.setUserId(this.johnIdentity.getId());
        this.activityStorage.saveActivity(spaceIdentity, (ExoSocialActivity)activity);
        ExoSocialActivity gotActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((String)("userId must be " + this.johnIdentity.getId()), (String)this.johnIdentity.getId(), (String)gotActivity.getUserId());
        List gotActivities = this.activityStorage.getUserActivities(this.johnIdentity, 0L, 20L);
        ActivityStorageImplTestCase.assertEquals((int)1, (int)gotActivities.size());
        ActivityStorageImplTestCase.assertEquals((String)this.johnIdentity.getId(), (String)((ExoSocialActivity)gotActivities.get(0)).getUserId());
        this.identityStorage.deleteIdentity(spaceIdentity);
    }

    public void testActivityOrder() throws Exception {
        int i;
        for (i = 0; i < 10; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
            this.tearDownActivityList.add((ExoSocialActivity)activity);
        }
        i = 9;
        for (ExoSocialActivity activity : this.activityStorage.getUserActivities(this.rootIdentity)) {
            ActivityStorageImplTestCase.assertEquals((String)("title " + i), (String)activity.getTitle());
            --i;
        }
    }

    public void testActivityOrderByPostedTime() throws Exception {
        int i;
        Calendar cal = Calendar.getInstance();
        long today = cal.getTime().getTime();
        cal.add(5, -1);
        long yesterday = cal.getTime().getTime();
        for (i = 0; i < 10; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            activity.setPostedTime(Long.valueOf(i > 5 ? today + (long)i : yesterday + (long)i));
            this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        }
        i = 9;
        for (ExoSocialActivity activity : this.activityStorage.getUserActivities(this.rootIdentity)) {
            ActivityStorageImplTestCase.assertEquals((String)("title " + i), (String)activity.getTitle());
            if (i > 5) {
                ActivityStorageImplTestCase.assertEquals((long)(today + (long)i), (long)activity.getPostedTime());
            } else {
                ActivityStorageImplTestCase.assertEquals((long)(yesterday + (long)i), (long)activity.getPostedTime());
            }
            --i;
        }
    }

    public void testActivityOrderByPostedTime2() throws Exception {
        int i;
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        long today = cal.getTime().getTime();
        cal.add(5, -1);
        long yesterday = cal.getTime().getTime();
        for (i = 0; i < 10; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            activity.setPostedTime(Long.valueOf(i >= 5 ? today + (long)i : yesterday + (long)i));
            this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        }
        i = 9;
        for (ExoSocialActivity activity : this.activityStorage.getUserActivities(this.rootIdentity)) {
            ActivityStorageImplTestCase.assertEquals((String)("title " + i), (String)activity.getTitle());
            if (i >= 5) {
                ActivityStorageImplTestCase.assertEquals((long)(today + (long)i), (long)activity.getPostedTime());
            } else {
                ActivityStorageImplTestCase.assertEquals((long)(yesterday + (long)i), (long)activity.getPostedTime());
            }
            --i;
        }
    }

    public void testActivityHidden() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("title");
        activity.setBody("body");
        activity.isHidden(false);
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        got.isHidden(true);
        this.activityStorage.updateActivity(got);
        ExoSocialActivity updatedActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((boolean)true, (boolean)updatedActivity.isHidden());
    }

    public void testActivityUnHidden() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("title");
        activity.setBody("body");
        activity.isHidden(true);
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        got.isHidden(false);
        this.activityStorage.updateActivity(got);
        ExoSocialActivity updatedActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((boolean)false, (boolean)updatedActivity.isHidden());
    }

    public void testActivityLock() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("title");
        activity.setBody("body");
        activity.isLocked(false);
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        got.isLocked(true);
        this.activityStorage.updateActivity(got);
        ExoSocialActivity updatedActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((boolean)true, (boolean)updatedActivity.isLocked());
    }

    public void testActivityUnLock() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("title");
        activity.setBody("body");
        activity.isLocked(true);
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        got.isLocked(false);
        this.activityStorage.updateActivity(got);
        ExoSocialActivity updatedActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((boolean)false, (boolean)updatedActivity.isLocked());
    }

    public void testCommentOrder() throws Exception {
        int i;
        for (i = 0; i < 10; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
            this.tearDownActivityList.add((ExoSocialActivity)activity);
            for (int j = 0; j < 10; ++j) {
                ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
                comment.setTitle("title " + i + j);
                comment.setUserId(this.rootIdentity.getId());
                this.activityStorage.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
            }
        }
        this.restartTransaction();
        i = 9;
        for (ExoSocialActivity activity : this.activityStorage.getUserActivities(this.rootIdentity)) {
            int j = 0;
            for (String commentId : activity.getReplyToId()) {
                if ("".equals(commentId)) continue;
                ActivityStorageImplTestCase.assertEquals((String)("title " + i + j), (String)this.activityStorage.getActivity(commentId).getTitle());
                ++j;
            }
            --i;
        }
    }

    public void testDeleteComment() throws Exception {
        int i;
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity title");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add((ExoSocialActivity)activity);
        activity = this.activityStorage.getActivity(activity.getId());
        for (i = 0; i < 10; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment title " + i);
            comment.setUserId(this.rootIdentity.getId());
            this.activityStorage.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        }
        this.restartTransaction();
        ActivityStorageImplTestCase.assertEquals((int)10, (int)this.activityStorage.getActivity(activity.getId()).getReplyToId().length);
        i = 0;
        activity = this.activityStorage.getActivity(activity.getId());
        for (String commentId : activity.getReplyToId()) {
            if ("".equals(commentId) || i >= 5) continue;
            this.activityStorage.deleteActivity(commentId);
            ++i;
        }
        ActivityStorageImplTestCase.assertEquals((int)5, (int)this.activityStorage.getActivity(activity.getId()).getReplyToId().length);
    }

    public void testLike() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity title");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        activity.setLikeIdentityIds(new String[]{this.rootIdentity.getId(), this.johnIdentity.getId(), this.demoIdentity.getId()});
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        List activities = this.activityStorage.getUserActivities(this.rootIdentity);
        ActivityStorageImplTestCase.assertEquals((int)1, (int)activities.size());
        ActivityStorageImplTestCase.assertEquals((int)3, (int)((ExoSocialActivity)activities.get(0)).getLikeIdentityIds().length);
        List<String> ids = Arrays.asList(((ExoSocialActivity)activities.get(0)).getLikeIdentityIds());
        ActivityStorageImplTestCase.assertTrue((boolean)ids.contains(this.rootIdentity.getId()));
        ActivityStorageImplTestCase.assertTrue((boolean)ids.contains(this.johnIdentity.getId()));
        ActivityStorageImplTestCase.assertTrue((boolean)ids.contains(this.demoIdentity.getId()));
        ActivityStorageImplTestCase.assertTrue((!ids.contains(this.maryIdentity.getId()) ? 1 : 0) != 0);
    }

    public void testTimeStamp() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity title");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setUserId(this.rootIdentity.getId());
        comment.setTitle("comment title");
        this.activityStorage.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        List activities = this.activityStorage.getUserActivities(this.rootIdentity);
        ActivityStorageImplTestCase.assertEquals((int)1, (int)activities.size());
        ActivityStorageImplTestCase.assertFalse((((ExoSocialActivity)activities.get(0)).getPostedTime() == 0L ? 1 : 0) != 0);
        ActivityStorageImplTestCase.assertEquals((int)1, (int)((ExoSocialActivity)activities.get(0)).getReplyToId().length);
        ExoSocialActivity gotComment = this.activityStorage.getActivity(((ExoSocialActivity)activities.get(0)).getReplyToId()[0]);
        ActivityStorageImplTestCase.assertFalse((gotComment.getPostedTime() == 0L ? 1 : 0) != 0);
    }

    public void testManyDays() throws Exception {
        long timestamp111 = this.timestamp(2001, 1, 1);
        long timestamp112 = this.timestamp(2001, 1, 2);
        long timestamp121 = this.timestamp(2001, 2, 1);
        long timestamp122 = this.timestamp(2001, 2, 2);
        long timestamp211 = this.timestamp(2002, 1, 1);
        long timestamp212 = this.timestamp(2002, 1, 2);
        long timestamp221 = this.timestamp(2002, 2, 1);
        long timestamp222 = this.timestamp(2002, 2, 2);
        this.addActivity(this.rootIdentity, timestamp111);
        this.addActivity(this.rootIdentity, timestamp112);
        this.addActivity(this.rootIdentity, timestamp121);
        this.addActivity(this.rootIdentity, timestamp122);
        this.addActivity(this.rootIdentity, timestamp211);
        this.addActivity(this.rootIdentity, timestamp212);
        this.addActivity(this.rootIdentity, timestamp221);
        this.addActivity(this.rootIdentity, timestamp222);
        List activities = this.activityStorage.getUserActivities(this.rootIdentity);
        ActivityStorageImplTestCase.assertEquals((int)8, (int)activities.size());
        ActivityStorageImplTestCase.assertEquals((long)timestamp111, (long)((ExoSocialActivity)activities.get(7)).getPostedTime());
        ActivityStorageImplTestCase.assertEquals((long)timestamp112, (long)((ExoSocialActivity)activities.get(6)).getPostedTime());
        ActivityStorageImplTestCase.assertEquals((long)timestamp121, (long)((ExoSocialActivity)activities.get(5)).getPostedTime());
        ActivityStorageImplTestCase.assertEquals((long)timestamp122, (long)((ExoSocialActivity)activities.get(4)).getPostedTime());
        ActivityStorageImplTestCase.assertEquals((long)timestamp211, (long)((ExoSocialActivity)activities.get(3)).getPostedTime());
        ActivityStorageImplTestCase.assertEquals((long)timestamp212, (long)((ExoSocialActivity)activities.get(2)).getPostedTime());
        ActivityStorageImplTestCase.assertEquals((long)timestamp221, (long)((ExoSocialActivity)activities.get(1)).getPostedTime());
        ActivityStorageImplTestCase.assertEquals((long)timestamp222, (long)((ExoSocialActivity)activities.get(0)).getPostedTime());
    }

    public void testManyDaysNoActivityOnDay() throws Exception {
        long timestamp1 = this.timestamp(2001, 1, 1);
        long timestamp2 = this.timestamp(2001, 1, 2);
        this.addActivity(this.rootIdentity, timestamp1);
        ExoSocialActivity activity2 = this.addActivity(this.rootIdentity, timestamp2);
        this.activityStorage.deleteActivity(activity2.getId());
        List activities = this.activityStorage.getUserActivities(this.rootIdentity);
        ActivityStorageImplTestCase.assertEquals((int)1, (int)activities.size());
        ActivityStorageImplTestCase.assertEquals((long)timestamp1, (long)((ExoSocialActivity)activities.get(0)).getPostedTime());
    }

    public void testManyDaysNoActivityOnMonth() throws Exception {
        long timestamp11 = this.timestamp(2001, 1, 1);
        long timestamp12 = this.timestamp(2001, 1, 2);
        long timestamp21 = this.timestamp(2001, 2, 1);
        long timestamp22 = this.timestamp(2001, 2, 2);
        this.addActivity(this.rootIdentity, timestamp11);
        this.addActivity(this.rootIdentity, timestamp12);
        ExoSocialActivity activity21 = this.addActivity(this.rootIdentity, timestamp21);
        ExoSocialActivity activity22 = this.addActivity(this.rootIdentity, timestamp22);
        this.activityStorage.deleteActivity(activity21.getId());
        this.activityStorage.deleteActivity(activity22.getId());
        List activities = this.activityStorage.getUserActivities(this.rootIdentity);
        ActivityStorageImplTestCase.assertEquals((int)2, (int)activities.size());
        ActivityStorageImplTestCase.assertEquals((long)timestamp11, (long)((ExoSocialActivity)activities.get(1)).getPostedTime());
        ActivityStorageImplTestCase.assertEquals((long)timestamp12, (long)((ExoSocialActivity)activities.get(0)).getPostedTime());
    }

    public void testManyDaysNoActivityOnYear() throws Exception {
        long timestamp111 = this.timestamp(2001, 1, 1);
        long timestamp112 = this.timestamp(2001, 1, 2);
        long timestamp121 = this.timestamp(2001, 2, 1);
        long timestamp122 = this.timestamp(2001, 2, 2);
        long timestamp211 = this.timestamp(2002, 1, 1);
        long timestamp212 = this.timestamp(2002, 1, 2);
        long timestamp221 = this.timestamp(2002, 2, 1);
        long timestamp222 = this.timestamp(2002, 2, 2);
        this.addActivity(this.rootIdentity, timestamp111);
        this.addActivity(this.rootIdentity, timestamp112);
        this.addActivity(this.rootIdentity, timestamp121);
        this.addActivity(this.rootIdentity, timestamp122);
        ExoSocialActivity activity211 = this.addActivity(this.rootIdentity, timestamp211);
        ExoSocialActivity activity212 = this.addActivity(this.rootIdentity, timestamp212);
        ExoSocialActivity activity221 = this.addActivity(this.rootIdentity, timestamp221);
        ExoSocialActivity activity222 = this.addActivity(this.rootIdentity, timestamp222);
        this.activityStorage.deleteActivity(activity211.getId());
        this.activityStorage.deleteActivity(activity212.getId());
        this.activityStorage.deleteActivity(activity221.getId());
        this.activityStorage.deleteActivity(activity222.getId());
        List activities = this.activityStorage.getUserActivities(this.rootIdentity);
        ActivityStorageImplTestCase.assertEquals((int)4, (int)activities.size());
        ActivityStorageImplTestCase.assertEquals((long)timestamp111, (long)((ExoSocialActivity)activities.get(3)).getPostedTime());
        ActivityStorageImplTestCase.assertEquals((long)timestamp112, (long)((ExoSocialActivity)activities.get(2)).getPostedTime());
        ActivityStorageImplTestCase.assertEquals((long)timestamp121, (long)((ExoSocialActivity)activities.get(1)).getPostedTime());
        ActivityStorageImplTestCase.assertEquals((long)timestamp122, (long)((ExoSocialActivity)activities.get(0)).getPostedTime());
    }

    public void testManyDaysNoActivityOnAll() throws Exception {
        long timestamp111 = this.timestamp(2001, 1, 1);
        long timestamp112 = this.timestamp(2001, 1, 2);
        long timestamp121 = this.timestamp(2001, 2, 1);
        long timestamp122 = this.timestamp(2001, 2, 2);
        long timestamp211 = this.timestamp(2002, 1, 1);
        long timestamp212 = this.timestamp(2002, 1, 2);
        long timestamp221 = this.timestamp(2002, 2, 1);
        long timestamp222 = this.timestamp(2002, 2, 2);
        ExoSocialActivity activity111 = this.addActivity(this.rootIdentity, timestamp111);
        ExoSocialActivity activity112 = this.addActivity(this.rootIdentity, timestamp112);
        ExoSocialActivity activity121 = this.addActivity(this.rootIdentity, timestamp121);
        ExoSocialActivity activity122 = this.addActivity(this.rootIdentity, timestamp122);
        ExoSocialActivity activity211 = this.addActivity(this.rootIdentity, timestamp211);
        ExoSocialActivity activity212 = this.addActivity(this.rootIdentity, timestamp212);
        ExoSocialActivity activity221 = this.addActivity(this.rootIdentity, timestamp221);
        ExoSocialActivity activity222 = this.addActivity(this.rootIdentity, timestamp222);
        this.activityStorage.deleteActivity(activity111.getId());
        this.activityStorage.deleteActivity(activity112.getId());
        this.activityStorage.deleteActivity(activity121.getId());
        this.activityStorage.deleteActivity(activity122.getId());
        this.activityStorage.deleteActivity(activity211.getId());
        this.activityStorage.deleteActivity(activity212.getId());
        this.activityStorage.deleteActivity(activity221.getId());
        this.activityStorage.deleteActivity(activity222.getId());
        List activities = this.activityStorage.getUserActivities(this.rootIdentity);
        ActivityStorageImplTestCase.assertEquals((int)0, (int)activities.size());
    }

    public void testRelationshipActivity() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("I am now connected with @receiverRemoteId");
        activity.setType("exosocial:relationship");
        activity.setAppId("appId");
        activity.setBody("body");
        activity.setBodyId("bodyId");
        activity.setTitleId(RelationshipPublisher.TitleId.CONNECTION_REQUESTED.toString());
        activity.setExternalId("externalId");
        activity.setUrl("http://www.exoplatform.org");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SENDER", "senderRemoteId");
        params.put("RECEIVER", "receiverRemoteId");
        params.put("RELATIONSHIP_UUID", "relationship_id");
        activity.setTemplateParams(params);
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        List activities = this.activityStorage.getUserActivities(this.rootIdentity);
        ActivityStorageImplTestCase.assertNotNull((Object)activities);
        ActivityStorageImplTestCase.assertEquals((int)1, (int)activities.size());
        for (ExoSocialActivity element : activities) {
            ActivityStorageImplTestCase.assertNotNull((Object)element.getTitle());
            ActivityStorageImplTestCase.assertNotNull((Object)element.getType());
            ActivityStorageImplTestCase.assertNotNull((Object)element.getAppId());
            ActivityStorageImplTestCase.assertNotNull((Object)element.getBody());
            ActivityStorageImplTestCase.assertNotNull((Object)element.getBodyId());
            ActivityStorageImplTestCase.assertEquals((String)RelationshipPublisher.TitleId.CONNECTION_REQUESTED.toString(), (String)element.getTitleId());
            ActivityStorageImplTestCase.assertNotNull((Object)element.getExternalId());
            ActivityStorageImplTestCase.assertEquals((String)"http://www.exoplatform.org", (String)element.getUrl());
            ActivityStorageImplTestCase.assertNotNull((Object)element.getUserId());
            ActivityStorageImplTestCase.assertNotNull((Object)element.getTemplateParams());
        }
    }

    public void testActivityProcessing() throws Exception {
        DummyProcessor processor = new DummyProcessor(this, null);
        this.activityStorage.getActivityProcessors().add(processor);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityStorageImplTestCase.assertNotNull((Object)activity.getId());
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        ActivityStorageImplTestCase.assertEquals((String)activity.getId(), (String)got.getId());
        ActivityStorageImplTestCase.assertEquals((String)"edited", (String)got.getTitle());
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("comment");
        comment.setUserId(this.rootIdentity.getId());
        this.activityStorage.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ActivityStorageImplTestCase.assertNotNull((Object)comment.getId());
        ExoSocialActivity gotComment = this.activityStorage.getActivity(comment.getId());
        ActivityStorageImplTestCase.assertEquals((String)comment.getId(), (String)gotComment.getId());
        ActivityStorageImplTestCase.assertEquals((String)"edited", (String)gotComment.getTitle());
        ExoSocialActivity gotParentActivity = this.activityStorage.getParentActivity((ExoSocialActivity)comment);
        ActivityStorageImplTestCase.assertEquals((String)activity.getId(), (String)gotParentActivity.getId());
        ActivityStorageImplTestCase.assertEquals((String)"edited", (String)gotParentActivity.getTitle());
        ActivityStorageImplTestCase.assertEquals((int)1, (int)activity.getReplyToId().length);
        ActivityStorageImplTestCase.assertEquals((String)comment.getId(), (String)activity.getReplyToId()[0]);
        this.activityStorage.getActivityProcessors().remove((Object)processor);
    }

    private Space getSpaceInstance() {
        Space space = new Space();
        space.setDisplayName("myspace");
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space");
        space.setType("classic");
        space.setVisibility("public");
        space.setPriority("2");
        space.setGroupId("/space/space");
        space.setUrl(space.getPrettyName());
        String[] managers = new String[]{"john", "demo"};
        space.setManagers(managers);
        return space;
    }

    private ExoSocialActivity addActivity(Identity identity, long timestamp) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity title");
        activity.setPostedTime(Long.valueOf(timestamp));
        this.activityStorage.saveActivity(identity, (ExoSocialActivity)activity);
        return activity;
    }

    private long timestamp(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, 0, 0, 0);
        return cal.getTime().getTime();
    }

    private Space getSpaceInstance(int number) {
        Space space = new Space();
        space.setApp("app");
        space.setDisplayName("myspace " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setPriority("2");
        space.setGroupId("/spaces/space" + number);
        String[] managers = new String[]{"demo", "tom"};
        String[] members = new String[]{"raul", "ghost", "dragon"};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        return space;
    }

    private long getSinceTime() {
        Calendar cal = Calendar.getInstance();
        return cal.getTimeInMillis();
    }

    class DummyProcessor
    extends BaseActivityProcessorPlugin {
        DummyProcessor(ActivityStorageImplTestCase this$0, InitParams params) {
            super(params);
        }

        public void processActivity(ExoSocialActivity activity) {
            activity.setTitle("edited");
        }
    }
}

