/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.metadata;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataDAO;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.social.metadata.MetadataFilter;
import org.exoplatform.social.metadata.MetadataInitPlugin;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.MetadataTypePlugin;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.junit.Assert;
import org.picocontainer.Startable;

public class MetadataServiceTest
extends AbstractCoreTest {
    private static boolean allowMultipleItemsPerObject;
    private static boolean shareable;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private MetadataService metadataService;
    private MetadataDAO metadataDAO;
    private MetadataType userMetadataType;
    private MetadataType spaceMetadataType;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.metadataService = (MetadataService)this.getContainer().getComponentInstanceOfType(MetadataService.class);
        this.metadataDAO = (MetadataDAO)this.getContainer().getComponentInstanceOfType(MetadataDAO.class);
        this.userMetadataType = new MetadataType(1000L, "user");
        this.spaceMetadataType = new MetadataType(2000L, "space");
        if (this.metadataService.getMetadataTypeByName(this.userMetadataType.getName()) == null) {
            MetadataTypePlugin userMetadataTypePlugin = new MetadataTypePlugin(this, this.newParam(1000L, "user")){

                public boolean isAllowMultipleItemsPerObject() {
                    return allowMultipleItemsPerObject;
                }

                public boolean isShareable() {
                    return shareable;
                }
            };
            this.metadataService.addMetadataTypePlugin(userMetadataTypePlugin);
        }
        if (this.metadataService.getMetadataTypeByName(this.spaceMetadataType.getName()) == null) {
            MetadataTypePlugin spaceMetadataTypePlugin = new MetadataTypePlugin(this, this.newParam(2000L, "space")){

                public boolean isAllowMultipleItemsPerObject() {
                    return true;
                }
            };
            this.metadataService.addMetadataTypePlugin(spaceMetadataTypePlugin);
        }
        this.rootIdentity = this.identityManager.getOrCreateUserIdentity("root");
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.maryIdentity = this.identityManager.getOrCreateUserIdentity("mary");
        allowMultipleItemsPerObject = false;
        shareable = false;
    }

    @Override
    public void tearDown() throws Exception {
        this.restartTransaction();
        this.identityManager.deleteIdentity(this.rootIdentity);
        this.identityManager.deleteIdentity(this.johnIdentity);
        this.identityManager.deleteIdentity(this.maryIdentity);
        this.metadataDAO.deleteAll();
        super.tearDown();
    }

    public void testMetadataTypePlugin() {
        try {
            this.metadataService.addMetadataTypePlugin(new MetadataTypePlugin(this.newParam(2L, "space")));
            MetadataServiceTest.fail((String)"Should throw an exception when attempting to redefine an existing ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        List metadataTypes = this.metadataService.getMetadataTypes();
        MetadataServiceTest.assertNotNull((Object)metadataTypes);
        MetadataServiceTest.assertTrue((metadataTypes.size() >= 2 ? 1 : 0) != 0);
        MetadataServiceTest.assertNotNull((Object)this.metadataService.getMetadataTypePluginByName(this.userMetadataType.getName()));
        MetadataServiceTest.assertNotNull((Object)this.metadataService.getMetadataTypePluginByName(this.spaceMetadataType.getName()));
    }

    public void testCreateMetadata() throws Exception {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String name = "testMetadata1";
        try {
            this.metadataService.createMetadata(null, creatorId);
            MetadataServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.metadataService.createMetadata(this.newMetadataInstance(audienceId, creatorId, name, null, null), creatorId);
            MetadataServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.metadataService.createMetadata(this.newMetadataInstance(audienceId, creatorId, name, null, this.userMetadataType), 0L);
            MetadataServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.metadataService.createMetadata(this.newMetadataInstance(audienceId, creatorId, name, null, new MetadataType(3L, "test")), creatorId);
            MetadataServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("description", "description1");
        Metadata storedMetadata = this.metadataService.createMetadata(this.newMetadataInstance(audienceId, creatorId, name, properties, this.userMetadataType), creatorId);
        MetadataServiceTest.assertNotNull((Object)storedMetadata);
        MetadataServiceTest.assertTrue((storedMetadata.getId() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertTrue((storedMetadata.getCreatedDate() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertEquals((long)creatorId, (long)storedMetadata.getCreatorId());
        MetadataServiceTest.assertEquals((long)audienceId, (long)storedMetadata.getAudienceId());
        MetadataServiceTest.assertEquals((String)name, (String)storedMetadata.getName());
        MetadataServiceTest.assertEquals((Object)this.userMetadataType, (Object)storedMetadata.getType());
    }

    public void testDeleteMetadata() {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String metadata1Name = "testMetadata1";
        Metadata metadata1 = this.metadataService.createMetadata(this.newMetadataInstance(audienceId, creatorId, metadata1Name, null, this.userMetadataType), creatorId);
        String metadata2Name = "testMetadata2";
        Metadata metadata2 = this.metadataService.createMetadata(this.newMetadataInstance(audienceId, creatorId, metadata2Name, null, this.userMetadataType), creatorId);
        List metadatas = this.metadataService.getMetadatas(this.userMetadataType.getName(), -1L);
        MetadataServiceTest.assertEquals((int)2, (int)metadatas.size());
        MetadataServiceTest.assertEquals((String)metadata1Name, (String)((Metadata)metadatas.get(0)).getName());
        this.metadataService.deleteMetadataById(metadata1.getId());
        metadatas = this.metadataService.getMetadatas(this.userMetadataType.getName(), -1L);
        MetadataServiceTest.assertEquals((int)1, (int)metadatas.size());
        MetadataServiceTest.assertEquals((String)metadata2Name, (String)((Metadata)metadatas.get(0)).getName());
        this.metadataService.deleteMetadataById(metadata2.getId());
        metadatas = this.metadataService.getMetadatas(this.userMetadataType.getName(), -1L);
        MetadataServiceTest.assertEquals((int)0, (int)metadatas.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateMetadataItem() throws Exception {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String objectId = "objectId";
        String parentObjectId = "parentObjectId";
        String objectType = "objectType";
        String type = this.userMetadataType.getName();
        String name = "testMetadata2";
        MetadataKey metadataKey = new MetadataKey(type, name, audienceId);
        MetadataObject metadataObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        try {
            this.metadataService.createMetadataItem(null, metadataKey, creatorId);
            MetadataServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.metadataService.createMetadataItem(this.newMetadataObjectInstance(null, objectId, parentObjectId), metadataKey, creatorId);
            MetadataServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.metadataService.createMetadataItem(this.newMetadataObjectInstance(objectType, null, parentObjectId), metadataKey, creatorId);
            MetadataServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.metadataService.createMetadataItem(metadataObject, new MetadataKey(null, name, audienceId), creatorId);
            MetadataServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.metadataService.createMetadataItem(metadataObject, metadataKey, 0L);
            MetadataServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.metadataService.createMetadataItem(metadataObject, new MetadataKey("test", name, audienceId), creatorId);
            MetadataServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MetadataItem storedMetadataItem = this.metadataService.createMetadataItem(metadataObject, new MetadataKey(type, name, audienceId), creatorId);
        MetadataServiceTest.assertNotNull((Object)storedMetadataItem);
        MetadataServiceTest.assertTrue((storedMetadataItem.getId() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertTrue((storedMetadataItem.getCreatedDate() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertEquals((long)creatorId, (long)storedMetadataItem.getCreatorId());
        MetadataServiceTest.assertNotNull((Object)storedMetadataItem.getMetadata());
        MetadataServiceTest.assertEquals((long)audienceId, (long)storedMetadataItem.getMetadata().getAudienceId());
        MetadataServiceTest.assertEquals((String)name, (String)storedMetadataItem.getMetadata().getName());
        MetadataServiceTest.assertEquals((Object)this.userMetadataType, (Object)storedMetadataItem.getMetadata().getType());
        MetadataServiceTest.assertEquals((String)parentObjectId, (String)storedMetadataItem.getParentObjectId());
        MetadataServiceTest.assertEquals((String)objectId, (String)storedMetadataItem.getObjectId());
        MetadataServiceTest.assertEquals((String)objectType, (String)storedMetadataItem.getObjectType());
        try {
            storedMetadataItem = this.metadataService.createMetadataItem(metadataObject, new MetadataKey(type, name, audienceId), creatorId);
            MetadataServiceTest.fail();
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            // empty catch block
        }
        allowMultipleItemsPerObject = true;
        try {
            MetadataItem secondStoredMetadataItem = this.metadataService.createMetadataItem(metadataObject, new MetadataKey(type, name, audienceId), creatorId);
            MetadataServiceTest.assertNotNull((Object)secondStoredMetadataItem);
            Assert.assertNotEquals((long)storedMetadataItem.getId(), (long)secondStoredMetadataItem.getId());
            MetadataServiceTest.assertTrue((secondStoredMetadataItem.getCreatedDate() > 0L ? 1 : 0) != 0);
            MetadataServiceTest.assertEquals((long)creatorId, (long)secondStoredMetadataItem.getCreatorId());
            MetadataServiceTest.assertNotNull((Object)secondStoredMetadataItem.getMetadata());
            MetadataServiceTest.assertEquals((long)audienceId, (long)secondStoredMetadataItem.getMetadata().getAudienceId());
            MetadataServiceTest.assertEquals((String)name, (String)secondStoredMetadataItem.getMetadata().getName());
            MetadataServiceTest.assertEquals((Object)this.userMetadataType, (Object)secondStoredMetadataItem.getMetadata().getType());
            MetadataServiceTest.assertEquals((String)parentObjectId, (String)secondStoredMetadataItem.getParentObjectId());
            MetadataServiceTest.assertEquals((String)objectId, (String)secondStoredMetadataItem.getObjectId());
            MetadataServiceTest.assertEquals((String)objectType, (String)secondStoredMetadataItem.getObjectType());
        }
        finally {
            allowMultipleItemsPerObject = false;
        }
    }

    public void testGetMetadataItemsByMetadataNameAndTypeAndSpaceIds() throws ObjectAlreadyExistsException {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        long spaceId = 200L;
        String objectId = "objectId105";
        String parentObjectId = "parentObjectId";
        String objectType = "objectType16";
        String type = this.userMetadataType.getName();
        String name = "testMetadata11";
        MetadataObject metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        metadataItemObject.setSpaceId(spaceId);
        MetadataKey metadataKey = new MetadataKey(type, name, audienceId);
        MetadataItem storedMetadataItem = this.metadataService.createMetadataItem(metadataItemObject, metadataKey, creatorId);
        this.restartTransaction();
        List metadataItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndSpaceIds(name, type, Collections.singletonList(spaceId), 0L, 10L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
        MetadataServiceTest.assertEquals((long)storedMetadataItem.getId(), (long)((MetadataItem)metadataItems.get(0)).getId());
    }

    public void testGetMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceId() throws ObjectAlreadyExistsException {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        long spaceId = 200L;
        String objectId = "objectId105";
        String parentObjectId = "parentObjectId";
        String objectType = "objectType16";
        String type = this.userMetadataType.getName();
        String name = "testMetadata11";
        MetadataObject metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        metadataItemObject.setSpaceId(spaceId);
        MetadataKey metadataKey = new MetadataKey(type, name, audienceId);
        MetadataItem storedMetadataItem = this.metadataService.createMetadataItem(metadataItemObject, metadataKey, creatorId);
        this.restartTransaction();
        List metadataItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceId(name, type, objectType, spaceId, 0L, 10L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
        MetadataServiceTest.assertEquals((long)storedMetadataItem.getId(), (long)((MetadataItem)metadataItems.get(0)).getId());
    }

    public void testGetMetadataItemsByFilter() throws ObjectAlreadyExistsException {
        long creator2Id;
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        long spaceId = 200L;
        String objectId = "objectId105";
        String parentObjectId = "parentObjectId";
        String objectType = "objectType16";
        String type = this.userMetadataType.getName();
        String name = "testMetadataaa";
        MetadataObject metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        metadataItemObject.setSpaceId(spaceId);
        MetadataKey metadataKey = new MetadataKey(type, name, audienceId);
        MetadataItem storedMetadataItem = this.metadataService.createMetadataItem(metadataItemObject, metadataKey, creatorId);
        long space2Id = 300L;
        String object2Id = "objectId106";
        MetadataObject metadataItem2Object = this.newMetadataObjectInstance(objectType, object2Id, parentObjectId);
        metadataItem2Object.setSpaceId(space2Id);
        this.metadataService.createMetadataItem(metadataItem2Object, metadataKey, creatorId);
        long audience2Id = creator2Id = Long.parseLong(this.maryIdentity.getId());
        long space3Id = 400L;
        String object3Id = "objectId1107";
        MetadataObject metadataItem3Object = this.newMetadataObjectInstance(objectType, object3Id, parentObjectId);
        metadataItem3Object.setSpaceId(space3Id);
        MetadataKey metadataKey2 = new MetadataKey(type, name, audience2Id);
        MetadataItem storedMetadataItem3 = this.metadataService.createMetadataItem(metadataItem3Object, metadataKey2, creator2Id);
        this.restartTransaction();
        MetadataFilter metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName(name);
        metadataFilter.setMetadataTypeName(type);
        metadataFilter.setMetadataObjectTypes(List.of(objectType));
        metadataFilter.setMetadataSpaceIds(List.of(Long.valueOf(spaceId), Long.valueOf(space3Id)));
        List metadataItems = this.metadataService.getMetadataItemsByFilter(metadataFilter, 0L, 10L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
        MetadataServiceTest.assertEquals((long)storedMetadataItem3.getId(), (long)((MetadataItem)metadataItems.get(0)).getId());
        MetadataServiceTest.assertEquals((long)storedMetadataItem.getId(), (long)((MetadataItem)metadataItems.get(1)).getId());
        objectId = "objectId10598";
        metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        LinkedHashMap<String, String> properties0 = new LinkedHashMap<String, String>();
        properties0.put("onlyOneKey", "value");
        name = "testMetadataPropFilter";
        metadataItemObject.setSpaceId(spaceId);
        this.metadataService.createMetadataItem(metadataItemObject, new MetadataKey(type, name, audienceId), properties0, creatorId);
        metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName(name);
        metadataFilter.setMetadataTypeName(type);
        metadataFilter.setMetadataObjectTypes(List.of(objectType));
        metadataFilter.setMetadataSpaceIds(List.of(Long.valueOf(spaceId), Long.valueOf(space3Id)));
        metadataFilter.setMetadataProperties(properties0);
        metadataFilter.setCreatorId(Long.valueOf(creatorId));
        metadataItems = this.metadataService.getMetadataItemsByFilter(metadataFilter, 0L, 10L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
        objectId = "objectId1058";
        metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        LinkedHashMap<String, String> properties1 = new LinkedHashMap<String, String>();
        properties1.put("staged", String.valueOf(true));
        properties1.put("audience", "all");
        properties1.put("posted", "true");
        properties1.put("otherKey", "value");
        name = "testMetadataPropFilter";
        metadataItemObject.setSpaceId(spaceId);
        this.metadataService.createMetadataItem(metadataItemObject, new MetadataKey(type, name, audienceId), properties1, creatorId);
        objectId = "objectId1059";
        metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        LinkedHashMap<String, String> properties2 = new LinkedHashMap<String, String>();
        properties2.put("staged", String.valueOf(true));
        properties2.put("audience", "spaces");
        properties2.put("posted", "false");
        properties2.put("otherKey", "otherValue");
        name = "testMetadataPropFilter";
        this.metadataService.createMetadataItem(metadataItemObject, new MetadataKey(type, name, audienceId), properties2, creatorId);
        metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName(name);
        metadataFilter.setMetadataTypeName(type);
        metadataFilter.setMetadataObjectTypes(List.of(objectType));
        metadataFilter.setMetadataSpaceIds(List.of(Long.valueOf(spaceId), Long.valueOf(space3Id)));
        metadataFilter.setMetadataProperties(properties1);
        metadataFilter.setCombinedMetadataProperties(properties2);
        metadataFilter.setCreatorId(Long.valueOf(creatorId));
        metadataItems = this.metadataService.getMetadataItemsByFilter(metadataFilter, 0L, 10L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
        objectId = "objectId10585";
        metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        LinkedHashMap<String, String> properties3 = new LinkedHashMap<String, String>();
        properties3.put("otherOnlyOneKey", "value");
        name = "testMetadataPropFilter";
        metadataItemObject.setSpaceId(spaceId);
        this.metadataService.createMetadataItem(metadataItemObject, new MetadataKey(type, name, audienceId), properties3, creatorId);
        objectId = "objectId10586";
        metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        LinkedHashMap<String, String> properties4 = new LinkedHashMap<String, String>();
        properties4.put("otherOnlyOneKey", "otherValue");
        name = "testMetadataPropFilter";
        metadataItemObject.setSpaceId(spaceId);
        this.metadataService.createMetadataItem(metadataItemObject, new MetadataKey(type, name, audienceId), properties4, creatorId);
        metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName(name);
        metadataFilter.setMetadataTypeName(type);
        metadataFilter.setMetadataObjectTypes(List.of(objectType));
        metadataFilter.setMetadataProperties(properties3);
        metadataFilter.setCombinedMetadataProperties(properties4);
        metadataFilter.setCreatorId(Long.valueOf(creatorId));
        metadataItems = this.metadataService.getMetadataItemsByFilter(metadataFilter, 0L, 10L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
    }

    public void testGetMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceIds() throws ObjectAlreadyExistsException {
        long creator2Id;
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        long spaceId = 200L;
        String objectId = "objectId105";
        String parentObjectId = "parentObjectId";
        String objectType = "objectType16";
        String type = this.userMetadataType.getName();
        String name = "testMetadata11";
        MetadataObject metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        metadataItemObject.setSpaceId(spaceId);
        MetadataKey metadataKey = new MetadataKey(type, name, audienceId);
        MetadataItem storedMetadataItem = this.metadataService.createMetadataItem(metadataItemObject, metadataKey, creatorId);
        long space2Id = 300L;
        String object2Id = "objectId106";
        MetadataObject metadataItem2Object = this.newMetadataObjectInstance(objectType, object2Id, parentObjectId);
        metadataItem2Object.setSpaceId(space2Id);
        this.metadataService.createMetadataItem(metadataItem2Object, metadataKey, creatorId);
        long audience2Id = creator2Id = Long.parseLong(this.maryIdentity.getId());
        long space3Id = 400L;
        String object3Id = "objectId1107";
        MetadataObject metadataItem3Object = this.newMetadataObjectInstance(objectType, object3Id, parentObjectId);
        metadataItem3Object.setSpaceId(space3Id);
        MetadataKey metadataKey2 = new MetadataKey(type, name, audience2Id);
        MetadataItem storedMetadataItem3 = this.metadataService.createMetadataItem(metadataItem3Object, metadataKey2, creator2Id);
        this.restartTransaction();
        List metadataItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceIds(name, type, objectType, Arrays.asList(spaceId, space3Id), 0L, 10L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
        MetadataServiceTest.assertEquals((long)storedMetadataItem3.getId(), (long)((MetadataItem)metadataItems.get(0)).getId());
        MetadataServiceTest.assertEquals((long)storedMetadataItem.getId(), (long)((MetadataItem)metadataItems.get(1)).getId());
    }

    public void testGetMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty() throws ObjectAlreadyExistsException {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String objectId = "objectIdTest2";
        String parentObjectId = "parentObjectIdTest2";
        String objectType = "objectTypeTest2";
        String name1 = "testMetadataName1";
        String name2 = "testMetadataName2";
        String type = this.userMetadataType.getName();
        MetadataObject metadataObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("staged", String.valueOf(false));
        this.metadataService.createMetadataItem(metadataObject, new MetadataKey(type, name1, audienceId), properties, creatorId);
        LinkedHashMap<String, String> properties1 = new LinkedHashMap<String, String>();
        properties1.put("staged", String.valueOf(true));
        this.metadataService.createMetadataItem(metadataObject, new MetadataKey(type, name2, audienceId), properties1, creatorId);
        List metadataItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty(name1, type, objectType, "staged", String.valueOf(false), 0L, 10L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
        MetadataServiceTest.assertEquals((String)objectType, (String)((MetadataItem)metadataItems.get(0)).getObjectType());
        MetadataServiceTest.assertEquals((String)type, (String)((MetadataItem)metadataItems.get(0)).getMetadataTypeName());
        metadataItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty(name1, type, objectType, "staged", String.valueOf(true), 0L, 10L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
    }

    public void testGetMetadataItemsByMetadataNameAndTypeAndObject() {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String objectId = "objectIdTestJohn";
        String parentObjectId = "parentObjectIdTestJohn";
        String objectType = "objectTypeTestJohn";
        String name = "testMetadataJohn";
        String type = this.userMetadataType.getName();
        MetadataObject metadataObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        MetadataKey metadataKey = new MetadataKey(type, name, audienceId);
        try {
            this.metadataService.createMetadataItem(metadataObject, metadataKey, creatorId);
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            // empty catch block
        }
        List metadataItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObject(name, type, objectType, 0L, 10L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
        MetadataServiceTest.assertEquals((String)objectType, (String)((MetadataItem)metadataItems.get(0)).getObjectType());
        MetadataServiceTest.assertEquals((String)type, (String)((MetadataItem)metadataItems.get(0)).getMetadataTypeName());
    }

    public void testGetMetadatas() {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String name = "testMetadata1User1";
        try {
            this.metadataService.createMetadata(this.newMetadataInstance(audienceId, creatorId, name, null, this.spaceMetadataType), creatorId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List metadataList = this.metadataService.getMetadatas("space", 100L);
        MetadataServiceTest.assertNotNull((Object)metadataList);
        MetadataServiceTest.assertEquals((int)1, (int)metadataList.size());
    }

    public void testGetReferencedMetadatas() {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String name = "testMetadata1User1";
        String name1 = "testMetadata1User12";
        try {
            Metadata metadata = new Metadata();
            metadata.setType(this.spaceMetadataType);
            metadata.setName(name);
            metadata.setAudienceId(audienceId);
            metadata.setCreatorId(creatorId);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("referenced", "true");
            metadata.setProperties(properties);
            this.metadataService.createMetadata(metadata, creatorId);
            Metadata metadata1 = new Metadata();
            metadata1.setType(this.spaceMetadataType);
            metadata1.setName(name1);
            metadata1.setAudienceId(audienceId);
            metadata1.setCreatorId(creatorId);
            HashMap<String, String> properties1 = new HashMap<String, String>();
            properties1.put("referenced", "false");
            metadata1.setProperties(properties1);
            this.metadataService.createMetadata(metadata1, creatorId);
        }
        catch (IllegalArgumentException metadata) {
            // empty catch block
        }
        List metadataList = this.metadataService.getMetadatasByProperty("referenced", "true", 100L);
        MetadataServiceTest.assertNotNull((Object)metadataList);
        MetadataServiceTest.assertEquals((int)1, (int)metadataList.size());
    }

    public void testGetMetadataItemsByMetadataTypeAndObject() {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String objectId = "objectIdTest";
        String parentObjectId = "parentObjectIdTest";
        String objectType = "objectTypeTest";
        String name = "testMetadataJohn";
        String type = this.userMetadataType.getName();
        MetadataKey metadataKey = new MetadataKey(type, name, audienceId);
        MetadataObject metadataObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        try {
            this.metadataService.createMetadataItem(metadataObject, metadataKey, creatorId);
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            // empty catch block
        }
        List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject(this.userMetadataType.getName(), metadataObject);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
    }

    public void testGetMetadataNamesByMetadataTypeAndObject() {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String objectId = "objectIdTest";
        String parentObjectId = "parentObjectIdTest";
        String objectType = "objectTypeTest";
        String name = "testMetadataJohn";
        String type = this.userMetadataType.getName();
        MetadataKey metadataKey = new MetadataKey(type, name, audienceId);
        MetadataObject metadataObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        try {
            this.metadataService.createMetadataItem(metadataObject, metadataKey, creatorId);
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            // empty catch block
        }
        List metadataNames = this.metadataService.getMetadataNamesByMetadataTypeAndObject(this.userMetadataType.getName(), objectType, objectId);
        MetadataServiceTest.assertNotNull((Object)metadataNames);
        MetadataServiceTest.assertEquals((int)1, (int)metadataNames.size());
    }

    public void testDeleteMetadataItemsByMetadataTypeAndObject() {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String objectId = "objectIdTest1";
        String parentObjectId = "parentObjectIdTest1";
        String objectType = "objectTypeTest1";
        String name = "testMetadataJohn1";
        String type = this.userMetadataType.getName();
        MetadataObject metadataObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        try {
            MetadataKey metadataKey1 = new MetadataKey(type, name, audienceId);
            this.metadataService.createMetadataItem(metadataObject, metadataKey1, creatorId);
            name = "testMetadataJohn2";
            MetadataKey metadataKey2 = new MetadataKey(type, name, audienceId);
            this.metadataService.createMetadataItem(metadataObject, metadataKey2, creatorId);
        }
        catch (ObjectAlreadyExistsException metadataKey1) {
            // empty catch block
        }
        List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject(this.userMetadataType.getName(), metadataObject);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
        this.metadataService.deleteMetadataItemsByMetadataTypeAndObject(this.userMetadataType.getName(), metadataObject);
        metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject(this.userMetadataType.getName(), metadataObject);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
    }

    public void testCreateDuplicatedMetadataItem() throws Exception {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String objectId = "objectId";
        String parentObjectId = "parentObjectId";
        String objectType = "objectType";
        String name = "testMetadata21";
        this.createNewMetadataItem(this.userMetadataType.getName(), name, objectType, objectId, parentObjectId, creatorId, audienceId);
        try {
            this.createNewMetadataItem(this.userMetadataType.getName(), name, objectType, objectId, parentObjectId, creatorId, audienceId);
            MetadataServiceTest.fail((String)"MetadataTypePlugin shouldn't allow to have twice the same object for a same Metadata");
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            // empty catch block
        }
        Space space = this.getSpaceInstance(1, "public", "validation", this.johnIdentity.getRemoteId(), new String[0]);
        space = this.createSpaceNonInitApps(space, this.johnIdentity.getRemoteId(), null);
        Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        long spaceIdentityId = Long.parseLong(spaceIdentity.getId());
        this.createNewMetadataItem(this.spaceMetadataType.getName(), name, objectType, objectId, parentObjectId, creatorId, spaceIdentityId);
        try {
            this.createNewMetadataItem(this.spaceMetadataType.getName(), name, objectType, objectId, parentObjectId, creatorId, spaceIdentityId);
        }
        catch (ObjectAlreadyExistsException e) {
            MetadataServiceTest.fail((String)"MetadataTypePlugin should allow to have twice the same object for a same Metadata");
        }
    }

    public void testDeleteMetadataItemByUserIdentity() throws Exception {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String objectId = "objectId10";
        String parentObjectId = "parentObjectId";
        String objectType = "objectType11";
        String type = this.userMetadataType.getName();
        String name = "testMetadata8";
        MetadataObject metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        MetadataItem storedMetadataItem = this.metadataService.createMetadataItem(metadataItemObject, new MetadataKey(type, name, audienceId), creatorId);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.metadataService.deleteMetadataItem(0L, creatorId));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.metadataService.deleteMetadataItem(storedMetadataItem.getId(), 0L));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.metadataService.deleteMetadataItem(5000L, creatorId));
        MetadataItem deletedMetadataItem = this.metadataService.deleteMetadataItem(storedMetadataItem.getId(), creatorId);
        MetadataServiceTest.assertNotNull((Object)deletedMetadataItem);
        MetadataServiceTest.assertTrue((deletedMetadataItem.getId() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertTrue((deletedMetadataItem.getCreatedDate() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertEquals((long)creatorId, (long)deletedMetadataItem.getCreatorId());
        MetadataServiceTest.assertNotNull((Object)deletedMetadataItem.getMetadata());
        MetadataServiceTest.assertEquals((long)audienceId, (long)deletedMetadataItem.getMetadata().getAudienceId());
        MetadataServiceTest.assertEquals((String)name, (String)deletedMetadataItem.getMetadata().getName());
        MetadataServiceTest.assertEquals((Object)this.userMetadataType, (Object)deletedMetadataItem.getMetadata().getType());
        MetadataServiceTest.assertEquals((String)parentObjectId, (String)deletedMetadataItem.getParentObjectId());
        MetadataServiceTest.assertEquals((String)objectId, (String)deletedMetadataItem.getObjectId());
        MetadataServiceTest.assertEquals((String)objectType, (String)deletedMetadataItem.getObjectType());
        List<MetadataItem> metadataItems = this.getMetadataItemsByObject(objectType, objectId);
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
    }

    public void testDeleteMetadataItem() throws Exception {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String objectId = "objectId100";
        String parentObjectId = "parentObjectId";
        String objectType = "objectType11";
        String type = this.userMetadataType.getName();
        String name = "testMetadata8";
        MetadataObject metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        MetadataItem storedMetadataItem = this.metadataService.createMetadataItem(metadataItemObject, new MetadataKey(type, name, audienceId), creatorId);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.metadataService.deleteMetadataItem(0L, true));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.metadataService.deleteMetadataItem(5000L, true));
        MetadataItem deletedMetadataItem = this.metadataService.deleteMetadataItem(storedMetadataItem.getId(), true);
        MetadataServiceTest.assertNotNull((Object)deletedMetadataItem);
        MetadataServiceTest.assertTrue((deletedMetadataItem.getId() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertTrue((deletedMetadataItem.getCreatedDate() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertEquals((long)creatorId, (long)deletedMetadataItem.getCreatorId());
        MetadataServiceTest.assertNotNull((Object)deletedMetadataItem.getMetadata());
        MetadataServiceTest.assertEquals((long)audienceId, (long)deletedMetadataItem.getMetadata().getAudienceId());
        MetadataServiceTest.assertEquals((String)name, (String)deletedMetadataItem.getMetadata().getName());
        MetadataServiceTest.assertEquals((Object)this.userMetadataType, (Object)deletedMetadataItem.getMetadata().getType());
        MetadataServiceTest.assertEquals((String)parentObjectId, (String)deletedMetadataItem.getParentObjectId());
        MetadataServiceTest.assertEquals((String)objectId, (String)deletedMetadataItem.getObjectId());
        MetadataServiceTest.assertEquals((String)objectType, (String)deletedMetadataItem.getObjectType());
        List<MetadataItem> metadataItems = this.getMetadataItemsByObject(objectType, objectId);
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
    }

    public void testDeleteMetadataItemsBySpaceId() throws Exception {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        long spaceId = 200L;
        String objectId = "objectId100";
        String parentObjectId = "parentObjectId";
        String objectType = "objectType11";
        String type = this.userMetadataType.getName();
        String name = "testMetadata8";
        MetadataObject metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        metadataItemObject.setSpaceId(spaceId);
        MetadataKey metadataKey = new MetadataKey(type, name, audienceId);
        MetadataItem storedMetadataItem = this.metadataService.createMetadataItem(metadataItemObject, metadataKey, creatorId);
        MetadataServiceTest.assertNotNull((Object)storedMetadataItem);
        MetadataServiceTest.assertTrue((storedMetadataItem.getId() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertTrue((storedMetadataItem.getCreatedDate() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertEquals((long)creatorId, (long)storedMetadataItem.getCreatorId());
        MetadataServiceTest.assertNotNull((Object)storedMetadataItem.getMetadata());
        MetadataServiceTest.assertEquals((long)audienceId, (long)storedMetadataItem.getMetadata().getAudienceId());
        MetadataServiceTest.assertEquals((String)name, (String)storedMetadataItem.getMetadata().getName());
        MetadataServiceTest.assertEquals((Object)this.userMetadataType, (Object)storedMetadataItem.getMetadata().getType());
        MetadataServiceTest.assertEquals((String)parentObjectId, (String)storedMetadataItem.getParentObjectId());
        MetadataServiceTest.assertEquals((String)objectId, (String)storedMetadataItem.getObjectId());
        MetadataServiceTest.assertEquals((String)objectType, (String)storedMetadataItem.getObjectType());
        MetadataServiceTest.assertEquals((long)spaceId, (long)storedMetadataItem.getSpaceId());
        List<MetadataItem> metadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, metadataItemObject);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
        storedMetadataItem = (MetadataItem)metadataItems.get(0);
        MetadataServiceTest.assertNotNull((Object)storedMetadataItem);
        MetadataServiceTest.assertTrue((storedMetadataItem.getId() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertTrue((storedMetadataItem.getCreatedDate() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertEquals((long)creatorId, (long)storedMetadataItem.getCreatorId());
        MetadataServiceTest.assertNotNull((Object)storedMetadataItem.getMetadata());
        MetadataServiceTest.assertEquals((long)audienceId, (long)storedMetadataItem.getMetadata().getAudienceId());
        MetadataServiceTest.assertEquals((String)name, (String)storedMetadataItem.getMetadata().getName());
        MetadataServiceTest.assertEquals((Object)this.userMetadataType, (Object)storedMetadataItem.getMetadata().getType());
        MetadataServiceTest.assertEquals((String)parentObjectId, (String)storedMetadataItem.getParentObjectId());
        MetadataServiceTest.assertEquals((String)objectId, (String)storedMetadataItem.getObjectId());
        MetadataServiceTest.assertEquals((String)objectType, (String)storedMetadataItem.getObjectType());
        MetadataServiceTest.assertEquals((long)spaceId, (long)storedMetadataItem.getSpaceId());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.metadataService.deleteMetadataBySpaceId(0L));
        MetadataServiceTest.assertEquals((int)0, (int)this.metadataService.deleteMetadataBySpaceId(spaceId + 1L));
        MetadataServiceTest.assertEquals((int)1, (int)this.metadataService.deleteMetadataBySpaceId(spaceId));
        metadataItems = this.getMetadataItemsByObject(objectType, objectId);
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
    }

    public void testDeleteMetadataItemsBySpaceIdAndAudienceId() throws Exception {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        long spaceId = 200L;
        String objectId = "objectId100";
        String parentObjectId = "parentObjectId";
        String objectType = "objectType11";
        String type = this.userMetadataType.getName();
        String name = "testMetadata8";
        MetadataObject metadataItemObject = this.newMetadataObjectInstance(objectType, objectId, parentObjectId);
        metadataItemObject.setSpaceId(spaceId);
        MetadataKey metadataKey = new MetadataKey(type, name, audienceId);
        MetadataItem storedMetadataItem = this.metadataService.createMetadataItem(metadataItemObject, metadataKey, creatorId);
        MetadataServiceTest.assertNotNull((Object)storedMetadataItem);
        MetadataServiceTest.assertTrue((storedMetadataItem.getId() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertTrue((storedMetadataItem.getCreatedDate() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertEquals((long)creatorId, (long)storedMetadataItem.getCreatorId());
        MetadataServiceTest.assertNotNull((Object)storedMetadataItem.getMetadata());
        MetadataServiceTest.assertEquals((long)audienceId, (long)storedMetadataItem.getMetadata().getAudienceId());
        MetadataServiceTest.assertEquals((String)name, (String)storedMetadataItem.getMetadata().getName());
        MetadataServiceTest.assertEquals((Object)this.userMetadataType, (Object)storedMetadataItem.getMetadata().getType());
        MetadataServiceTest.assertEquals((String)parentObjectId, (String)storedMetadataItem.getParentObjectId());
        MetadataServiceTest.assertEquals((String)objectId, (String)storedMetadataItem.getObjectId());
        MetadataServiceTest.assertEquals((String)objectType, (String)storedMetadataItem.getObjectType());
        MetadataServiceTest.assertEquals((long)spaceId, (long)storedMetadataItem.getSpaceId());
        List<MetadataItem> metadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, metadataItemObject);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
        storedMetadataItem = (MetadataItem)metadataItems.get(0);
        MetadataServiceTest.assertNotNull((Object)storedMetadataItem);
        MetadataServiceTest.assertTrue((storedMetadataItem.getId() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertTrue((storedMetadataItem.getCreatedDate() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertEquals((long)creatorId, (long)storedMetadataItem.getCreatorId());
        MetadataServiceTest.assertNotNull((Object)storedMetadataItem.getMetadata());
        MetadataServiceTest.assertEquals((long)audienceId, (long)storedMetadataItem.getMetadata().getAudienceId());
        MetadataServiceTest.assertEquals((String)name, (String)storedMetadataItem.getMetadata().getName());
        MetadataServiceTest.assertEquals((Object)this.userMetadataType, (Object)storedMetadataItem.getMetadata().getType());
        MetadataServiceTest.assertEquals((String)parentObjectId, (String)storedMetadataItem.getParentObjectId());
        MetadataServiceTest.assertEquals((String)objectId, (String)storedMetadataItem.getObjectId());
        MetadataServiceTest.assertEquals((String)objectType, (String)storedMetadataItem.getObjectType());
        MetadataServiceTest.assertEquals((long)spaceId, (long)storedMetadataItem.getSpaceId());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.metadataService.deleteMetadataBySpaceIdAndAudienceId(0L, audienceId));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.metadataService.deleteMetadataBySpaceIdAndAudienceId(spaceId, 0L));
        MetadataServiceTest.assertEquals((int)0, (int)this.metadataService.deleteMetadataBySpaceIdAndAudienceId(spaceId + 1L, audienceId));
        MetadataServiceTest.assertEquals((int)1, (int)this.metadataService.deleteMetadataBySpaceIdAndAudienceId(spaceId, audienceId));
        metadataItems = this.getMetadataItemsByObject(objectType, objectId);
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
    }

    public void testGetMetadataItemsByObject() throws Exception {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String type = this.userMetadataType.getName();
        this.createNewMetadataItem(type, "testMetadata5", "objectType1", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata5", "objectType1", "objectId2", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata6", "objectType1", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata6", "objectType2", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata6", "objectType3", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata5", "objectType4", "objectId1", "parentObjectId1", creatorId, audienceId);
        List<MetadataItem> metadataItems = this.getMetadataItemsByObject("objectType1", "objectId1");
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
        metadataItems = this.getMetadataItemsByObject("objectType2", "objectId2");
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
        metadataItems = this.getMetadataItemsByObject("objectType2", "objectId1");
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
    }

    public void testGetMetadataItemsByMetadataTypeAndCreator() throws Exception {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String type = this.userMetadataType.getName();
        this.createNewMetadataItem(type, "testMetadata1", "objectType1", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata2", "objectType1", "objectId2", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata3", "objectType2", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata4", "objectType2", "objectId1", "parentObjectId1", creatorId, audienceId);
        List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndCreator("space", creatorId, 0L, 2L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
        metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndCreator("space", 100L, 0L, 5L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
        metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndCreator(type, creatorId, 0L, 5L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)4, (int)metadataItems.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetMetadataObjectIds() throws Exception {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String type = this.userMetadataType.getName();
        ArrayList<CallSite> objectIds = new ArrayList<CallSite>();
        allowMultipleItemsPerObject = true;
        try {
            String objectId;
            int i;
            for (i = 0; i < 10; ++i) {
                objectId = "objectId-" + i;
                this.createNewMetadataItem(type, "testMetadata50", "objectType1", objectId, "parentObjectId1", creatorId, audienceId);
                objectIds.add(0, (CallSite)((Object)objectId));
                this.restartTransaction();
            }
            for (i = 19; i > 9; --i) {
                objectId = "objectId-" + (30 - i);
                this.createNewMetadataItem(type, "testMetadata50", "objectType1", objectId, "parentObjectId1", creatorId, audienceId);
                objectIds.add(0, (CallSite)((Object)objectId));
                this.restartTransaction();
            }
        }
        finally {
            allowMultipleItemsPerObject = false;
        }
        this.restartTransaction();
        this.createNewMetadataItem(type, "testMetadata6", "objectType1", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.restartTransaction();
        this.createNewMetadataItem(type, "testMetadata6", "objectType2", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata6", "objectType3", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata6", "objectType4", "objectId1", "parentObjectId1", creatorId, audienceId);
        List metadataItems = this.metadataService.getMetadataObjectIds(type, "testMetadata50", "objectType1", 0L, 2L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
        MetadataServiceTest.assertEquals((String)((String)objectIds.get(0)), (String)((String)metadataItems.get(0)));
        MetadataServiceTest.assertEquals((String)((String)objectIds.get(1)), (String)((String)metadataItems.get(1)));
        metadataItems = this.metadataService.getMetadataObjectIds(type, "testMetadata50", "objectType1", 1L, 1L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
        MetadataServiceTest.assertEquals((String)((String)objectIds.get(1)), (String)((String)metadataItems.get(0)));
        metadataItems = this.metadataService.getMetadataObjectIds(type, "testMetadata50", "objectType1", 0L, 1L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
        MetadataServiceTest.assertEquals((String)((String)objectIds.get(0)), (String)((String)metadataItems.get(0)));
        metadataItems = this.metadataService.getMetadataObjectIds(type, "testMetadata50", "objectType1", 0L, 20L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)20, (int)metadataItems.size());
        for (int i = 0; i < metadataItems.size(); ++i) {
            MetadataServiceTest.assertEquals((String)((String)objectIds.get(i)), (String)((String)metadataItems.get(i)));
        }
        metadataItems = this.metadataService.getMetadataObjectIds(type, "testMetadata5", "objectType2", 0L, 1L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
        metadataItems = this.metadataService.getMetadataObjectIds(type, "testMetadata6", "objectType2", 0L, 5L);
        MetadataServiceTest.assertNotNull((Object)metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
    }

    public void testDeleteMetadataItemsByObject() throws Exception {
        long creatorId;
        long audienceId = creatorId = Long.parseLong(this.johnIdentity.getId());
        String type = this.userMetadataType.getName();
        this.createNewMetadataItem(type, "testMetadata15", "objectType11", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata15", "objectType11", "objectId2", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata16", "objectType11", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata16", "objectType12", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata16", "objectType13", "objectId1", "parentObjectId1", creatorId, audienceId);
        this.createNewMetadataItem(type, "testMetadata15", "objectType14", "objectId1", "parentObjectId1", creatorId, audienceId);
        List<MetadataItem> metadataItems = this.getMetadataItemsByObject("objectType11", "objectId1");
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
        metadataItems = this.getMetadataItemsByObject("objectType12", "objectId2");
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
        metadataItems = this.getMetadataItemsByObject("objectType12", "objectId1");
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
        this.metadataService.deleteMetadataItemsByObject(new MetadataObject("objectType11", "objectId1"));
        metadataItems = this.getMetadataItemsByObject("objectType11", "objectId1");
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
        metadataItems = this.getMetadataItemsByObject("objectType12", "objectId2");
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
        metadataItems = this.getMetadataItemsByObject("objectType12", "objectId1");
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShareMetadataItemsByObject() throws Exception {
        long creatorId = Long.parseLong(this.johnIdentity.getId());
        long audienceId1 = 10000L;
        long audienceId2 = 10001L;
        String type = this.userMetadataType.getName();
        String objectType1 = "objectType11";
        String objectId1 = "objectId1";
        String objectId2 = "objectId2";
        String metadataName1 = "testMetadata15";
        String metadataName2 = "testMetadata16";
        this.createNewMetadataItem(type, metadataName1, objectType1, objectId1, "parentObjectId1", creatorId, audienceId1);
        this.createNewMetadataItem(type, metadataName1, objectType1, objectId2, "parentObjectId1", creatorId, audienceId1);
        this.createNewMetadataItem(type, metadataName1, objectType1, objectId2, "parentObjectId1", creatorId, audienceId2);
        this.createNewMetadataItem(type, metadataName2, objectType1, objectId1, "parentObjectId1", creatorId, audienceId1);
        this.createNewMetadataItem(type, metadataName2, "objectType12", objectId1, "parentObjectId1", creatorId, audienceId1);
        this.createNewMetadataItem(type, metadataName2, "objectType13", objectId1, "parentObjectId1", creatorId, audienceId1);
        this.createNewMetadataItem(type, metadataName1, "objectType14", objectId1, "parentObjectId1", creatorId, audienceId1);
        this.createNewMetadataItem(type, metadataName1, "objectType14", objectId1, "parentObjectId1", creatorId, audienceId2);
        List<MetadataItem> metadataItems = this.getMetadataItemsByObject(objectType1, objectId1);
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
        metadataItems = this.getMetadataItemsByObject(objectType1, objectId2);
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
        this.metadataService.shareMetadataItemsByObject(new MetadataObject(objectType1, objectId1), objectId2, audienceId2, Long.parseLong(this.maryIdentity.getId()));
        metadataItems = this.getMetadataItemsByObject(objectType1, objectId1);
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
        metadataItems = this.getMetadataItemsByObject(objectType1, objectId2);
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
        shareable = true;
        try {
            this.metadataService.shareMetadataItemsByObject(new MetadataObject(objectType1, objectId1), objectId2, audienceId2, Long.parseLong(this.maryIdentity.getId()));
            metadataItems = this.getMetadataItemsByObject(objectType1, objectId1);
            MetadataServiceTest.assertNotNull(metadataItems);
            MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
            metadataItems = this.getMetadataItemsByObject(objectType1, objectId2);
            MetadataServiceTest.assertNotNull(metadataItems);
            MetadataServiceTest.assertEquals((int)3, (int)metadataItems.size());
        }
        finally {
            shareable = false;
        }
    }

    public void testDeleteMetadataItemsByParentObject() throws Exception {
        long creatorId = Long.parseLong(this.johnIdentity.getId());
        long audienceId1 = 10000L;
        long audienceId2 = 10001L;
        String type = this.userMetadataType.getName();
        String objectType1 = "objectType11";
        String objectType2 = "objectType17";
        String objectId1 = "objectId1";
        String objectId2 = "objectId2";
        String metadataName1 = "testMetadata15";
        String metadataName2 = "testMetadata16";
        String parentObjectId = "parentObjectId1";
        String parentObjectId2 = "parentObjectId2";
        this.createNewMetadataItem(type, metadataName1, objectType1, objectId1, parentObjectId, creatorId, audienceId1);
        this.createNewMetadataItem(type, metadataName1, objectType1, objectId2, parentObjectId, creatorId, audienceId1);
        this.createNewMetadataItem(type, metadataName2, objectType1, objectId1, parentObjectId, creatorId, audienceId1);
        this.createNewMetadataItem(type, metadataName2, "objectType12", objectId1, parentObjectId, creatorId, audienceId1);
        this.createNewMetadataItem(type, metadataName2, "objectType13", objectId1, parentObjectId, creatorId, audienceId1);
        this.createNewMetadataItem(type, metadataName1, "objectType14", objectId1, parentObjectId, creatorId, audienceId1);
        this.createNewMetadataItem(type, metadataName1, "objectType14", objectId1, parentObjectId, creatorId, audienceId2);
        this.createNewMetadataItem(type, metadataName1, objectType2, objectId1, parentObjectId2, creatorId, audienceId2);
        List<MetadataItem> metadataItems = this.getMetadataItemsByObject(objectType1, objectId1);
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)2, (int)metadataItems.size());
        metadataItems = this.getMetadataItemsByObject(objectType2, objectId1);
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
        this.metadataService.deleteMetadataItemsByParentObject(new MetadataObject(objectType1, null, parentObjectId));
        metadataItems = this.getMetadataItemsByObject(objectType1, objectId1);
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)0, (int)metadataItems.size());
        metadataItems = this.getMetadataItemsByObject(objectType2, objectId1);
        MetadataServiceTest.assertNotNull(metadataItems);
        MetadataServiceTest.assertEquals((int)1, (int)metadataItems.size());
    }

    public void testFindMetadataNamesByCreator() throws Exception {
        String objectId = "objectId";
        String parentObjectId = "parentObjectId";
        String objectType = "objectType";
        String type = this.userMetadataType.getName();
        ArrayList<Space> spaces = new ArrayList<Space>();
        ArrayList<Long> spaceCreators = new ArrayList<Long>();
        Space space = this.createSpace("FindMetadataNamesByCreator1", this.maryIdentity.getRemoteId(), this.maryIdentity.getRemoteId());
        spaces.add(space);
        spaceCreators.add(Long.parseLong(this.maryIdentity.getId()));
        space = this.createSpace("FindMetadataNamesByCreator2", this.johnIdentity.getRemoteId(), this.johnIdentity.getRemoteId());
        spaces.add(space);
        spaceCreators.add(Long.parseLong(this.johnIdentity.getId()));
        space = this.createSpace("FindMetadataNamesByCreator3", this.maryIdentity.getRemoteId(), this.johnIdentity.getRemoteId(), this.maryIdentity.getRemoteId());
        spaces.add(space);
        spaceCreators.add(Long.parseLong(this.maryIdentity.getId()));
        List<String> metadataNames = Arrays.asList("foo", "bar", "baz", "qux", "quux", "bar", "baz", "qux", "quux", "quuz", "corge", "grault", "garply", "waldo", "fred", "plugh", "xyzzy", "thud", "Wibble", "WOBBLE", "WUBBLE", "FLOB", "FOO", "BAR", "BAZ", "QUX", "QUUX", "QUUZ", "CORGE", "GRAULT", "GARPLY", "WALDO", "FRED", "PLUGH", "XYZZY", "THUD", "WIBBLE", "WOBBLE", "WUBBLE", "FLOB");
        for (int i = 0; i < metadataNames.size(); ++i) {
            long audienceId = Long.parseLong(((Space)spaces.get(i % 3)).getId());
            MetadataKey metadataKey = new MetadataKey(type, metadataNames.get(i), audienceId);
            MetadataObject metadataObject = this.newMetadataObjectInstance(objectType, objectId + i, parentObjectId);
            this.metadataService.createMetadataItem(metadataObject, metadataKey, ((Long)spaceCreators.get(i % 3)).longValue());
        }
        List allUserNames = this.metadataService.findMetadataNamesByCreator(null, type, Long.parseLong(this.rootIdentity.getId()), 100L);
        MetadataServiceTest.assertNotNull((Object)allUserNames);
        MetadataServiceTest.assertEquals((int)0, (int)allUserNames.size());
        allUserNames = this.metadataService.findMetadataNamesByCreator(null, type, Long.parseLong(this.maryIdentity.getId()), 100L);
        MetadataServiceTest.assertNotNull((Object)allUserNames);
        MetadataServiceTest.assertEquals((int)24, (int)allUserNames.size());
        String term = "ar";
        int count = this.countTerms(allUserNames, term);
        List names = this.metadataService.findMetadataNamesByCreator(term, type, Long.parseLong(this.maryIdentity.getId()), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        term = "az";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByCreator(term, type, Long.parseLong(this.maryIdentity.getId()), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        term = "oo";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByCreator(term, type, Long.parseLong(this.maryIdentity.getId()), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        allUserNames = this.metadataService.findMetadataNamesByCreator(null, type, Long.parseLong(this.johnIdentity.getId()), 100L);
        MetadataServiceTest.assertNotNull((Object)allUserNames);
        MetadataServiceTest.assertEquals((int)12, (int)allUserNames.size());
        term = "ar";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByCreator(term, type, Long.parseLong(this.johnIdentity.getId()), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        term = "az";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByCreator(term, type, Long.parseLong(this.johnIdentity.getId()), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        term = "oo";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByCreator(term, type, Long.parseLong(this.johnIdentity.getId()), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
    }

    public void testFindMetadataNamesByAudiences() throws Exception {
        String objectId = "objectId";
        String parentObjectId = "parentObjectId";
        String objectType = "objectType";
        String type = this.userMetadataType.getName();
        ArrayList<Space> spaces = new ArrayList<Space>();
        ArrayList<Long> spaceIds = new ArrayList<Long>();
        ArrayList<Long> spaceCreators = new ArrayList<Long>();
        Space space = this.createSpace("FindMetadataNamesByAudiences1", this.maryIdentity.getRemoteId(), this.maryIdentity.getRemoteId());
        spaces.add(space);
        spaceCreators.add(Long.parseLong(this.maryIdentity.getId()));
        spaceIds.add(Long.parseLong(space.getId()));
        space = this.createSpace("FindMetadataNamesByAudiences2", this.johnIdentity.getRemoteId(), this.johnIdentity.getRemoteId());
        spaces.add(space);
        spaceCreators.add(Long.parseLong(this.johnIdentity.getId()));
        spaceIds.add(Long.parseLong(space.getId()));
        space = this.createSpace("FindMetadataNamesByAudiences3", this.maryIdentity.getRemoteId(), this.johnIdentity.getRemoteId(), this.maryIdentity.getRemoteId());
        spaces.add(space);
        spaceCreators.add(Long.parseLong(this.maryIdentity.getId()));
        spaceIds.add(Long.parseLong(space.getId()));
        List<String> metadataNames = Arrays.asList("foo", "bar", "baz", "qux", "quux", "bar", "baz", "qux", "quux", "quuz", "corge", "grault", "garply", "waldo", "fred", "plugh", "xyzzy", "thud", "Wibble", "WOBBLE", "WUBBLE", "FLOB", "FOO", "BAR", "BAZ", "QUX", "QUUX", "QUUZ", "CORGE", "GRAULT", "GARPLY", "WALDO", "FRED", "PLUGH", "XYZZY", "THUD", "WIBBLE", "WOBBLE", "WUBBLE", "FLOB");
        for (int i = 0; i < metadataNames.size(); ++i) {
            long audienceId = Long.parseLong(((Space)spaces.get(i % 3)).getId());
            MetadataKey metadataKey = new MetadataKey(type, metadataNames.get(i), audienceId);
            MetadataObject metadataObject = this.newMetadataObjectInstance(objectType, objectId + i, parentObjectId);
            this.metadataService.createMetadataItem(metadataObject, metadataKey, ((Long)spaceCreators.get(i % 3)).longValue());
        }
        List allUserNames = this.metadataService.findMetadataNamesByAudiences(null, type, Collections.emptySet(), 100L);
        MetadataServiceTest.assertNotNull((Object)allUserNames);
        MetadataServiceTest.assertEquals((int)0, (int)allUserNames.size());
        allUserNames = this.metadataService.findMetadataNamesByAudiences(null, type, Collections.singleton((Long)spaceIds.get(0)), 100L);
        MetadataServiceTest.assertNotNull((Object)allUserNames);
        MetadataServiceTest.assertEquals((int)13, (int)allUserNames.size());
        String term = "ar";
        int count = this.countTerms(allUserNames, term);
        List names = this.metadataService.findMetadataNamesByAudiences(term, type, Collections.singleton((Long)spaceIds.get(0)), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        term = "az";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByAudiences(term, type, Collections.singleton((Long)spaceIds.get(0)), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        term = "oo";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByAudiences(term, type, Collections.singleton((Long)spaceIds.get(0)), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        allUserNames = this.metadataService.findMetadataNamesByAudiences(null, type, Collections.singleton((Long)spaceIds.get(1)), 100L);
        MetadataServiceTest.assertNotNull((Object)allUserNames);
        MetadataServiceTest.assertEquals((int)12, (int)allUserNames.size());
        term = "ar";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByAudiences(term, type, Collections.singleton((Long)spaceIds.get(1)), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        term = "az";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByAudiences(term, type, Collections.singleton((Long)spaceIds.get(1)), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        term = "oo";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByAudiences(term, type, Collections.singleton((Long)spaceIds.get(1)), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        allUserNames = this.metadataService.findMetadataNamesByAudiences(null, type, Collections.singleton((Long)spaceIds.get(2)), 100L);
        MetadataServiceTest.assertNotNull((Object)allUserNames);
        MetadataServiceTest.assertEquals((int)12, (int)allUserNames.size());
        term = "ar";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByAudiences(term, type, Collections.singleton((Long)spaceIds.get(2)), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        term = "az";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByAudiences(term, type, Collections.singleton((Long)spaceIds.get(2)), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
        term = "oo";
        count = this.countTerms(allUserNames, term);
        names = this.metadataService.findMetadataNamesByAudiences(term, type, Collections.singleton((Long)spaceIds.get(2)), 100L);
        MetadataServiceTest.assertNotNull((Object)names);
        MetadataServiceTest.assertEquals((int)count, (int)names.size());
    }

    public void testAddMetadataInitPlugin() {
        InitParams params = new InitParams();
        Metadata metadata = new Metadata();
        metadata.setAudienceId(2L);
        metadata.setName("test8");
        metadata.setType(this.userMetadataType);
        metadata.setProperties(Collections.singletonMap("propName", "propValue"));
        ObjectParameter parameter = new ObjectParameter();
        parameter.setName("metadata");
        parameter.setObject((Object)metadata);
        params.addParameter((Parameter)parameter);
        MetadataInitPlugin initPlugin = new MetadataInitPlugin(params);
        this.metadataService.addMetadataPlugin(initPlugin);
        ((Startable)this.metadataService).start();
        Metadata storedMetadata = this.metadataService.getMetadataByKey(new MetadataKey(metadata.getTypeName(), metadata.getName(), metadata.getAudienceId()));
        MetadataServiceTest.assertNotNull((Object)storedMetadata);
        MetadataServiceTest.assertEquals((String)metadata.getName(), (String)storedMetadata.getName());
        MetadataServiceTest.assertEquals((String)metadata.getTypeName(), (String)storedMetadata.getTypeName());
        MetadataServiceTest.assertEquals((long)metadata.getAudienceId(), (long)storedMetadata.getAudienceId());
        MetadataServiceTest.assertEquals((Object)metadata.getProperties(), (Object)storedMetadata.getProperties());
        MetadataServiceTest.assertTrue((storedMetadata.getCreatedDate() > 0L ? 1 : 0) != 0);
        MetadataServiceTest.assertEquals((long)0L, (long)storedMetadata.getCreatorId());
    }

    private int countTerms(List<String> names, String term) {
        return (int)names.stream().filter(name -> StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)term)).count();
    }

    private List<MetadataItem> getMetadataItemsByObject(String objectType, String objectId) {
        return this.metadataService.getMetadataItemsByObject(new MetadataObject(objectType, objectId));
    }

    private MetadataItem createNewMetadataItem(String type, String name, String objectType, String objectId, String parentObjectId, long creatorId, long audienceId) throws ObjectAlreadyExistsException {
        MetadataItem metadataItem = new MetadataItem();
        metadataItem.setObjectId(objectId);
        metadataItem.setObjectType(objectType);
        metadataItem.setParentObjectId(parentObjectId);
        return this.metadataService.createMetadataItem(metadataItem.getObject(), new MetadataKey(type, name, audienceId), creatorId);
    }

    private InitParams newParam(long id, String name) {
        InitParams params = new InitParams();
        MetadataType metadataType = new MetadataType(id, name);
        ObjectParameter parameter = new ObjectParameter();
        parameter.setName("metadataType");
        parameter.setObject((Object)metadataType);
        params.addParameter((Parameter)parameter);
        return params;
    }

    private MetadataObject newMetadataObjectInstance(String objectType, String objectId, String parentObjectId) {
        return new MetadataObject(objectType, objectId, parentObjectId);
    }

    private Metadata newMetadataInstance(long audienceId, long creatorId, String name, Map<String, String> properties, MetadataType metadataType) {
        Metadata metadata = new Metadata();
        metadata.setAudienceId(audienceId);
        metadata.setCreatorId(creatorId);
        metadata.setName(name);
        metadata.setType(metadataType);
        metadata.setProperties(properties);
        return metadata;
    }

    private Space createSpace(String spaceName, String creator, String ... members) {
        String[] stringArray;
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(spaceName);
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setDescription("description of space" + spaceName);
        space.setVisibility("private");
        space.setRegistration("open");
        String[] managers = new String[]{creator};
        if (members == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = creator;
        } else {
            stringArray = members;
        }
        String[] spaceMembers = stringArray;
        space.setManagers(managers);
        space.setMembers(spaceMembers);
        return this.spaceService.createSpace(space);
    }
}

