/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.binding.listener;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingReportAction;
import org.exoplatform.social.core.binding.model.UserSpaceBinding;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SpaceBindingUserEventListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(SpaceBindingUserEventListener.class);
    private GroupSpaceBindingService groupSpaceBindingService;
    private SpaceService spaceService;

    public void preSetEnabled(User user) throws Exception {
        if (!user.isEnabled()) {
            this.removeAllUserBindings(user);
        }
    }

    public void postSetEnabled(User user) throws Exception {
        if (user.isEnabled()) {
            this.createAllUserBindings(user);
        }
    }

    public void postDelete(User user) throws Exception {
        this.removeAllUserBindings(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAllUserBindings(User user) {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            this.groupSpaceBindingService = (GroupSpaceBindingService)CommonsUtils.getService(GroupSpaceBindingService.class);
            this.spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            Collection groups = organizationService.getGroupHandler().findGroupsOfUser(user.getUserName());
            groups.stream().filter(group -> !this.isASpaceGroup(group.getGroupName())).forEach(group -> {
                List<GroupSpaceBinding> groupSpaceBindings = this.groupSpaceBindingService.findGroupSpaceBindingsByGroup(group.getId());
                for (GroupSpaceBinding groupSpaceBinding : groupSpaceBindings) {
                    Space space = this.spaceService.getSpaceById(groupSpaceBinding.getSpaceId());
                    long startTime = System.currentTimeMillis();
                    GroupSpaceBindingReportAction bindingReportAddSynchronizeAction = this.groupSpaceBindingService.findGroupSpaceBindingReportAction(groupSpaceBinding.getId(), "SYNCHRONIZE");
                    if (bindingReportAddSynchronizeAction == null) {
                        GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(groupSpaceBinding.getId(), Long.parseLong(groupSpaceBinding.getSpaceId()), groupSpaceBinding.getGroup(), "SYNCHRONIZE");
                        bindingReportAddSynchronizeAction = this.groupSpaceBindingService.saveGroupSpaceBindingReport(report);
                    }
                    this.groupSpaceBindingService.saveUserBinding(user.getUserName(), groupSpaceBinding, space, bindingReportAddSynchronizeAction);
                    bindingReportAddSynchronizeAction.setEndDate(new Date());
                    this.groupSpaceBindingService.updateGroupSpaceBindingReportAction(bindingReportAddSynchronizeAction);
                    long totalTime = System.currentTimeMillis() - startTime;
                    LOG.info("service={} operation={} parameters=\"space:{},totalSpaceMembers:{},boundSpaceMembers:{}\" status=ok duration_ms={}", new Object[]{"group-binding", "update-binding", space.getPrettyName(), space.getMembers().length, this.groupSpaceBindingService.countBoundUsers(space.getId()), totalTime});
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Problem occurred when creating user bindings for user ({}): ", new Object[]{user.getUserName(), e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllUserBindings(User user) {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            this.groupSpaceBindingService = (GroupSpaceBindingService)CommonsUtils.getService(GroupSpaceBindingService.class);
            this.spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            List<UserSpaceBinding> userSpaceBindings = this.groupSpaceBindingService.findUserBindingsByUser(user.getUserName());
            for (UserSpaceBinding userSpaceBinding : userSpaceBindings) {
                Space space = this.spaceService.getSpaceById(userSpaceBinding.getGroupBinding().getSpaceId());
                long startTime = System.currentTimeMillis();
                GroupSpaceBindingReportAction bindingReportAddSynchronizeAction = this.groupSpaceBindingService.findGroupSpaceBindingReportAction(userSpaceBinding.getGroupBinding().getId(), "SYNCHRONIZE");
                if (bindingReportAddSynchronizeAction == null) {
                    GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(userSpaceBinding.getGroupBinding().getId(), Long.parseLong(userSpaceBinding.getGroupBinding().getSpaceId()), userSpaceBinding.getGroupBinding().getGroup(), "SYNCHRONIZE");
                    bindingReportAddSynchronizeAction = this.groupSpaceBindingService.saveGroupSpaceBindingReport(report);
                }
                this.groupSpaceBindingService.deleteUserBinding(userSpaceBinding, bindingReportAddSynchronizeAction);
                bindingReportAddSynchronizeAction.setEndDate(new Date());
                this.groupSpaceBindingService.updateGroupSpaceBindingReportAction(bindingReportAddSynchronizeAction);
                long totalTime = System.currentTimeMillis() - startTime;
                LOG.info("service={} operation={} parameters=\"space:{},totalSpaceMembers:{},boundSpaceMembers:{}\" status=ok duration_ms={}", new Object[]{"group-binding", "update-binding", space.getPrettyName(), space.getMembers().length, this.groupSpaceBindingService.countBoundUsers(space.getId()), totalTime});
            }
        }
        catch (Exception e) {
            LOG.warn("Problem occurred when removing user bindings for user ({}): ", new Object[]{user.getUserName(), e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private boolean isASpaceGroup(String groupName) {
        return groupName.startsWith("/spaces");
    }
}

