/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.service;

import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryFilter;
import io.meeds.social.category.model.CategoryRootTree;
import io.meeds.social.category.model.CategorySearchFilter;
import io.meeds.social.category.model.CategorySearchResult;
import io.meeds.social.category.model.CategoryTree;
import io.meeds.social.category.model.CategoryWithName;
import io.meeds.social.category.service.CategoryService;
import io.meeds.social.category.storage.CategoryStorage;
import io.meeds.social.category.utils.Utils;
import io.meeds.social.translation.service.TranslationService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryServiceImpl
implements CategoryService {
    public static final String ADMINISTRATORS_GROUP = "/platform/administrators";
    private static final Log LOG = ExoLogger.getLogger(CategoryServiceImpl.class);
    private static final long MAX_LIMIT = 100L;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private CategoryStorage categoryStorage;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private UserACL userAcl;
    private long adminGroupOwnerId;

    public CategoryTree getCategoryTree(CategoryFilter filter, String username, Locale locale) {
        Category category;
        long parentId = filter.getParentId();
        long ownerId = this.checkOwnerId(filter.getOwnerId(), filter.getParentId());
        long limit = this.checkLimit(filter.getLimit());
        Category category2 = category = parentId == 0L ? this.getRootCategory(ownerId) : this.getCategory(parentId);
        if (category == null || !this.canAccess(category, username) || parentId != 0L && filter.isLinkPermission() && !this.canManageLink(category, username)) {
            return null;
        }
        List<Long> identityIds = this.getUserMemberIdentityIds(username);
        CategoryTree categoryTree = this.buildCategoryTree(category, username, identityIds, locale, filter.getOffset(), limit, filter.isLinkPermission(), filter.isSortByName(), filter.getDepth(), 0L);
        return categoryTree.getParentId() == 0L ? new CategoryRootTree(categoryTree, Utils.isManagerOf(this.identityManager, this.spaceService, this.userAcl, categoryTree.getOwnerId(), username)) : categoryTree;
    }

    public List<CategorySearchResult> findCategories(CategorySearchFilter filter, String username, Locale locale) {
        Category category;
        long parentId = filter.getParentId();
        long ownerId = this.checkOwnerId(filter.getOwnerId(), filter.getParentId());
        long limit = this.checkLimit(filter.getLimit());
        Category category2 = category = parentId == 0L ? this.getRootCategory(ownerId) : this.getCategory(parentId);
        if (category == null || !this.canAccess(category, username)) {
            return Collections.emptyList();
        }
        List<Long> identityIds = this.getUserMemberIdentityIds(username);
        if (CollectionUtils.isEmpty(identityIds)) {
            return Collections.emptyList();
        }
        filter = filter.clone();
        filter.setLimit(limit);
        List<Category> categories = this.categoryStorage.findCategories(filter, identityIds, locale);
        return categories.stream().map(CategorySearchResult::new).map(categorySearchResult -> {
            String name = this.translationService.getTranslationLabelOrDefault("category", categorySearchResult.getId(), "name", locale);
            categorySearchResult.setName(name);
            categorySearchResult.setAncestorIds(this.getAncestorIds(categorySearchResult.getId()));
            return categorySearchResult;
        }).toList();
    }

    public List<Long> getAncestorIds(long categoryId, String username) throws ObjectNotFoundException, IllegalAccessException {
        CategoryWithName category = this.getCategory(categoryId, username, Locale.ENGLISH);
        return this.getAncestorIds(category.getId());
    }

    public List<Long> getAncestorIds(long categoryId) {
        Category category = this.getCategory(categoryId);
        if (category == null) {
            return Collections.emptyList();
        }
        ArrayList<Long> ancestors = new ArrayList<Long>();
        this.addAncestorId(category, ancestors);
        return ancestors;
    }

    public List<Long> getSubcategoryIds(String username, long categoryId, long offset, long limit, long depth) {
        ArrayList<Long> ids = new ArrayList<Long>();
        this.addSubcategories(username, this.getUserMemberIdentityIds(username), categoryId, offset, limit, depth, ids);
        return ids;
    }

    public List<Long> getSubcategoryIds(long categoryId, long offset, long limit, long depth) {
        ArrayList<Long> ids = new ArrayList<Long>();
        this.addSubcategories(categoryId, offset, limit, depth, ids);
        return ids;
    }

    public CategoryWithName getCategory(long categoryId, String username, Locale locale) throws ObjectNotFoundException, IllegalAccessException {
        Category category = this.getCategory(categoryId);
        if (category == null) {
            throw new ObjectNotFoundException(String.format("Category with id %s doesn't exists", categoryId));
        }
        if (!this.canAccess(category, username)) {
            throw new IllegalAccessException(String.format("Category with id %s doesn't exists", categoryId));
        }
        String name = this.translationService.getTranslationLabelOrDefault("category", category.getId(), "name", locale);
        return new CategoryWithName(category, name);
    }

    public Category getCategory(long categoryId) {
        return this.categoryStorage.getCategory(categoryId);
    }

    public Category getRootCategory(long ownerId) {
        Category rootCategory = this.categoryStorage.getRootCategory(ownerId);
        if (rootCategory == null && ownerId == this.getAdminGroupIdentityId()) {
            org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser());
            rootCategory = new Category(0L, 0L, null, Long.parseLong(userIdentity.getId()), ownerId, Collections.emptyList(), Arrays.asList(ownerId));
            rootCategory = this.categoryStorage.createCategory(rootCategory);
        }
        return rootCategory;
    }

    public Category createCategory(Category category, String username) throws ObjectAlreadyExistsException, ObjectNotFoundException, IllegalAccessException {
        this.checkNotNull(category);
        this.checkEmptyId(category);
        this.checkOwnerId(category);
        this.checkParentCreation(category);
        this.checkCanEdit(category, username);
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        category.setCreatorId(Long.parseLong(userIdentity.getId()));
        return this.categoryStorage.createCategory(category);
    }

    public Category updateCategory(Category category, String username) throws ObjectNotFoundException, IllegalAccessException {
        this.checkNotNull(category);
        this.checkNotEmptyId(category);
        this.checkOwnerId(category);
        this.checkParentUpdate(category);
        Category existingCategory = this.checkCategoryExists(category.getId());
        if (existingCategory.getOwnerId() != category.getOwnerId()) {
            throw new IllegalArgumentException("Category Owner Id is missing");
        }
        this.checkCanEdit(category, username);
        category.setCreatorId(existingCategory.getCreatorId());
        return this.categoryStorage.updateCategory(category);
    }

    public Category deleteCategory(long categoryId, String username) throws ObjectNotFoundException, IllegalAccessException {
        Category category = this.checkCategoryExists(categoryId);
        this.checkCanEdit(category, username);
        this.translationService.deleteTranslationLabels("category", categoryId);
        return this.categoryStorage.deleteCategory(categoryId);
    }

    public boolean canEdit(long categoryId, String username) {
        Category category = this.getCategory(categoryId);
        return this.canEdit(category, username);
    }

    public boolean canEdit(Category category, String username) {
        return category != null && Utils.isManagerOf(this.identityManager, this.spaceService, this.userAcl, category.getOwnerId(), username);
    }

    public boolean canAccess(long categoryId, String username) {
        return categoryId == 0L || this.canAccess(this.getCategory(categoryId), username);
    }

    public boolean canAccess(Category category, String username) {
        return this.canAccess(category, username, true);
    }

    public boolean canManageLink(long categoryId, String username) {
        return this.canManageLink(this.categoryStorage.getCategory(categoryId), username);
    }

    public boolean canManageLink(Category category, String username) {
        return this.canManageLink(category, username, true);
    }

    private long getAdminGroupIdentityId() {
        if (this.adminGroupOwnerId == 0L) {
            org.exoplatform.social.core.identity.model.Identity adminGroupIdentity = this.identityManager.getOrCreateGroupIdentity(ADMINISTRATORS_GROUP);
            this.adminGroupOwnerId = adminGroupIdentity == null ? 0L : Long.parseLong(adminGroupIdentity.getId());
        }
        return this.adminGroupOwnerId;
    }

    private long checkOwnerId(long ownerId, long parentId) {
        if (ownerId == 0L && parentId == 0L && (ownerId = this.getAdminGroupIdentityId()) == 0L) {
            throw new IllegalArgumentException("Either Parent Id or Owner Id has to be specified");
        }
        return ownerId;
    }

    private long checkLimit(long limit) {
        if (limit <= 0L) {
            limit = 100L;
        }
        return limit;
    }

    private void checkNotNull(Category category) {
        if (category == null) {
            throw new IllegalArgumentException("Category is mandatory");
        }
    }

    private void checkEmptyId(Category category) {
        if (category.getId() != 0L) {
            throw new IllegalArgumentException("Category id has to be empty");
        }
    }

    private void checkNotEmptyId(Category category) {
        if (category.getId() <= 0L) {
            throw new IllegalArgumentException("Category id is mandatory");
        }
    }

    private void checkOwnerId(Category category) {
        if (category.getOwnerId() <= 0L) {
            throw new IllegalArgumentException("Category owner identifier is mandatory");
        }
    }

    private void checkParentCreation(Category category) throws ObjectNotFoundException, ObjectAlreadyExistsException {
        if (category.getParentId() == 0L) {
            Category rootCategory = this.getRootCategory(category.getOwnerId());
            if (rootCategory != null) {
                throw new ObjectAlreadyExistsException((Object)"Category root element already exists, thus can't recreate it");
            }
        } else {
            this.checkParentExists(category);
        }
    }

    private void checkParentUpdate(Category category) throws ObjectNotFoundException {
        if (category.getParentId() == 0L) {
            Category rootCategory = this.getRootCategory(category.getOwnerId());
            if (rootCategory.getId() != category.getId()) {
                throw new IllegalArgumentException("Category root element already exists, thus can't change it");
            }
        } else {
            this.checkParentExists(category);
        }
    }

    private void checkParentExists(Category category) throws ObjectNotFoundException {
        Category parentCategory = this.getCategory(category.getParentId());
        if (parentCategory == null) {
            throw new ObjectNotFoundException(String.format("Parent Category with id %s doesn't exist", category.getParentId()));
        }
    }

    private Category checkCategoryExists(long id) throws ObjectNotFoundException {
        Category category = this.getCategory(id);
        if (category == null) {
            throw new ObjectNotFoundException(String.format("Can't update a not found Category with id %s", id));
        }
        return category;
    }

    private void checkCanEdit(Category category, String username) throws IllegalAccessException {
        if (!this.canEdit(category, username)) {
            throw new IllegalAccessException("Not allowed to update Category tree");
        }
    }

    private CategoryTree buildCategoryTree(Category category, String username, List<Long> identityIds, Locale locale, long offset, long limit, boolean linkPermission, boolean sortByName, long depthLimit, long depth) {
        CategoryTree categoryTree = new CategoryTree(category);
        if (linkPermission && category.getParentId() > 0L) {
            categoryTree.setCanLink(this.canManageLink(category, username));
        }
        long categoryId = categoryTree.getId();
        long size = this.categoryStorage.countSubcategories(categoryId);
        String name = this.translationService.getTranslationLabelOrDefault("category", category.getId(), "name", locale);
        categoryTree.setName(name);
        if (depth < depthLimit) {
            categoryTree.setOffset(offset);
            categoryTree.setLimit(limit);
            if (size > 0L) {
                List<CategoryTree> categories = this.buildSubCategories(categoryId, username, identityIds, locale, offset, limit, size, linkPermission, sortByName, depthLimit, depth);
                categoryTree.setCategories(categories);
                if ((long)categories.size() < limit) {
                    categoryTree.setSize(offset + (long)categories.size());
                } else if (this.canEdit((Category)categoryTree, username)) {
                    categoryTree.setSize(size);
                } else {
                    try {
                        categoryTree.setSize((long)this.categoryStorage.countSubcategories(new CategorySearchFilter(categoryId), this.getUserMemberIdentityIds(username), locale));
                    }
                    catch (Exception e) {
                        LOG.warn("Error while retrieving subcategories size of category {}. generic value {} without ACL filtering will be used as size instead", new Object[]{categoryId, size, e});
                        categoryTree.setSize(size);
                    }
                }
            }
        } else {
            try {
                categoryTree.setSize((long)this.categoryStorage.countSubcategories(new CategorySearchFilter(categoryId), this.getUserMemberIdentityIds(username), locale));
            }
            catch (Exception e) {
                LOG.warn("Error while retrieving subcategories size of category {}. 0 size will be used instead", new Object[]{categoryId, e});
            }
        }
        return categoryTree;
    }

    private List<CategoryTree> buildSubCategories(long categoryId, String username, List<Long> identityIds, Locale locale, long offset, long limit, long size, boolean linkPermission, boolean sortByName, long depthLimit, long depth) {
        List<CategoryTree> categories;
        long loadedCount;
        boolean sortByNameSubcategories = sortByName && size > limit;
        List<Long> ids = this.getSubcategoryIds(categoryId, offset, limit, identityIds, locale, linkPermission, sortByNameSubcategories);
        long l = loadedCount = ids == null ? 0L : (long)ids.size();
        if (CollectionUtils.isNotEmpty(ids)) {
            boolean limitReached;
            categories = this.toCategories(ids, username, identityIds, locale, offset, limit, linkPermission, sortByName, depthLimit, depth + 1L);
            long offsetToFetch = offset;
            long limitToFetch = Math.max(limit, 10L);
            boolean bl = limitReached = categories.size() == ids.size() || (long)ids.size() < limit;
            while (!limitReached) {
                ids = this.getSubcategoryIds(categoryId, offsetToFetch += limitToFetch, limitToFetch, identityIds, locale, linkPermission, sortByNameSubcategories);
                loadedCount += (long)ids.size();
                List<CategoryTree> additionalCategories = this.toCategories(ids, username, identityIds, locale, offsetToFetch, limitToFetch, linkPermission, sortByName, depthLimit, depth + 1L);
                if (CollectionUtils.isNotEmpty(additionalCategories)) {
                    categories = new ArrayList<CategoryTree>(categories);
                    categories.addAll(additionalCategories.stream().limit(limit - (long)categories.size()).toList());
                }
                limitReached = (long)categories.size() >= limit || (long)ids.size() < limitToFetch;
            }
        } else {
            categories = Collections.emptyList();
        }
        boolean sortApplied = true;
        if (sortByName && locale != null && (long)categories.size() < limit && loadedCount < size - offset) {
            LOG.debug((Object)"Incoherent result from Elasticsearch while retrieving categories. Thus retrieve data from DB");
            sortApplied = false;
            categories = this.buildSubCategories(categoryId, username, identityIds, locale, offset, limit, size, linkPermission, false, depthLimit, depth);
        }
        if (!(sortApplied && sortByNameSubcategories || !CollectionUtils.isNotEmpty(categories))) {
            categories = new ArrayList<CategoryTree>(categories);
            categories.sort((c1, c2) -> StringUtils.compare((String)c1.getName(), (String)c2.getName()));
        }
        return categories;
    }

    private List<CategoryTree> toCategories(List<Long> categoryIds, String username, List<Long> identityIds, Locale locale, long offset, long limit, boolean linkPermission, boolean sortByName, long depthLimit, long depth) {
        return categoryIds.stream().map(this.categoryStorage::getCategory).filter(cat -> linkPermission ? this.canManageLink((Category)cat, username, false) : this.canAccess((Category)cat, username, false)).map(cat -> this.buildCategoryTree((Category)cat, username, identityIds, locale, offset, limit, linkPermission, sortByName, depthLimit, depth)).toList();
    }

    private List<Long> getSubcategoryIds(long parentId, long offset, long limit, List<Long> identityIds, Locale locale, boolean linkPermission, boolean sortByName) {
        if (sortByName && locale != null) {
            if (CollectionUtils.isEmpty(identityIds)) {
                return Collections.emptyList();
            }
            try {
                return this.categoryStorage.findCategoryIds(new CategorySearchFilter(null, 0L, parentId, offset, limit, linkPermission, sortByName), identityIds, locale);
            }
            catch (Exception e) {
                LOG.warn("Error while retrieving subcategories of parent category {}. Information will be retrieved from database instead", new Object[]{parentId, e});
            }
        }
        return this.categoryStorage.getSubcategoryIds(parentId, offset, limit);
    }

    private void addSubcategories(long categoryId, long offset, long limit, long depth, List<Long> result) {
        List<Long> subcategoryIds = this.categoryStorage.getSubcategoryIds(categoryId, offset, limit);
        if (CollectionUtils.isNotEmpty(subcategoryIds)) {
            result.addAll(subcategoryIds);
            if (depth > 1L || depth < 0L) {
                subcategoryIds.forEach(id -> this.addSubcategories((long)id, offset, limit, depth - 1L, result));
            }
        }
    }

    private void addSubcategories(String username, List<Long> identityIds, long categoryId, long offset, long limit, long depth, List<Long> result) {
        List<Long> subcategoryIds;
        try {
            subcategoryIds = this.categoryStorage.findCategoryIds(new CategorySearchFilter(null, 0L, categoryId, offset, limit, false, false), identityIds, Locale.ENGLISH);
        }
        catch (Exception e) {
            subcategoryIds = this.categoryStorage.getSubcategoryIds(categoryId, offset, limit).stream().filter(id -> this.canAccess((long)id, username)).toList();
        }
        if (CollectionUtils.isNotEmpty(subcategoryIds)) {
            result.addAll(subcategoryIds);
            if (depth > 1L || depth < 0L) {
                subcategoryIds.forEach(id -> this.addSubcategories(username, identityIds, (long)id, offset, limit, depth - 1L, result));
            }
        }
    }

    private boolean canAccess(Category category, String username, boolean checkAncestors) {
        if (category == null) {
            return false;
        }
        if (category.getParentId() == 0L && category.getOwnerId() == this.getAdminGroupIdentityId()) {
            return StringUtils.isNotBlank((CharSequence)username);
        }
        if (Utils.isMemberOf(this.identityManager, this.spaceService, this.userAcl, category.getOwnerId(), username)) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)category.getAccessPermissionIds())) {
            return false;
        }
        return (!checkAncestors || this.canAccess(category.getParentId(), username)) && category.getAccessPermissionIds().stream().anyMatch(id -> Utils.isMemberOf(this.identityManager, this.spaceService, this.userAcl, id, username));
    }

    private boolean canManageLink(Category category, String username, boolean checkAccessToAncestors) {
        if (category == null || CollectionUtils.isEmpty((Collection)category.getLinkPermissionIds())) {
            return category != null && Utils.isManagerOf(this.identityManager, this.spaceService, this.userAcl, category.getOwnerId(), username);
        }
        return Utils.isManagerOf(this.identityManager, this.spaceService, this.userAcl, category.getOwnerId(), username) || this.canAccess(category, username, checkAccessToAncestors) && category.getLinkPermissionIds().stream().anyMatch(id -> Utils.isMemberOf(this.identityManager, this.spaceService, this.userAcl, id, username));
    }

    private List<Long> getUserMemberIdentityIds(String username) {
        Identity userAclIdentity = this.userAcl.getUserIdentity(username);
        if (userAclIdentity == null) {
            return Collections.emptyList();
        }
        return userAclIdentity.getGroups().stream().map(groupId -> {
            if (StringUtils.startsWith((CharSequence)groupId, (CharSequence)"/spaces/")) {
                Space space = this.spaceService.getSpaceByGroupId(groupId);
                if (space == null) {
                    return null;
                }
                org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
                return Long.parseLong(identity.getId());
            }
            org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateGroupIdentity(groupId);
            return identity == null ? null : Long.valueOf(Long.parseLong(identity.getId()));
        }).filter(Objects::nonNull).toList();
    }

    private void addAncestorId(Category category, List<Long> ancestors) {
        long parentId = category.getParentId();
        if (parentId > 0L) {
            ancestors.add(parentId);
            Category parentCategory = this.getCategory(parentId);
            this.addAncestorId(parentCategory, ancestors);
        }
    }
}

