/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.administration.service;

import io.meeds.social.space.constant.SpaceRegistration;
import io.meeds.social.space.constant.SpaceVisibility;
import io.meeds.social.space.model.SpacePermissions;
import io.meeds.social.space.model.SpaceTemplatePatch;
import io.meeds.social.space.service.SpaceAdministrationServiceImpl;
import io.meeds.social.space.service.SpaceLayoutService;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import java.util.Collections;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceAdministrationServiceTest {
    private static final String TESTUSER_REDACTOR = "testuserRedactor";
    private static final String TESTUSER_MANAGER = "testuserManager";
    long spaceId = 2L;
    long templateId = 3L;
    @Mock
    SpaceService spaceService;
    @Mock
    SpaceLayoutService spaceLayoutService;
    @Mock
    SpaceTemplateService spaceTemplateService;
    @Mock
    Space space;
    @Mock
    SpaceTemplate spaceTemplate;
    @Mock
    SpaceTemplatePatch templatePatch;
    SpaceAdministrationServiceImpl spaceAdministrationService;

    @Before
    public void setup() {
        this.spaceAdministrationService = new SpaceAdministrationServiceImpl();
        this.spaceAdministrationService.setSpaceService(this.spaceService);
        this.spaceAdministrationService.setSpaceLayoutService(this.spaceLayoutService);
        this.spaceAdministrationService.setSpaceTemplateService(this.spaceTemplateService);
    }

    @Test
    public void testGetSpacePermissions() throws ObjectNotFoundException {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceAdministrationService.getSpacePermissions(this.spaceId));
        Mockito.when((Object)this.spaceService.getSpaceById(this.spaceId)).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getLayoutPermissions()).thenReturn(Collections.singletonList("layoutPermissions"));
        Mockito.when((Object)this.space.getDeletePermissions()).thenReturn(Collections.singletonList("deletePermissions"));
        Mockito.when((Object)this.space.getPublicSitePermissions()).thenReturn(Collections.singletonList("publicSitePermissionsPermissions"));
        SpacePermissions spacePermissions = this.spaceAdministrationService.getSpacePermissions(this.spaceId);
        Assert.assertNotNull((Object)spacePermissions);
        Assert.assertEquals((Object)this.space.getDeletePermissions(), (Object)spacePermissions.getDeletePermissions());
        Assert.assertEquals((Object)this.space.getLayoutPermissions(), (Object)spacePermissions.getLayoutPermissions());
        Assert.assertEquals((Object)this.space.getPublicSitePermissions(), (Object)spacePermissions.getPublicSitePermissions());
    }

    @Test
    public void testUpdateSpacePermissions() throws ObjectNotFoundException {
        SpacePermissions spacePermissions = (SpacePermissions)Mockito.mock(SpacePermissions.class);
        Mockito.when((Object)spacePermissions.getLayoutPermissions()).thenReturn(Collections.singletonList("layoutPermissions"));
        Mockito.when((Object)spacePermissions.getDeletePermissions()).thenReturn(Collections.singletonList("deletePermissions"));
        Mockito.when((Object)spacePermissions.getPublicSitePermissions()).thenReturn(Collections.singletonList("publicSitePermissionsPermissions"));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceAdministrationService.updateSpacePermissions(this.spaceId, spacePermissions));
        Mockito.when((Object)this.spaceService.getSpaceById(this.spaceId)).thenReturn((Object)this.space);
        this.spaceAdministrationService.updateSpacePermissions(this.spaceId, spacePermissions);
        ((Space)Mockito.verify((Object)this.space)).setDeletePermissions(spacePermissions.getDeletePermissions());
        ((Space)Mockito.verify((Object)this.space)).setLayoutPermissions(spacePermissions.getLayoutPermissions());
        ((Space)Mockito.verify((Object)this.space)).setPublicSitePermissions(spacePermissions.getPublicSitePermissions());
        ((SpaceService)Mockito.verify((Object)this.spaceService)).updateSpace(this.space);
    }

    @Test
    public void testApplySpaceTemplate() throws ObjectNotFoundException {
        Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(Mockito.anyLong())).thenReturn((Object)this.spaceTemplate);
        Mockito.when((Object)this.spaceTemplate.isDeleted()).thenReturn((Object)false);
        Mockito.when((Object)this.spaceTemplate.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.spaceTemplate.isSpaceAllowContentCreation()).thenReturn((Object)true);
        Mockito.when((Object)this.spaceTemplate.getSpaceDefaultRegistration()).thenReturn((Object)SpaceRegistration.OPEN);
        Mockito.when((Object)this.spaceTemplate.getSpaceDefaultVisibility()).thenReturn((Object)SpaceVisibility.HIDDEN);
        Mockito.when((Object)this.spaceService.getSpaceById(this.spaceId)).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getManagers()).thenReturn((Object)new String[]{TESTUSER_MANAGER});
        Mockito.when((Object)this.templatePatch.getTemplateId()).thenReturn((Object)this.templateId);
        Mockito.when((Object)this.templatePatch.isAccessRules()).thenReturn((Object)true);
        Mockito.when((Object)this.templatePatch.isDeletePermissions()).thenReturn((Object)true);
        Mockito.when((Object)this.templatePatch.isLayoutPermissions()).thenReturn((Object)true);
        Mockito.when((Object)this.templatePatch.isPublicSitePermissions()).thenReturn((Object)true);
        Mockito.when((Object)this.templatePatch.isEditorialMode()).thenReturn((Object)true);
        this.spaceAdministrationService.applySpaceTemplate(this.spaceId, this.templatePatch);
        ((SpaceService)Mockito.verify((Object)this.spaceService)).updateSpace(this.space);
        ((SpaceLayoutService)Mockito.verify((Object)this.spaceLayoutService)).updateSpaceSite(this.space);
        ((SpaceService)Mockito.verify((Object)this.spaceService)).addRedactor((Space)Mockito.any(), (String)Mockito.any());
        ((Space)Mockito.verify((Object)this.space)).setRegistration(this.spaceTemplate.getSpaceDefaultRegistration().name().toLowerCase());
        ((Space)Mockito.verify((Object)this.space)).setVisibility(this.spaceTemplate.getSpaceDefaultVisibility().name().toLowerCase());
    }

    @Test
    public void testApplySpaceTemplateWhenSpaceNotFound() {
        Mockito.when((Object)this.spaceService.getSpaceById(this.spaceId)).thenReturn(null);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceAdministrationService.applySpaceTemplate(this.spaceId, this.templatePatch));
    }

    @Test
    public void testApplySpaceTemplateWhenSpaceTemplateNotFound() {
        Mockito.when((Object)this.spaceService.getSpaceById(this.spaceId)).thenReturn((Object)this.space);
        Mockito.when((Object)this.templatePatch.getTemplateId()).thenReturn((Object)this.templateId);
        Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(this.templateId)).thenReturn(null);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceAdministrationService.applySpaceTemplate(this.spaceId, this.templatePatch));
    }

    @Test
    public void testApplySpaceTemplateWhenSpaceTemplateIsDeleted() {
        Mockito.when((Object)this.spaceService.getSpaceById(this.spaceId)).thenReturn((Object)this.space);
        Mockito.when((Object)this.templatePatch.getTemplateId()).thenReturn((Object)this.templateId);
        Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(this.templateId)).thenReturn((Object)this.spaceTemplate);
        Mockito.when((Object)this.spaceTemplate.isDeleted()).thenReturn((Object)true);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceAdministrationService.applySpaceTemplate(this.spaceId, this.templatePatch));
    }

    @Test
    public void testApplySpaceTemplateWhenSpaceTemplateIsDisabled() {
        Mockito.when((Object)this.spaceService.getSpaceById(this.spaceId)).thenReturn((Object)this.space);
        Mockito.when((Object)this.templatePatch.getTemplateId()).thenReturn((Object)this.templateId);
        Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(this.templateId)).thenReturn((Object)this.spaceTemplate);
        Mockito.when((Object)this.spaceTemplate.isEnabled()).thenReturn((Object)false);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceAdministrationService.applySpaceTemplate(this.spaceId, this.templatePatch));
    }

    @Test
    public void testApplySpaceTemplateWhenEditorialModeAndAllowContentCreation() throws ObjectNotFoundException {
        Mockito.when((Object)this.spaceService.getSpaceById(this.spaceId)).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getRedactors()).thenReturn((Object)new String[0]);
        Mockito.when((Object)this.space.getManagers()).thenReturn((Object)new String[]{TESTUSER_MANAGER});
        Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(this.templateId)).thenReturn((Object)this.spaceTemplate);
        Mockito.when((Object)this.spaceTemplate.isSpaceAllowContentCreation()).thenReturn((Object)true);
        Mockito.when((Object)this.spaceTemplate.isDeleted()).thenReturn((Object)false);
        Mockito.when((Object)this.spaceTemplate.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.templatePatch.isEditorialMode()).thenReturn((Object)true);
        Mockito.when((Object)this.templatePatch.getTemplateId()).thenReturn((Object)this.templateId);
        this.spaceAdministrationService.applySpaceTemplate(this.spaceId, this.templatePatch);
        ((SpaceService)Mockito.verify((Object)this.spaceService)).addRedactor((Space)Mockito.any(), (String)Mockito.any());
    }

    @Test
    public void testApplySpaceTemplateWhenEditorialModeAndNotAllowContentCreation() throws ObjectNotFoundException {
        Mockito.when((Object)this.spaceService.getSpaceById(this.spaceId)).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getRedactors()).thenReturn((Object)new String[]{TESTUSER_REDACTOR});
        Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(Mockito.anyLong())).thenReturn((Object)this.spaceTemplate);
        Mockito.when((Object)this.spaceTemplate.isSpaceAllowContentCreation()).thenReturn((Object)false);
        Mockito.when((Object)this.spaceTemplate.isDeleted()).thenReturn((Object)false);
        Mockito.when((Object)this.spaceTemplate.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.templatePatch.isEditorialMode()).thenReturn((Object)true);
        Mockito.when((Object)this.templatePatch.getTemplateId()).thenReturn((Object)this.templateId);
        this.spaceAdministrationService.applySpaceTemplate(this.spaceId, this.templatePatch);
        ((SpaceService)Mockito.verify((Object)this.spaceService)).removeRedactor((Space)Mockito.any(), (String)Mockito.any());
    }
}

