/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.exoplatform.social.core.identity.IdentityResult;
import org.exoplatform.social.core.identity.model.Identity;

public class IdentityResultTest
extends TestCase {
    Identity demoIdentity = null;
    Identity rootIdentity = null;
    Identity maryIdentity = null;
    Identity johnIdentity = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.init();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.demoIdentity = null;
        this.rootIdentity = null;
        this.maryIdentity = null;
        this.johnIdentity = null;
    }

    private void init() {
        this.demoIdentity = new Identity("demo123456");
        this.demoIdentity.setRemoteId("demo");
        this.rootIdentity = new Identity("root123456");
        this.rootIdentity.setRemoteId("root");
        this.maryIdentity = new Identity("mary123456");
        this.maryIdentity.setRemoteId("mary");
        this.johnIdentity = new Identity("john123456");
        this.johnIdentity.setRemoteId("john");
    }

    public void testResult() throws Exception {
        IdentityResult result = new IdentityResult(4L);
        result.add(this.demoIdentity);
        result.add(this.rootIdentity);
        result.add(this.maryIdentity);
        result.add(this.johnIdentity);
        result.add(this.demoIdentity);
        IdentityResultTest.assertEquals((int)4, (int)result.size());
    }

    public void testResultOffsetLimit() throws Exception {
        IdentityResult result = new IdentityResult(0L, 2L, 4L);
        ArrayList<Identity> identities = new ArrayList<Identity>(4);
        identities.add(this.demoIdentity);
        identities.add(this.rootIdentity);
        identities.add(this.maryIdentity);
        identities.add(this.johnIdentity);
        Iterator it = identities.iterator();
        while (it.hasNext()) {
            result.add((Identity)it.next());
            if (result.addMore()) continue;
        }
        IdentityResultTest.assertEquals((int)2, (int)result.size());
        it = identities.iterator();
        result = new IdentityResult(2L, 1L, 4L);
        while (it.hasNext()) {
            result.add((Identity)it.next());
            if (result.addMore()) continue;
        }
        IdentityResultTest.assertEquals((int)1, (int)result.size());
    }
}

