/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.entity.ActivityEntity;
import org.exoplatform.social.core.jpa.test.BaseCoreTest;
import org.exoplatform.social.core.space.model.Space;

public class ActivityDAOTest
extends BaseCoreTest {
    private final Log LOG = ExoLogger.getLogger(ActivityDAOTest.class);
    private Set<ActivityEntity> tearDownActivityList;
    private List<Space> tearDownSpaceList;
    private Identity ghostIdentity;
    private Identity raulIdentity;
    private Identity jameIdentity;
    private Identity paulIdentity;
    private ActivityDAO activityDao;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.activityDao = this.getService(ActivityDAO.class);
        this.tearDownActivityList = new HashSet<ActivityEntity>();
        this.tearDownSpaceList = new ArrayList<Space>();
        this.ghostIdentity = this.identityManager.getOrCreateIdentity("organization", "ghost", true);
        this.raulIdentity = this.identityManager.getOrCreateIdentity("organization", "raul", true);
        this.jameIdentity = this.identityManager.getOrCreateIdentity("organization", "jame", true);
        this.paulIdentity = this.identityManager.getOrCreateIdentity("organization", "paul", true);
    }

    @Override
    public void tearDown() throws Exception {
        for (ActivityEntity activity : this.tearDownActivityList) {
            try {
                this.activityDao.delete((Object)activity);
            }
            catch (Exception e) {
                this.LOG.warn((Object)("Can not delete activity with id: " + activity.getId()), (Throwable)e);
            }
        }
        this.identityManager.deleteIdentity(this.ghostIdentity);
        this.identityManager.deleteIdentity(this.jameIdentity);
        this.identityManager.deleteIdentity(this.raulIdentity);
        this.identityManager.deleteIdentity(this.paulIdentity);
        for (Space space : this.tearDownSpaceList) {
            Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
            if (spaceIdentity != null) {
                this.identityManager.deleteIdentity(spaceIdentity);
            }
            this.spaceService.deleteSpace(space);
        }
        ConversationState.setCurrent(null);
        super.tearDown();
    }

    public void testSaveActivity() throws Exception {
        String activityTitle = "activity title";
        String johnIdentityId = this.johnIdentity.getId();
        ActivityEntity activity = this.createActivity(activityTitle, this.maryIdentity.getId());
        activity.setLocked(Boolean.valueOf(true));
        activity.setPosterId(johnIdentityId);
        activity.setOwnerId(johnIdentityId);
        activity = (ActivityEntity)this.activityDao.create((Object)activity);
        ActivityEntity got = (ActivityEntity)this.activityDao.find((Serializable)activity.getId());
        ActivityDAOTest.assertNotNull((Object)got);
        ActivityDAOTest.assertEquals((String)activityTitle, (String)got.getTitle());
        ActivityDAOTest.assertEquals((String)johnIdentityId, (String)got.getPosterId());
        ActivityDAOTest.assertEquals((String)johnIdentityId, (String)got.getOwnerId());
        Map gotTemplateParams = activity.getTemplateParams();
        for (int i = 1; i < 4; ++i) {
            ActivityDAOTest.assertTrue((boolean)gotTemplateParams.values().contains("value 1"));
        }
        ActivityDAOTest.assertTrue((boolean)activity.getLocked());
        ActivityDAOTest.assertFalse((boolean)activity.getHidden());
        this.tearDownActivityList.add(got);
    }

    private ActivityEntity createActivity(String activityTitle, String posterId) {
        ActivityEntity activity = new ActivityEntity();
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put("key1", "value 1");
        templateParams.put("key2", "value 2");
        templateParams.put("key3", "value 3");
        activity.setTemplateParams(templateParams);
        activity.setTitle(activityTitle);
        activity.setBody("The body of " + activityTitle);
        activity.setPosterId(posterId);
        activity.setType("DEFAULT_ACTIVITY");
        activity.setHidden(Boolean.valueOf(false));
        activity.setLocked(Boolean.valueOf(false));
        return activity;
    }

    private ActivityEntity saveActivity(Identity ownerIdentity, ActivityEntity activity) {
        activity.setOwnerId(ownerIdentity.getId());
        activity.setPosterId(activity.getOwnerId());
        activity = (ActivityEntity)this.activityDao.create((Object)activity);
        this.tearDownActivityList.add(activity);
        return activity;
    }

    public void testUpdateActivity() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ActivityEntity activity = this.createActivity(activityTitle, userId);
        this.saveActivity(this.johnIdentity, activity);
        activity = (ActivityEntity)this.activityDao.find((Serializable)activity.getId());
        ActivityDAOTest.assertEquals((String)activityTitle, (String)activity.getTitle());
        ActivityDAOTest.assertEquals((String)userId, (String)activity.getOwnerId());
        String newTitle = "new activity title";
        activity.setTitle(newTitle);
        this.activityDao.update((Object)activity);
        activity = (ActivityEntity)this.activityDao.find((Serializable)activity.getId());
        ActivityDAOTest.assertEquals((String)newTitle, (String)activity.getTitle());
    }

    public void testDeleteActivity() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ActivityEntity activity = new ActivityEntity();
        activity.setTitle(activityTitle);
        activity.setOwnerId(userId);
        activity.setPosterId(userId);
        activity = (ActivityEntity)this.activityDao.create((Object)activity);
        activity = (ActivityEntity)this.activityDao.find((Serializable)activity.getId());
        ActivityDAOTest.assertNotNull((Object)activity);
        ActivityDAOTest.assertEquals((String)activityTitle, (String)activity.getTitle());
        ActivityDAOTest.assertEquals((String)userId, (String)activity.getOwnerId());
        this.activityDao.delete((Object)activity);
        ActivityDAOTest.assertNull((Object)this.activityDao.find((Serializable)activity.getId()));
    }

    public void testSaveComment() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ActivityEntity activity = new ActivityEntity();
        activity.setTitle(activityTitle);
        activity.setOwnerId(userId);
        this.saveActivity(this.johnIdentity, activity);
        String commentTitle = "Comment title";
        ActivityEntity comment = new ActivityEntity();
        comment.setTitle(commentTitle);
        comment.setOwnerId(this.demoIdentity.getId());
        comment.setPosterId(this.demoIdentity.getId());
        activity.addComment(comment);
        this.activityDao.create((Object)comment);
        ActivityDAOTest.assertNotNull((Object)comment.getId());
        this.activityDao.update((Object)activity);
        activity = (ActivityEntity)this.activityDao.find((Serializable)activity.getId());
        List demoComments = this.activityDao.getComments(activity.getId().longValue(), 0, -1, false);
        ActivityDAOTest.assertNotNull((Object)demoComments);
        ActivityDAOTest.assertEquals((int)1, (int)demoComments.size());
        comment = (ActivityEntity)demoComments.get(0);
        ActivityDAOTest.assertEquals((String)commentTitle, (String)comment.getTitle());
        ActivityDAOTest.assertEquals((String)this.demoIdentity.getId(), (String)comment.getOwnerId());
    }

    public void testGetActivityByComment() {
        String activityTitle = "activity title";
        String identityId = this.johnIdentity.getId();
        ActivityEntity demoActivity = new ActivityEntity();
        demoActivity.setTitle(activityTitle);
        demoActivity.setOwnerId(identityId);
        this.saveActivity(this.johnIdentity, demoActivity);
        ActivityEntity comment = new ActivityEntity();
        comment.setTitle("demo comment");
        comment.setOwnerId(this.demoIdentity.getId());
        comment.setPosterId(this.demoIdentity.getId());
        demoActivity = (ActivityEntity)this.activityDao.find((Serializable)demoActivity.getId());
        demoActivity.addComment(comment);
        this.activityDao.create((Object)comment);
        this.activityDao.update((Object)demoActivity);
        demoActivity = (ActivityEntity)this.activityDao.find((Serializable)demoActivity.getId());
        List demoComments = demoActivity.getComments();
        Long commentId = ((ActivityEntity)demoComments.get(0)).getId();
        comment = (ActivityEntity)this.activityDao.find((Serializable)commentId);
        ActivityDAOTest.assertEquals((int)1, (int)demoActivity.getComments().size());
        ActivityDAOTest.assertEquals((String)this.demoIdentity.getId(), (String)comment.getOwnerId());
    }

    public void testGetActivityByCommentId() throws Exception {
        String activityTitle = "activity title";
        String identityId = this.johnIdentity.getId();
        ActivityEntity demoActivity = new ActivityEntity();
        demoActivity.setTitle(activityTitle);
        demoActivity.setOwnerId(identityId);
        this.saveActivity(this.johnIdentity, demoActivity);
        ActivityEntity comment = new ActivityEntity();
        comment.setTitle("demo comment");
        comment.setOwnerId(this.demoIdentity.getId());
        comment.setPosterId(this.demoIdentity.getId());
        demoActivity.addComment(comment);
        comment = (ActivityEntity)this.activityDao.create((Object)comment);
        this.activityDao.update((Object)demoActivity);
        ActivityEntity activityAdded = this.activityDao.getParentActivity(comment.getId().longValue());
        ActivityDAOTest.assertEquals((Object)demoActivity.getId(), (Object)activityAdded.getId());
        final Long acId = demoActivity.getId();
        final Long cmId = comment.getId();
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                ActivityEntity activityAdded = ActivityDAOTest.this.activityDao.getParentActivity(cmId.longValue());
                TestCase.assertNotNull((Object)activityAdded);
                TestCase.assertEquals((Object)acId, (Object)activityAdded.getId());
            }
        });
    }

    public void testGetComments() throws Exception {
        ActivityEntity demoActivity = new ActivityEntity();
        demoActivity.setTitle("demo activity");
        demoActivity.setOwnerId(this.demoIdentity.getId());
        this.saveActivity(this.johnIdentity, demoActivity);
        this.tearDownActivityList.add(demoActivity);
        int total = 10;
        for (int i = 0; i < total; ++i) {
            ActivityEntity maryComment = new ActivityEntity();
            maryComment.setOwnerId(this.maryIdentity.getId());
            maryComment.setPosterId(this.maryIdentity.getId());
            maryComment.setTitle("mary comment");
            demoActivity.addComment(maryComment);
            this.activityDao.create((Object)maryComment);
            this.activityDao.update((Object)demoActivity);
        }
        demoActivity = (ActivityEntity)this.activityDao.find((Serializable)demoActivity.getId());
        List maryComments = demoActivity.getComments();
        ActivityDAOTest.assertNotNull((Object)maryComments);
        ActivityDAOTest.assertEquals((int)total, (int)maryComments.size());
    }

    public void testDeleteComment() throws Exception {
        ActivityEntity demoActivity = new ActivityEntity();
        demoActivity.setTitle("demo activity");
        demoActivity.setOwnerId(this.demoIdentity.getId());
        this.saveActivity(this.demoIdentity, demoActivity);
        this.tearDownActivityList.add(demoActivity);
        ActivityEntity maryComment = new ActivityEntity();
        maryComment.setTitle("mary comment");
        maryComment.setOwnerId(this.maryIdentity.getId());
        maryComment.setPosterId(this.maryIdentity.getId());
        demoActivity.addComment(maryComment);
        this.activityDao.create((Object)maryComment);
        this.activityDao.update((Object)demoActivity);
        maryComment = (ActivityEntity)this.activityDao.find((Serializable)maryComment.getId());
        this.activityDao.delete((Object)maryComment);
        demoActivity = (ActivityEntity)this.activityDao.find((Serializable)demoActivity.getId());
        demoActivity.getComments().remove(maryComment);
        this.activityDao.update((Object)demoActivity);
        ActivityDAOTest.assertNull((Object)this.activityDao.find((Serializable)maryComment.getId()));
        ActivityDAOTest.assertEquals((int)0, (int)((ActivityEntity)this.activityDao.find((Serializable)demoActivity.getId())).getComments().size());
    }
}

