/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.application.ProfileUpdatesPublisher;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class ProfileUpdatesPublisherTest
extends AbstractCoreTest {
    private final Log LOG = ExoLogger.getLogger(ProfileUpdatesPublisher.class);
    private List<ExoSocialActivity> tearDownActivityList;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private IdentityStorage identityStorage;
    private ProfileUpdatesPublisher publisher;
    private String userName = "root";
    private Identity rootIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        ProfileUpdatesPublisherTest.assertNotNull((String)"activityManager must not be null", (Object)this.activityManager);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        ProfileUpdatesPublisherTest.assertNotNull((String)"identityManager must not be null", (Object)this.identityManager);
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        ProfileUpdatesPublisherTest.assertNotNull((String)"identityManager must not be null", (Object)this.identityStorage);
        this.publisher = (ProfileUpdatesPublisher)this.getContainer().getComponentInstanceOfType(ProfileUpdatesPublisher.class);
        ProfileUpdatesPublisherTest.assertNotNull((String)"profileUpdatesPublisher must not be null", (Object)this.publisher);
        this.rootIdentity = this.identityManager.getOrCreateIdentity("organization", this.userName, true);
        ProfileUpdatesPublisherTest.assertNotNull((String)"rootIdentity.getId() must not be null", (Object)this.rootIdentity.getId());
    }

    @Override
    public void tearDown() throws Exception {
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            try {
                this.activityManager.deleteActivity(activity.getId());
            }
            catch (Exception e) {
                this.LOG.warn((Object)("can not delete activity with id: " + activity.getId()));
            }
        }
        this.identityManager.deleteIdentity(this.rootIdentity);
        super.tearDown();
    }

    public void testProfileUpdated() throws Exception {
        Profile profile = this.rootIdentity.getProfile();
        profile.setAttachedActivityType(Profile.AttachedActivityType.USER);
        ProfileUpdatesPublisherTest.assertNull((Object)this.getActivityId(profile));
        profile.setProperty("position", (Object)"developer");
        profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
        this.identityManager.updateProfile(profile);
        String activityId = this.getActivityId(profile);
        ProfileUpdatesPublisherTest.assertNotNull((Object)activityId);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        ProfileUpdatesPublisherTest.assertEquals((String)"Contact informations has been updated.", (String)activity.getTitle());
        ProfileUpdatesPublisherTest.assertTrue((boolean)activity.getTitleId().contains("contact_section_updated"));
        List comments = this.activityManager.getCommentsWithListAccess(activity).loadAsList(0, 20);
        ProfileUpdatesPublisherTest.assertEquals((int)1, (int)comments.size());
        ProfileUpdatesPublisherTest.assertEquals((String)"Contact informations has been updated.", (String)((ExoSocialActivity)comments.get(0)).getTitle());
        profile.setProperty("aboutMe", (Object)"Nothing to say");
        profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.ABOUT_ME));
        activity = this.updateProfile(profile);
        comments = this.activityManager.getCommentsWithListAccess(activity).loadAsList(0, 20);
        ProfileUpdatesPublisherTest.assertNotNull((Object)activity);
        ProfileUpdatesPublisherTest.assertEquals((String)"About me has been updated.", (String)((ExoSocialActivity)comments.get(1)).getTitle());
        ProfileUpdatesPublisherTest.assertEquals((String)"About me has been updated.", (String)activity.getTitle());
        ProfileUpdatesPublisherTest.assertTrue((boolean)activity.getTitleId().contains("contact_section_updated"));
        ProfileUpdatesPublisherTest.assertTrue((boolean)activity.getTitleId().contains("aboutMe_section_updated"));
        ProfileUpdatesPublisherTest.assertEquals((int)2, (int)comments.size());
        profile.setProperty("aboutMe", (Object)"Don't want to say");
        profile.setProperty("email", (Object)"abc@gmail.com");
        profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.ABOUT_ME, Profile.UpdateType.CONTACT));
        activity = this.updateProfile(profile);
        ProfileUpdatesPublisherTest.assertNotNull((Object)activity);
        comments = this.activityManager.getCommentsWithListAccess(activity).loadAsList(0, 20);
        ProfileUpdatesPublisherTest.assertEquals((String)"About me has been updated.<br />Contact informations has been updated.", (String)((ExoSocialActivity)comments.get(2)).getTitle());
        ProfileUpdatesPublisherTest.assertEquals((String)"About me has been updated.<br />Contact informations has been updated.", (String)activity.getTitle());
        ProfileUpdatesPublisherTest.assertTrue((boolean)activity.getTitleId().contains("contact_section_updated"));
        ProfileUpdatesPublisherTest.assertTrue((boolean)activity.getTitleId().contains("aboutMe_section_updated"));
        ProfileUpdatesPublisherTest.assertEquals((int)4, (int)comments.size());
        ArrayList experiences = new ArrayList();
        HashMap<String, String> exp1 = new HashMap<String, String>();
        exp1.put("company", "eXo");
        exp1.put("position", "developer");
        exp1.put("startDate", "1/1/2015");
        exp1.put("isCurrent", "true");
        experiences.add(exp1);
        profile.setProperty("experiences", experiences);
        profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.EXPERIENCES));
        activity = this.updateProfile(profile);
        ProfileUpdatesPublisherTest.assertNotNull((Object)activity);
        comments = this.activityManager.getCommentsWithListAccess(activity).loadAsList(0, 20);
        ProfileUpdatesPublisherTest.assertEquals((String)"Experiences has been updated.", (String)((ExoSocialActivity)comments.get(4)).getTitle());
        ProfileUpdatesPublisherTest.assertEquals((String)"Experiences has been updated.", (String)activity.getTitle());
        ProfileUpdatesPublisherTest.assertTrue((boolean)activity.getTitleId().contains("contact_section_updated"));
        ProfileUpdatesPublisherTest.assertTrue((boolean)activity.getTitleId().contains("aboutMe_section_updated"));
        ProfileUpdatesPublisherTest.assertTrue((boolean)activity.getTitleId().contains("experience_section_updated"));
        ProfileUpdatesPublisherTest.assertEquals((int)5, (int)comments.size());
        AvatarAttachment avatar = new AvatarAttachment();
        avatar.setMimeType("plain/text");
        avatar.setInputStream((InputStream)new ByteArrayInputStream("Attachment content".getBytes()));
        profile.setProperty("avatar", (Object)avatar);
        profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.AVATAR));
        activity = this.updateProfile(profile);
        ProfileUpdatesPublisherTest.assertNotNull((Object)activity);
        comments = this.activityManager.getCommentsWithListAccess(activity).loadAsList(0, 20);
        ProfileUpdatesPublisherTest.assertEquals((String)"Avatar has been updated.", (String)((ExoSocialActivity)comments.get(5)).getTitle());
        ProfileUpdatesPublisherTest.assertEquals((String)"Avatar has been updated.", (String)activity.getTitle());
        ProfileUpdatesPublisherTest.assertTrue((boolean)activity.getTitleId().contains("contact_section_updated"));
        ProfileUpdatesPublisherTest.assertTrue((boolean)activity.getTitleId().contains("aboutMe_section_updated"));
        ProfileUpdatesPublisherTest.assertTrue((boolean)activity.getTitleId().contains("experience_section_updated"));
        ProfileUpdatesPublisherTest.assertTrue((boolean)activity.getTitleId().contains("avatar_updated"));
        ProfileUpdatesPublisherTest.assertEquals((int)6, (int)comments.size());
        profile.setProperty("firstName", (Object)"binh");
        profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
        this.identityManager.updateProfile(profile);
        comments = this.activityManager.getCommentsWithListAccess(activity).loadAsList(0, 20);
        ProfileUpdatesPublisherTest.assertEquals((int)7, (int)comments.size());
        ProfileUpdatesPublisherTest.assertEquals((int)1, (int)this.activityManager.getActivitiesWithListAccess(this.rootIdentity).getSize());
        this.activityManager.deleteActivity(activityId);
        ProfileUpdatesPublisherTest.assertEquals((int)0, (int)this.activityManager.getActivitiesWithListAccess(this.rootIdentity).getSize());
        profile.setProperty("position", (Object)"worker");
        ExoSocialActivity newActivity = this.updateProfile(profile);
        ProfileUpdatesPublisherTest.assertEquals((int)1, (int)this.activityManager.getCommentsWithListAccess(newActivity).getSize());
        activityId = this.getActivityId(profile);
        this.activityManager.deleteActivity(activityId);
    }

    private String getActivityId(Profile profile) {
        return this.identityStorage.getProfileActivityId(profile, Profile.AttachedActivityType.USER);
    }

    private ExoSocialActivity updateProfile(Profile profile) throws Exception {
        this.identityManager.updateProfile(profile);
        return this.activityManager.getActivity(this.getActivityId(profile));
    }
}

