/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.plugin;

import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.HashMap;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml")})
public class ProfilePropertySettingOptionTranslationTest
extends AbstractKernelTest {
    private TranslationService translationService;

    public void setUp() throws Exception {
        super.setUp();
        this.translationService = (TranslationService)this.getContainer().getComponentInstanceOfType(TranslationService.class);
        this.begin();
    }

    public void testTranslatePropertyOption() throws ObjectNotFoundException {
        HashMap<Locale, String> labels = new HashMap<Locale, String>();
        labels.put(Locale.US, "option en");
        labels.put(Locale.FRANCE, "option fr");
        this.translationService.saveTranslationLabels("propertySettingOption", 1L, "optionValue", labels);
        TranslationField translationField = this.translationService.getTranslationField("propertySettingOption", 1L, "optionValue");
        ProfilePropertySettingOptionTranslationTest.assertNotNull((Object)translationField);
        ProfilePropertySettingOptionTranslationTest.assertNotNull((Object)translationField.getLabels());
        ProfilePropertySettingOptionTranslationTest.assertEquals((int)2, (int)translationField.getLabels().size());
        this.end();
    }
}

