/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.FileAttachmentObject;
import org.exoplatform.social.attachment.model.FileAttachmentResourceList;
import org.exoplatform.social.attachment.model.ObjectAttachmentDetail;
import org.exoplatform.social.attachment.model.ObjectAttachmentList;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.mock.MockUploadService;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.upload.UploadService;

public class AttachmentActivityProcessorTest
extends AbstractCoreTest {
    private static final String MIME_TYPE = "image/png";
    private static final String FILE_NAME = "cover.png";
    private static final String UPLOAD_ID = "1234";
    private Identity demoIdentity;
    private MockUploadService uploadService;
    private ActivityManager activityManager;
    private AttachmentService attachmentService;
    private List<ExoSocialActivity> tearDownActivityList;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.attachmentService = (AttachmentService)this.getContainer().getComponentInstanceOfType(AttachmentService.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.uploadService = (MockUploadService)((Object)this.getContainer().getComponentInstanceOfType(UploadService.class));
        this.demoIdentity = this.identityManager.getOrCreateUserIdentity("demo");
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
    }

    @Override
    public void tearDown() throws Exception {
        this.restartTransaction();
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            this.activityManager.deleteActivity(activity.getId());
        }
        super.tearDown();
    }

    public void testGetActivityWithAttachmentsMetadataObject() throws Exception {
        String username = this.demoIdentity.getRemoteId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put("key1", "value 1");
        templateParams.put("key2", "value 2");
        templateParams.put("key3", "value 3");
        activity.setTemplateParams(templateParams);
        activity.setTitle("");
        activity.setUserId(this.demoIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add((ExoSocialActivity)activity);
        String fileId = this.createAttachment(username, activity.getId());
        ObjectAttachmentList objectAttachmentList = this.attachmentService.getAttachments("activity", activity.getId());
        AttachmentActivityProcessorTest.assertNotNull((Object)objectAttachmentList);
        List attachments = objectAttachmentList.getAttachments();
        AttachmentActivityProcessorTest.assertEquals((int)1, (int)attachments.size());
        ObjectAttachmentDetail attachmentDetail = (ObjectAttachmentDetail)attachments.get(0);
        AttachmentActivityProcessorTest.assertNotNull((Object)attachmentDetail);
        AttachmentActivityProcessorTest.assertEquals((String)FILE_NAME, (String)attachmentDetail.getName());
        AttachmentActivityProcessorTest.assertEquals((String)MIME_TYPE, (String)attachmentDetail.getMimetype());
        AttachmentActivityProcessorTest.assertEquals((String)fileId, (String)attachmentDetail.getId());
        AttachmentActivityProcessorTest.assertTrue((attachmentDetail.getUpdated() > 0L ? 1 : 0) != 0);
        AttachmentActivityProcessorTest.assertEquals((String)this.demoIdentity.getId(), (String)attachmentDetail.getUpdater());
    }

    private String createAttachment(String username, String activityId) throws IOException, Exception {
        String identityId = this.identityManager.getOrCreateUserIdentity(username).getId();
        FileAttachmentResourceList attachmentList = new FileAttachmentResourceList();
        attachmentList.setAttachedFiles(null);
        attachmentList.setUserIdentityId(Long.parseLong(identityId));
        attachmentList.setObjectType("activity");
        attachmentList.setObjectId(activityId);
        FileAttachmentObject fileAttachmentObject = new FileAttachmentObject();
        fileAttachmentObject.setUploadId(UPLOAD_ID);
        fileAttachmentObject.setAltText("Test alternative text");
        attachmentList.setUploadedFiles(Collections.singletonList(fileAttachmentObject));
        this.uploadResource();
        this.attachmentService.saveAttachments(attachmentList);
        ObjectAttachmentList objectAttachmentList = this.attachmentService.getAttachments("activity", activityId);
        return ((ObjectAttachmentDetail)objectAttachmentList.getAttachments().get(0)).getId();
    }

    private void uploadResource() throws IOException, Exception {
        File tempFile = File.createTempFile("image", "temp");
        this.uploadService.createUploadResource(UPLOAD_ID, tempFile.getPath(), FILE_NAME, MIME_TYPE);
    }
}

