/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class SpaceUtilsTest
extends AbstractCoreTest {
    private IdentityStorage identityStorage;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
    }

    public void testRemoveSpecialCharacter() {
        SpaceUtilsTest.assertEquals((String)"The filter should only filter special characters only", (String)"script alert 'Hello' script 100", (String)Utils.removeSpecialCharacterInSpaceFilter((String)"<script>alert('Hello');</script> 100"));
        SpaceUtilsTest.assertEquals((String)"The filter should keep wildcard *,? and %", (String)"% * '?", (String)Utils.removeSpecialCharacterInSpaceFilter((String)"( ) %{ } * [ ] '? \""));
    }

    public void testProcessUnifiedSearchCondition() {
        String input = "spa~ce~0.5";
        SpaceUtilsTest.assertEquals((String)"spa~ce", (String)Utils.processUnifiedSearchCondition((String)input));
        input = "space~0.5";
        SpaceUtilsTest.assertEquals((String)"space", (String)Utils.processUnifiedSearchCondition((String)input));
        input = "space~0.5 test~0.5";
        SpaceUtilsTest.assertEquals((String)"space test", (String)Utils.processUnifiedSearchCondition((String)input));
    }

    public void testUpdateDefaultUserAvatar() {
        Identity jamesIdentity = this.identityManager.getOrCreateUserIdentity("james");
        FileItem avatarFile = this.identityStorage.getAvatarFile(jamesIdentity);
        Profile profile = this.identityStorage.loadProfile(jamesIdentity.getProfile());
        SpaceUtilsTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        SpaceUtilsTest.assertTrue((boolean)profile.isDefaultAvatar());
        Long avatarFileId = avatarFile.getFileInfo().getId();
        SpaceUtilsTest.assertNotNull((Object)avatarFileId);
        profile.setProperty("test", (Object)"test");
        this.identityStorage.updateProfile(profile);
        profile = this.identityStorage.loadProfile(profile);
        SpaceUtilsTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        SpaceUtilsTest.assertTrue((boolean)profile.isDefaultAvatar());
        SpaceUtilsTest.assertEquals((String)"Avatar File shouldn't change if User not renamed", (Object)avatarFileId, (Object)avatarFile.getFileInfo().getId());
    }
}

