/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.storage;

import io.meeds.social.space.model.SpaceDirectorySettings;
import io.meeds.social.space.storage.SpaceDirectoryStorage;
import io.meeds.social.util.JsonUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.junit4.SpringRunner;

@SpringBootTest(classes={SpaceDirectoryStorage.class})
@RunWith(value=SpringRunner.class)
public class SpaceDirectoryStorageTest {
    private static final String SETTING_NAME = "settingName";
    @MockBean
    private SettingService settingService;
    @Autowired
    private SpaceDirectoryStorage spaceDirectoryStorage;

    @Test
    public void testSave() {
        SpaceDirectorySettings spaceDirectorySettings = new SpaceDirectorySettings();
        this.spaceDirectoryStorage.save(SETTING_NAME, spaceDirectorySettings);
        ((SettingService)Mockito.verify((Object)this.settingService)).set((Context)ArgumentMatchers.eq((Object)SpaceDirectoryStorage.CONTEXT), (Scope)ArgumentMatchers.eq((Object)SpaceDirectoryStorage.SCOPE), (String)ArgumentMatchers.eq((Object)SETTING_NAME), (SettingValue)ArgumentMatchers.argThat(s -> s.getValue().toString().equals(JsonUtils.toJsonString((Object)spaceDirectorySettings))));
    }

    @Test
    public void testRemove() {
        this.spaceDirectoryStorage.remove(SETTING_NAME);
        ((SettingService)Mockito.verify((Object)this.settingService)).remove(SpaceDirectoryStorage.CONTEXT, SpaceDirectoryStorage.SCOPE, SETTING_NAME);
    }

    @Test
    public void testGet() {
        Assert.assertNull((Object)this.spaceDirectoryStorage.get(SETTING_NAME));
        Mockito.when((Object)this.settingService.get(SpaceDirectoryStorage.CONTEXT, SpaceDirectoryStorage.SCOPE, SETTING_NAME)).thenReturn((Object)SettingValue.create((String)"{}"));
        Assert.assertNotNull((Object)this.spaceDirectoryStorage.get(SETTING_NAME));
    }
}

