/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.plugin.attachment;

import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.plugin.attachment.SpaceTemplateBannerAttachmentPlugin;
import io.meeds.social.space.template.service.SpaceTemplateService;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceTemplateBannerAttachmentPluginTest {
    @Mock
    private SpaceTemplateService spaceTemplateService;
    @Mock
    private AttachmentService attachmentService;
    private SpaceTemplateBannerAttachmentPlugin attachmentPlugin;
    @Mock
    private Identity userIdentity;
    @Mock
    private SpaceTemplate spaceTemplate;

    @Before
    public void init() {
        this.attachmentPlugin = new SpaceTemplateBannerAttachmentPlugin();
        this.attachmentPlugin.attachmentService = this.attachmentService;
        this.attachmentPlugin.spaceTemplateService = this.spaceTemplateService;
    }

    @Test
    public void getObjectType() {
        Assert.assertEquals((Object)"spaceTemplateBanner", (Object)this.attachmentPlugin.getObjectType());
    }

    @Test
    public void testHasEditPermission() {
        Assert.assertFalse((boolean)this.attachmentPlugin.hasEditPermission(null, null));
        Assert.assertFalse((boolean)this.attachmentPlugin.hasEditPermission(this.userIdentity, null));
        Mockito.when((Object)this.userIdentity.getUserId()).thenReturn((Object)"test");
        Assert.assertFalse((boolean)this.attachmentPlugin.hasEditPermission(this.userIdentity, null));
        Mockito.when((Object)this.spaceTemplateService.canManageTemplates("test")).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.attachmentPlugin.hasEditPermission(this.userIdentity, "2"));
    }

    @Test
    public void testHasAccessPermission() {
        Assert.assertFalse((boolean)this.attachmentPlugin.hasAccessPermission(null, null));
        Assert.assertFalse((boolean)this.attachmentPlugin.hasAccessPermission(this.userIdentity, null));
        Assert.assertFalse((boolean)this.attachmentPlugin.hasAccessPermission(null, "2"));
        Mockito.when((Object)this.userIdentity.getUserId()).thenReturn((Object)"test");
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.attachmentPlugin.hasAccessPermission(this.userIdentity, "2"));
        Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(2L)).thenReturn((Object)this.spaceTemplate);
        Assert.assertFalse((boolean)this.attachmentPlugin.hasAccessPermission(this.userIdentity, "2"));
        Mockito.when((Object)this.spaceTemplateService.canViewTemplate(2L, "test")).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.attachmentPlugin.hasAccessPermission(this.userIdentity, "2"));
    }

    @Test
    public void getAudienceId() {
        Assert.assertEquals((long)0L, (long)this.attachmentPlugin.getAudienceId(null));
    }

    @Test
    public void getSpaceId() {
        Assert.assertEquals((long)0L, (long)this.attachmentPlugin.getSpaceId(""));
    }
}

