/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.social.navigation.AbstractNavigationConfigurationTest;
import io.meeds.social.util.JsonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.junit.Test;

public class LinkSidebarPluginTest
extends AbstractNavigationConfigurationTest {
    @Test
    public void testGetType() {
        LinkSidebarPluginTest.assertEquals((Object)SidebarItemType.LINK, (Object)this.linkSidebarPlugin.getType());
    }

    @Test
    public void testGetDefaultItems() {
        List defaultItems = this.linkSidebarPlugin.getDefaultItems();
        LinkSidebarPluginTest.assertNotNull((Object)defaultItems);
        LinkSidebarPluginTest.assertTrue((boolean)defaultItems.isEmpty());
    }

    @Test
    public void testItemExists() {
        LinkSidebarPluginTest.assertTrue((boolean)this.linkSidebarPlugin.itemExists(null, null));
    }

    @Test
    public void testResolveProperties() {
        String enName = "Test EN";
        String frName = "Test FR";
        HashMap<String, String> names = new HashMap<String, String>();
        names.put(Locale.ENGLISH.toLanguageTag(), enName);
        names.put(Locale.FRENCH.toLanguageTag(), frName);
        String namesJsonString = JsonUtils.toJsonString(names);
        SidebarItem item = new SidebarItem("fakeName", "url", "target", "avatar", "icon", SidebarItemType.LINK, null, Collections.singletonMap("names", namesJsonString), false);
        SidebarItem result = this.linkSidebarPlugin.resolveProperties(item, null, Locale.ENGLISH);
        LinkSidebarPluginTest.assertNotNull((Object)result);
        LinkSidebarPluginTest.assertEquals((String)enName, (String)result.getName());
        result = this.linkSidebarPlugin.resolveProperties(item, null, Locale.FRENCH);
        LinkSidebarPluginTest.assertNotNull((Object)result);
        LinkSidebarPluginTest.assertEquals((String)frName, (String)result.getName());
    }
}

