/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.service;

import io.meeds.portal.navigation.constant.SidebarMode;
import io.meeds.portal.navigation.model.NavigationConfiguration;
import io.meeds.portal.navigation.model.SidebarConfiguration;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.portal.navigation.model.TopbarConfiguration;
import io.meeds.social.navigation.AbstractNavigationConfigurationTest;
import java.util.Locale;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NavigationConfigurationServiceTest
extends AbstractNavigationConfigurationTest {
    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
        if (this.spaceTemplate == null) {
            this.mockSpaceTemplate();
            for (int i = 0; i < 5; ++i) {
                Space space = new Space();
                space.setRegistration("open");
                space.setVisibility("public");
                space.setTemplateId(this.spaceTemplate.getId());
                this.spaceService.createSpace(space, this.userAcl.getSuperUser());
            }
        }
    }

    @Test
    public void testGetConfiguration() {
        NavigationConfiguration configuration = this.navigationConfigurationService.getConfiguration();
        Assert.assertNotNull((Object)configuration);
        Assert.assertNotNull((Object)configuration.getTopbar());
        Assert.assertNotNull((Object)configuration.getSidebar());
    }

    @Test
    public void testGetConfigurationByUser() {
        NavigationConfiguration configuration = this.navigationConfigurationService.getConfiguration(this.userAcl.getSuperUser(), Locale.FRENCH, true);
        Assert.assertNotNull((Object)configuration);
        TopbarConfiguration topbar = configuration.getTopbar();
        Assert.assertNotNull((Object)topbar);
        Assert.assertTrue((boolean)topbar.isDisplayCompanyName());
        Assert.assertTrue((boolean)topbar.isDisplaySiteName());
        SidebarConfiguration sidebar = configuration.getSidebar();
        Assert.assertNotNull((Object)sidebar);
        Assert.assertTrue((boolean)sidebar.isAllowUserCustomHome());
        Assert.assertEquals((long)3L, (long)sidebar.getAllowedModes().size());
        Assert.assertEquals((Object)SidebarMode.ICON, (Object)sidebar.getDefaultMode());
        Assert.assertNotNull((Object)sidebar.getItems());
        Assert.assertFalse((boolean)sidebar.getItems().isEmpty());
        SidebarItem item = (SidebarItem)sidebar.getItems().getFirst();
        Assert.assertEquals((Object)"contribute", (Object)item.getName());
    }

    @Test
    public void testSidebarUserMode() {
        NavigationConfiguration configuration = this.navigationConfigurationService.getConfiguration(this.userAcl.getSuperUser(), Locale.FRENCH, true);
        SidebarMode sidebarUserMode = this.navigationConfigurationService.getSidebarUserMode(this.userAcl.getSuperUser());
        Assert.assertEquals((Object)configuration.getSidebar().getDefaultMode(), (Object)sidebarUserMode);
        this.navigationConfigurationService.updateSidebarUserMode(this.userAcl.getSuperUser(), SidebarMode.STICKY);
        sidebarUserMode = this.navigationConfigurationService.getSidebarUserMode(this.userAcl.getSuperUser());
        Assert.assertEquals((Object)SidebarMode.STICKY, (Object)sidebarUserMode);
        this.navigationConfigurationService.updateSidebarUserMode(this.userAcl.getSuperUser(), SidebarMode.ICON);
        sidebarUserMode = this.navigationConfigurationService.getSidebarUserMode(this.userAcl.getSuperUser());
        Assert.assertEquals((Object)SidebarMode.ICON, (Object)sidebarUserMode);
    }
}

