/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.storage;

import io.meeds.social.space.constant.SpaceRegistration;
import io.meeds.social.space.constant.SpaceVisibility;
import io.meeds.social.space.template.dao.SpaceTemplateDAO;
import io.meeds.social.space.template.entity.SpaceTemplateEntity;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.storage.SpaceTemplateStorage;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.data.domain.Pageable;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceTemplateStorageTest {
    private static final String SPACE_FIELDS = "spaceFields";
    private static final String SPACE_CREATE_PERMISSIONS = "permissions";
    private static final String SPACE_ADMIN_PERMISSIONS = "adminPermissions";
    private static final String SPACE_LAYOUT_PERMISSIONS = "spaceLayoutPermissions";
    private static final String SPACE_DELETE_PERMISSIONS = "spaceDeletePermissions";
    private static final String SPACE_PUBLIC_SITE_PERMISSIONS = "spacePublicSitePermissions";
    private static final long SPACE_CATEGORY_ID = 2L;
    @Mock
    private SpaceTemplateDAO spaceTemplateDAO;
    private SpaceTemplateStorage spaceTemplateStorage;

    @Before
    public void init() {
        this.spaceTemplateStorage = new SpaceTemplateStorage(this.spaceTemplateDAO);
    }

    @Test
    public void testGetSpaceTemplates() {
        SpaceTemplateEntity spaceTemplateEntity = this.newSpaceTemplateEntity();
        Mockito.when((Object)this.spaceTemplateDAO.findByDeletedFalse((Pageable)ArgumentMatchers.any())).thenAnswer(invocation -> List.of(spaceTemplateEntity));
        List spaceTemplates = this.spaceTemplateStorage.getSpaceTemplates(Pageable.unpaged());
        Assert.assertNotNull((Object)spaceTemplates);
        Assert.assertEquals((long)1L, (long)spaceTemplates.size());
        spaceTemplates = this.spaceTemplateStorage.getSpaceTemplates(Pageable.unpaged());
        SpaceTemplate spaceTemplate = (SpaceTemplate)spaceTemplates.get(0);
        this.checkEntityEqualsModel(spaceTemplateEntity, spaceTemplate);
    }

    @Test
    public void testGetEnabledSpaceTemplates() {
        SpaceTemplateEntity spaceTemplateEntity = this.newSpaceTemplateEntity();
        Mockito.when((Object)this.spaceTemplateDAO.findByDeletedFalseAndEnabledTrue((Pageable)ArgumentMatchers.any())).thenAnswer(invocation -> List.of(spaceTemplateEntity));
        List spaceTemplates = this.spaceTemplateStorage.getEnabledSpaceTemplates(Pageable.unpaged());
        Assert.assertNotNull((Object)spaceTemplates);
        Assert.assertEquals((long)1L, (long)spaceTemplates.size());
        spaceTemplates = this.spaceTemplateStorage.getEnabledSpaceTemplates(Pageable.unpaged());
        SpaceTemplate spaceTemplate = (SpaceTemplate)spaceTemplates.get(0);
        this.checkEntityEqualsModel(spaceTemplateEntity, spaceTemplate);
    }

    @Test
    public void testGetSpaceTemplate() {
        Assert.assertNull((Object)this.spaceTemplateStorage.getSpaceTemplate(3L));
        SpaceTemplateEntity spaceTemplateEntity = this.newSpaceTemplateEntity();
        Mockito.when((Object)this.spaceTemplateDAO.findById((Object)3L)).thenAnswer(invocation -> Optional.of(spaceTemplateEntity));
        SpaceTemplate spaceTemplate = this.spaceTemplateStorage.getSpaceTemplate(3L);
        Assert.assertNotNull((Object)spaceTemplate);
        this.checkEntityEqualsModel(spaceTemplateEntity, spaceTemplate);
    }

    @Test
    public void testCreateSpaceTemplate() {
        SpaceTemplate spaceTemplate = this.newSpaceTemplate();
        Mockito.when((Object)this.spaceTemplateDAO.save((Object)((SpaceTemplateEntity)ArgumentMatchers.any()))).thenReturn((Object)this.newSpaceTemplateEntity());
        SpaceTemplate createdSpaceTemplate = this.spaceTemplateStorage.createSpaceTemplate(spaceTemplate);
        Assert.assertNotNull((Object)createdSpaceTemplate);
        spaceTemplate.setName(null);
        spaceTemplate.setDescription(null);
        spaceTemplate.setBannerFileId(0L);
        Assert.assertEquals((Object)spaceTemplate, (Object)createdSpaceTemplate);
    }

    @Test
    public void testUpdateSpaceTemplate() throws ObjectNotFoundException {
        SpaceTemplate spaceTemplate = this.newSpaceTemplate();
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.spaceTemplateStorage.updateSpaceTemplate(spaceTemplate));
        Mockito.when((Object)this.spaceTemplateDAO.existsById((Object)spaceTemplate.getId())).thenReturn((Object)true);
        Mockito.when((Object)this.spaceTemplateDAO.save((Object)((SpaceTemplateEntity)ArgumentMatchers.any()))).thenReturn((Object)this.newSpaceTemplateEntity());
        SpaceTemplate updatedSpaceTemplate = this.spaceTemplateStorage.updateSpaceTemplate(spaceTemplate);
        Assert.assertNotNull((Object)updatedSpaceTemplate);
        spaceTemplate.setName(null);
        spaceTemplate.setDescription(null);
        spaceTemplate.setBannerFileId(0L);
        Assert.assertEquals((Object)spaceTemplate, (Object)updatedSpaceTemplate);
    }

    @Test
    public void testDeleteSpaceTemplate() {
        this.spaceTemplateStorage.deleteSpaceTemplate(2L);
        ((SpaceTemplateDAO)Mockito.verify((Object)this.spaceTemplateDAO)).deleteById((Object)2L);
    }

    private void checkEntityEqualsModel(SpaceTemplateEntity spaceTemplateEntity, SpaceTemplate spaceTemplate) {
        Assert.assertNotNull((Object)spaceTemplate);
        Assert.assertEquals((long)spaceTemplateEntity.getId(), (long)spaceTemplate.getId());
        Assert.assertEquals((Object)spaceTemplateEntity.getIcon(), (Object)spaceTemplate.getIcon());
        Assert.assertEquals((Object)spaceTemplateEntity.getIcon(), (Object)spaceTemplate.getIcon());
        Assert.assertEquals((Object)spaceTemplateEntity.isEnabled(), (Object)spaceTemplate.isEnabled());
        Assert.assertEquals((Object)spaceTemplateEntity.isDeleted(), (Object)spaceTemplate.isDeleted());
        Assert.assertEquals((Object)spaceTemplateEntity.isSystem(), (Object)spaceTemplate.isSystem());
        Assert.assertEquals((Object)spaceTemplateEntity.getPermissions(), (Object)spaceTemplate.getPermissions());
        Assert.assertEquals((Object)SPACE_CREATE_PERMISSIONS, spaceTemplate.getPermissions().get(0));
        Assert.assertEquals((Object)spaceTemplateEntity.getAdminPermissions(), (Object)spaceTemplate.getAdminPermissions());
        Assert.assertEquals((Object)SPACE_ADMIN_PERMISSIONS, spaceTemplate.getAdminPermissions().get(0));
        Assert.assertEquals((Object)spaceTemplateEntity.getSpaceDeletePermissions(), (Object)spaceTemplate.getSpaceDeletePermissions());
        Assert.assertEquals((Object)SPACE_DELETE_PERMISSIONS, spaceTemplate.getSpaceDeletePermissions().get(0));
        Assert.assertEquals((Object)spaceTemplateEntity.getSpaceLayoutPermissions(), (Object)spaceTemplate.getSpaceLayoutPermissions());
        Assert.assertEquals((Object)SPACE_LAYOUT_PERMISSIONS, spaceTemplate.getSpaceLayoutPermissions().get(0));
        Assert.assertEquals((Object)spaceTemplateEntity.getSpacePublicSitePermissions(), (Object)spaceTemplate.getSpacePublicSitePermissions());
        Assert.assertEquals((Object)SPACE_PUBLIC_SITE_PERMISSIONS, spaceTemplate.getSpacePublicSitePermissions().get(0));
        Assert.assertEquals((Object)spaceTemplateEntity.getSpaceFields(), (Object)spaceTemplate.getSpaceFields());
        Assert.assertEquals((Object)spaceTemplateEntity.getSpaceDefaultVisibility(), (Object)spaceTemplate.getSpaceDefaultVisibility());
        Assert.assertEquals((Object)spaceTemplateEntity.getSpaceDefaultRegistration(), (Object)spaceTemplate.getSpaceDefaultRegistration());
        Assert.assertEquals((Object)spaceTemplateEntity.isSpaceAllowContentCreation(), (Object)spaceTemplate.isSpaceAllowContentCreation());
        if (spaceTemplateEntity.getSpaceDefaultCategoryIds() == null) {
            Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)spaceTemplate.getSpaceDefaultCategoryIds()));
        } else if (spaceTemplate.getSpaceDefaultCategoryIds() == null) {
            Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)spaceTemplateEntity.getSpaceDefaultCategoryIds()));
        } else {
            Assert.assertEquals((Object)spaceTemplateEntity.getSpaceDefaultCategoryIds(), spaceTemplate.getSpaceDefaultCategoryIds().stream().map(String::valueOf).toList());
        }
    }

    private SpaceTemplateEntity newSpaceTemplateEntity() {
        return new SpaceTemplateEntity(Long.valueOf(2L), "icon", true, false, true, "layout", Arrays.asList(SPACE_CREATE_PERMISSIONS), Arrays.asList(SPACE_ADMIN_PERMISSIONS), Arrays.asList(SPACE_LAYOUT_PERMISSIONS), Arrays.asList(SPACE_DELETE_PERMISSIONS), Arrays.asList(SPACE_PUBLIC_SITE_PERMISSIONS), Arrays.asList(SPACE_FIELDS), Arrays.asList(String.valueOf(2L)), SpaceVisibility.PRIVATE, SpaceRegistration.VALIDATION, true);
    }

    private SpaceTemplate newSpaceTemplate() {
        return new SpaceTemplate(2L, "name", "description", 6L, "icon", true, false, true, "layout", Arrays.asList(SPACE_CREATE_PERMISSIONS), Arrays.asList(SPACE_ADMIN_PERMISSIONS), Arrays.asList(SPACE_LAYOUT_PERMISSIONS), Arrays.asList(SPACE_DELETE_PERMISSIONS), Arrays.asList(SPACE_PUBLIC_SITE_PERMISSIONS), Arrays.asList(SPACE_FIELDS), Arrays.asList(2L), SpaceVisibility.PRIVATE, SpaceRegistration.VALIDATION, true);
    }
}

