/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.upgrade;

import io.meeds.social.upgrade.SpaceSettingPermissionUpgradePlugin;
import java.util.ArrayList;
import java.util.Arrays;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.PageDAOImpl;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.Test;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/exo.social.component.core-local-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/social.component.core-local-portal-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml")})
public class SpaceSettingPermissionUpgradePluginTest
extends AbstractCoreTest {
    private static final String PAGE_NAME = "SpaceSettingPortlet";

    @Override
    protected void setUp() {
        this.begin();
        this.spaceService = this.getService(SpaceService.class);
        this.identityManager = this.getService(IdentityManager.class);
        this.identityRegistry = this.getService(IdentityRegistry.class);
        this.spaceService = this.getService(SpaceService.class);
    }

    @Test
    public void testProcessUpgrade() {
        Page page;
        SpaceSettingPermissionUpgradePluginTest.assertTrue((boolean)(this.getService(PageDAO.class) instanceof PageDAOImpl));
        Space space = this.createSpace("spaceWithSettings", "root");
        String[] accessPermissions = new String[]{"*:" + space.getGroupId()};
        String managerPermission = "manager:" + space.getGroupId();
        LayoutService layoutService = this.getService(LayoutService.class);
        PortalConfig spacePortalConfig = layoutService.getPortalConfig(SiteKey.group((String)space.getGroupId()));
        if (spacePortalConfig == null) {
            spacePortalConfig = new PortalConfig(PortalConfig.GROUP_TYPE, space.getGroupId());
            spacePortalConfig.setAccessPermissions(accessPermissions);
            spacePortalConfig.setEditPermission(managerPermission);
            spacePortalConfig.setPortalLayout(new Container());
            layoutService.create(spacePortalConfig);
            this.restartTransaction();
        }
        if ((page = layoutService.getPage(String.format("group::%s::%s", space.getGroupId(), PAGE_NAME))) == null) {
            page = new Page(PortalConfig.GROUP_TYPE, space.getGroupId(), PAGE_NAME);
            spacePortalConfig.setAccessPermissions(accessPermissions);
            spacePortalConfig.setEditPermission(managerPermission);
            page.setChildren(new ArrayList());
            layoutService.save(new PageContext(page.getPageKey(), new PageState(PAGE_NAME, PAGE_NAME, false, null, Arrays.asList(accessPermissions), managerPermission)), page);
            this.restartTransaction();
            page = layoutService.getPage("group::" + space.getGroupId() + "::SpaceSettingPortlet");
        }
        SpaceSettingPermissionUpgradePluginTest.assertNotNull((Object)page);
        page.setAccessPermissions(accessPermissions);
        layoutService.save(new PageContext(page.getPageKey(), Utils.toPageState((Page)page)));
        this.getService(CacheService.class).getCacheInstance("portal.PageService").clearCache();
        this.restartTransaction();
        new SpaceSettingPermissionUpgradePlugin(this.getEntityManagerService(), this.getInitParams()).processUpgrade(null, null);
        page = layoutService.getPage("group::" + space.getGroupId() + "::SpaceSettingPortlet");
        SpaceSettingPermissionUpgradePluginTest.assertNotNull((Object)page);
        SpaceSettingPermissionUpgradePluginTest.assertNotNull((Object)page.getAccessPermissions());
        SpaceSettingPermissionUpgradePluginTest.assertEquals((int)1, (int)page.getAccessPermissions().length);
        SpaceSettingPermissionUpgradePluginTest.assertEquals((String)managerPermission, (String)page.getAccessPermissions()[0]);
    }

    private EntityManagerService getEntityManagerService() {
        return this.getService(EntityManagerService.class);
    }

    private InitParams getInitParams() {
        InitParams initParams = new InitParams();
        ValueParam productGroupIdValueParam = new ValueParam();
        productGroupIdValueParam.setName("product.group.id");
        productGroupIdValueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)productGroupIdValueParam);
        return initParams;
    }

    private Space createSpace(String spaceName, String creator) {
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(spaceName);
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setDescription("description of space" + spaceName);
        space.setVisibility("private");
        space.setRegistration("open");
        return this.spaceService.createSpace(space, creator);
    }
}

