/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.application.RelationshipPublisher;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class RelationshipPublisherTest
extends AbstractCoreTest {
    private final Log LOG = ExoLogger.getLogger(RelationshipPublisher.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private IdentityStorage identityStorage;
    private SocialStorageCacheService cacheService;
    private RelationshipManager relationshipManager;
    private RelationshipPublisher relationshipPublisher;
    private List<ExoSocialActivity> tearDownActivityList;
    private Identity rootIdentity;
    private Identity demoIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity raulIdentity;
    private Identity paulIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        RelationshipPublisherTest.assertNotNull((String)"activityManager must not be null", (Object)this.activityManager);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        RelationshipPublisherTest.assertNotNull((String)"identityManager must not be null", (Object)this.identityManager);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        RelationshipPublisherTest.assertNotNull((String)"relationshipManager must not be null", (Object)this.relationshipManager);
        this.relationshipPublisher = (RelationshipPublisher)this.getContainer().getComponentInstanceOfType(RelationshipPublisher.class);
        RelationshipPublisherTest.assertNotNull((String)"relationshipPublisher must not be null", (Object)this.relationshipPublisher);
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        RelationshipPublisherTest.assertNotNull((String)"identityStorage must not be null", (Object)this.identityStorage);
        this.cacheService = (SocialStorageCacheService)this.getContainer().getComponentInstanceOfType(SocialStorageCacheService.class);
        this.cacheService.getIdentityCache().clearCache();
        this.cacheService.getIdentityIndexCache().clearCache();
        this.rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root", true);
        this.demoIdentity = this.identityManager.getOrCreateIdentity("organization", "demo", true);
        this.johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john", true);
        this.maryIdentity = this.identityManager.getOrCreateIdentity("organization", "mary", true);
        this.raulIdentity = this.identityManager.getOrCreateIdentity("organization", "raul", true);
        this.paulIdentity = this.identityManager.getOrCreateIdentity("organization", "paul", true);
    }

    @Override
    public void tearDown() throws Exception {
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            try {
                this.activityManager.deleteActivity(activity.getId());
            }
            catch (Exception e) {
                this.LOG.warn((Object)("can not delete activity with id: " + activity.getId()));
            }
        }
        this.identityManager.deleteIdentity(this.rootIdentity);
        this.identityManager.deleteIdentity(this.demoIdentity);
        this.identityManager.deleteIdentity(this.johnIdentity);
        this.identityManager.deleteIdentity(this.maryIdentity);
        this.identityManager.deleteIdentity(this.raulIdentity);
        this.identityManager.deleteIdentity(this.paulIdentity);
        super.tearDown();
    }

    public void testConfirmedManyRelationship() {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.rootIdentity);
        Relationship rootToMaryRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToRaulRelationship = this.relationshipManager.inviteToConnect(this.raulIdentity, this.rootIdentity);
        Relationship rootToPaulRelationship = this.relationshipManager.inviteToConnect(this.paulIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.relationshipPublisher.confirmed(new RelationshipEvent(RelationshipEvent.Type.CONFIRM, this.relationshipManager, rootToDemoRelationship));
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        this.relationshipPublisher.confirmed(new RelationshipEvent(RelationshipEvent.Type.CONFIRM, this.relationshipManager, rootToJohnRelationship));
        this.relationshipManager.confirm(this.rootIdentity, this.maryIdentity);
        this.relationshipPublisher.confirmed(new RelationshipEvent(RelationshipEvent.Type.CONFIRM, this.relationshipManager, rootToMaryRelationship));
        this.relationshipManager.confirm(this.rootIdentity, this.raulIdentity);
        this.relationshipPublisher.confirmed(new RelationshipEvent(RelationshipEvent.Type.CONFIRM, this.relationshipManager, rootToRaulRelationship));
        this.relationshipManager.confirm(this.rootIdentity, this.paulIdentity);
        this.relationshipPublisher.confirmed(new RelationshipEvent(RelationshipEvent.Type.CONFIRM, this.relationshipManager, rootToPaulRelationship));
        String rootActivityId = this.identityStorage.getProfileActivityId(this.rootIdentity.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
        RelationshipPublisherTest.assertNotNull((Object)rootActivityId);
        ExoSocialActivity rootActivity = this.activityManager.getActivity(rootActivityId);
        List rootComments = this.activityManager.getCommentsWithListAccess(rootActivity).loadAsList(0, 10);
        RelationshipPublisherTest.assertEquals((int)5, (int)rootComments.size());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with 5 user(s)", (String)rootActivity.getTitle());
        String johnActivityId = this.identityStorage.getProfileActivityId(this.johnIdentity.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
        String maryActivityId = this.identityStorage.getProfileActivityId(this.maryIdentity.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
        String demoActivityId = this.identityStorage.getProfileActivityId(this.demoIdentity.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
        String raulActivityId = this.identityStorage.getProfileActivityId(this.raulIdentity.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
        String paulActivityId = this.identityStorage.getProfileActivityId(this.paulIdentity.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
        this.activityManager.deleteActivity(rootActivityId);
        this.activityManager.deleteActivity(johnActivityId);
        this.activityManager.deleteActivity(maryActivityId);
        this.activityManager.deleteActivity(demoActivityId);
        this.activityManager.deleteActivity(raulActivityId);
        this.activityManager.deleteActivity(paulActivityId);
    }

    public void testConfirmed() {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.relationshipPublisher.confirmed(new RelationshipEvent(RelationshipEvent.Type.CONFIRM, this.relationshipManager, rootToDemoRelationship));
        String rootActivityId = this.identityStorage.getProfileActivityId(this.rootIdentity.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
        RelationshipPublisherTest.assertNotNull((Object)rootActivityId);
        ExoSocialActivity rootActivity = this.activityManager.getActivity(rootActivityId);
        List rootComments = this.activityManager.getCommentsWithListAccess(rootActivity).loadAsList(0, 10);
        RelationshipPublisherTest.assertEquals((int)1, (int)rootComments.size());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with 1 user(s)", (String)rootActivity.getTitle());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with Demo gtn", (String)((ExoSocialActivity)rootComments.get(0)).getTitle());
        String demoActivityId = this.identityStorage.getProfileActivityId(this.demoIdentity.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
        RelationshipPublisherTest.assertNotNull((Object)demoActivityId);
        ExoSocialActivity demoActivity = this.activityManager.getActivity(demoActivityId);
        List demoComments = this.activityManager.getCommentsWithListAccess(demoActivity).loadAsList(0, 10);
        RelationshipPublisherTest.assertEquals((int)1, (int)demoComments.size());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with 1 user(s)", (String)demoActivity.getTitle());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with Root Root", (String)((ExoSocialActivity)demoComments.get(0)).getTitle());
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        this.relationshipPublisher.confirmed(new RelationshipEvent(RelationshipEvent.Type.CONFIRM, this.relationshipManager, rootToJohnRelationship));
        rootActivity = this.activityManager.getActivity(rootActivityId);
        rootComments = this.activityManager.getCommentsWithListAccess(rootActivity).loadAsList(0, 10);
        RelationshipPublisherTest.assertEquals((int)2, (int)rootComments.size());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with 2 user(s)", (String)rootActivity.getTitle());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with John Anthony", (String)((ExoSocialActivity)rootComments.get(1)).getTitle());
        String johnActivityId = this.identityStorage.getProfileActivityId(this.johnIdentity.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
        RelationshipPublisherTest.assertNotNull((Object)johnActivityId);
        ExoSocialActivity johnActivity = this.activityManager.getActivity(johnActivityId);
        List johnComments = this.activityManager.getCommentsWithListAccess(johnActivity).loadAsList(0, 10);
        RelationshipPublisherTest.assertEquals((int)1, (int)johnComments.size());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with 1 user(s)", (String)johnActivity.getTitle());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with Root Root", (String)((ExoSocialActivity)johnComments.get(0)).getTitle());
        rootToJohnRelationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.delete(rootToJohnRelationship);
        this.relationshipPublisher.removed(new RelationshipEvent(RelationshipEvent.Type.REMOVE, this.relationshipManager, rootToJohnRelationship));
        rootActivity = this.activityManager.getActivity(rootActivityId);
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with 1 user(s)", (String)rootActivity.getTitle());
        johnActivity = this.activityManager.getActivity(johnActivityId);
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with 0 user(s)", (String)johnActivity.getTitle());
        this.activityManager.deleteActivity(johnActivity);
        this.activityManager.deleteActivity(rootActivity);
        this.activityManager.deleteActivity(demoActivity);
    }

    public void testConfirmedAndUpdateProfile() throws Exception {
        Profile profile = this.rootIdentity.getProfile();
        profile.setAttachedActivityType(Profile.AttachedActivityType.USER);
        RelationshipPublisherTest.assertNull((Object)this.getActivityId(profile));
        profile.setProperty("position", (Object)"developer");
        profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
        this.identityManager.updateProfile(profile);
        RelationshipPublisherTest.assertNotNull((Object)this.getActivityId(profile));
        String activityId = this.getActivityId(profile);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        List comments = this.activityManager.getCommentsWithListAccess(activity).loadAsList(0, 20);
        RelationshipPublisherTest.assertEquals((int)1, (int)comments.size());
        RelationshipPublisherTest.assertEquals((String)"Contact informations has been updated.", (String)((ExoSocialActivity)comments.get(0)).getTitle());
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.relationshipPublisher.confirmed(new RelationshipEvent(RelationshipEvent.Type.CONFIRM, this.relationshipManager, rootToDemoRelationship));
        String rootActivityId = this.identityStorage.getProfileActivityId(this.rootIdentity.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
        RelationshipPublisherTest.assertNotNull((Object)rootActivityId);
        ExoSocialActivity rootActivity = this.activityManager.getActivity(rootActivityId);
        List rootComments = this.activityManager.getCommentsWithListAccess(rootActivity).loadAsList(0, 10);
        RelationshipPublisherTest.assertEquals((int)1, (int)rootComments.size());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with 1 user(s)", (String)rootActivity.getTitle());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with Demo gtn", (String)((ExoSocialActivity)rootComments.get(0)).getTitle());
        String demoActivityId = this.identityStorage.getProfileActivityId(this.demoIdentity.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
        RelationshipPublisherTest.assertNotNull((Object)demoActivityId);
        ExoSocialActivity demoActivity = this.activityManager.getActivity(demoActivityId);
        List demoComments = this.activityManager.getCommentsWithListAccess(demoActivity).loadAsList(0, 10);
        RelationshipPublisherTest.assertEquals((int)1, (int)demoComments.size());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with 1 user(s)", (String)demoActivity.getTitle());
        RelationshipPublisherTest.assertEquals((String)"I&#39;m now connected with Root Root", (String)((ExoSocialActivity)demoComments.get(0)).getTitle());
        this.relationshipManager.delete(rootToDemoRelationship);
        this.activityManager.deleteActivity(rootActivity);
        this.activityManager.deleteActivity(demoActivity);
    }

    private String getActivityId(Profile profile) {
        return this.identityStorage.getProfileActivityId(profile, Profile.AttachedActivityType.USER);
    }
}

