/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.resources.impl.BaseResourceBundlePlugin;
import org.exoplatform.services.resources.impl.BaseResourceBundleService;
import org.exoplatform.social.common.xmlprocessor.XMLProcessor;
import org.exoplatform.social.common.xmlprocessor.XMLProcessorImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.processor.ActivityResourceBundlePlugin;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.core.processor.I18NActivityUtils;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class I18NActivityProcessorTest
extends AbstractCoreTest {
    private I18NActivityProcessor i18NActivityProcessor;
    private ActivityResourceBundlePlugin activityResourceBundlePlugin;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        PropertyManager.setProperty((String)"exo.product.developing", (String)"true");
        this.i18NActivityProcessor = new I18NActivityProcessor((XMLProcessor)new XMLProcessorImpl());
        FakeResourceBundleService fakeResourceBundleService = this.getResourceBundleService();
        this.i18NActivityProcessor.setResourceBundleService((ResourceBundleService)fakeResourceBundleService);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testNoRegisteredActivityResourceBundlePlugin() throws Exception {
        HashMap<String, String> activityKeyTypeMapping = new HashMap<String, String>();
        activityKeyTypeMapping.put("hello", "FakeResourceBundle.hello");
        this.initActivityResourceBundlePlugin(activityKeyTypeMapping);
        String title = "hello world from title.";
        ExoSocialActivity activity = this.createActivity("hello", "hello world from title.");
        Locale enLocale = new Locale("en");
        ExoSocialActivity newActivity1 = this.i18NActivityProcessor.process(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"hello world from title.", (String)newActivity1.getTitle());
    }

    public void testAddActivityResourceBundlePlugin() throws Exception {
        HashMap<String, String> activityKeyTypeMapping = new HashMap<String, String>();
        activityKeyTypeMapping.put("hello", "FakeResourceBundle.hello");
        this.initActivityResourceBundlePlugin(activityKeyTypeMapping);
        String title = "hello world from title.";
        ExoSocialActivity activity = this.createActivity("hello", "hello world from title.");
        Locale enLocale = new Locale("en");
        this.i18NActivityProcessor.addActivityResourceBundlePlugin(this.activityResourceBundlePlugin);
        ExoSocialActivity newActivity2 = this.i18NActivityProcessor.process(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"Hello from resource bundle (EN).", (String)newActivity2.getTitle());
        Locale frLocale = new Locale("fr");
        ExoSocialActivity newActivity3 = this.i18NActivityProcessor.process(activity, frLocale);
        I18NActivityProcessorTest.assertEquals((String)"Hello from resource bundle (FR).", (String)newActivity3.getTitle());
    }

    public void testRemoveActivityResourceBundlePlugin() throws Exception {
        HashMap<String, String> activityKeyTypeMapping = new HashMap<String, String>();
        activityKeyTypeMapping.put("hello", "FakeResourceBundle.hello");
        this.initActivityResourceBundlePlugin(activityKeyTypeMapping);
        String title = "hello world from title.";
        this.i18NActivityProcessor.addActivityResourceBundlePlugin(this.activityResourceBundlePlugin);
        ExoSocialActivity activity = this.createActivity("hello", "hello world from title.");
        Locale enLocale = new Locale("en");
        ExoSocialActivity newActivity1 = this.i18NActivityProcessor.process(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"Hello from resource bundle (EN).", (String)newActivity1.getTitle());
        this.i18NActivityProcessor.removeActivityResourceBundlePlugin(this.activityResourceBundlePlugin);
        ExoSocialActivity activity2 = this.createActivity("hello", "hello world from title.");
        ExoSocialActivity newActivity2 = this.i18NActivityProcessor.process(activity2, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"hello world from title.", (String)newActivity2.getTitle());
    }

    public void testCompoundMessages() throws Exception {
        LinkedHashMap<String, String> activityKeyTypeMapping = new LinkedHashMap<String, String>();
        activityKeyTypeMapping.put("spaceships_detected", "FakeResourceBundle.time_day_number_detected_spaceships_on_planet");
        this.initActivityResourceBundlePlugin(activityKeyTypeMapping);
        this.i18NActivityProcessor.addActivityResourceBundlePlugin(this.activityResourceBundlePlugin);
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put("planet", "Mars");
        templateParams.put("number", "10");
        templateParams.put("time", "02:00 PM");
        templateParams.put("date", "Feb 6, 2012");
        String title = "At 02:00 PM on Feb 6, 2012, we detected 10 spaceships on the planet Mars.";
        ExoSocialActivity activity = this.createActivity("spaceships_detected", "At 02:00 PM on Feb 6, 2012, we detected 10 spaceships on the planet Mars.");
        activity.setTemplateParams(templateParams);
        Locale enLocale = new Locale("en");
        ExoSocialActivity newActivity = this.i18NActivityProcessor.process(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"At 02:00 PM on Feb 6, 2012, we detected 10 spaceships on the planet Mars (EN).", (String)newActivity.getTitle());
    }

    public void testCompoundMessagesWithMultiKeys() throws Exception {
        LinkedHashMap<String, String> activityKeyTypeMapping = new LinkedHashMap<String, String>();
        activityKeyTypeMapping.put("add_topic", "add_topic");
        activityKeyTypeMapping.put("update_topic_title", "FakeResourceBundle.update_topic_title");
        activityKeyTypeMapping.put("update_topic_content", "FakeResourceBundle.update_topic_content");
        this.initActivityResourceBundlePlugin(activityKeyTypeMapping);
        this.i18NActivityProcessor.addActivityResourceBundlePlugin(this.activityResourceBundlePlugin);
        String title = "Title has been updated: edited topic title\nContent has been updated: edited topic content";
        ExoSocialActivity activity = this.createActivity("Title has been updated: edited topic title\nContent has been updated: edited topic content");
        I18NActivityUtils.addResourceKey((ExoSocialActivity)activity, (String)"update_topic_title", (String[])new String[]{"edited topic title"});
        I18NActivityUtils.addResourceKey((ExoSocialActivity)activity, (String)"update_topic_content", (String[])new String[]{"edited topic content"});
        Locale enLocale = new Locale("en");
        ExoSocialActivity newActivity = this.i18NActivityProcessor.processKeys(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"Title has been updated: edited topic title<br/>Content has been updated: edited topic content", (String)newActivity.getTitle());
    }

    public void testCompoundMessagesNew() throws Exception {
        LinkedHashMap<String, String> activityKeyTypeMapping = new LinkedHashMap<String, String>();
        activityKeyTypeMapping.put("add_topic", "add_topic");
        activityKeyTypeMapping.put("update_topic_title", "FakeResourceBundle.update_topic_title");
        activityKeyTypeMapping.put("update_topic_content", "FakeResourceBundle.update_topic_content");
        this.initActivityResourceBundlePlugin(activityKeyTypeMapping);
        this.i18NActivityProcessor.addActivityResourceBundlePlugin(this.activityResourceBundlePlugin);
        String title = "Title has been updated: edited topic title";
        ExoSocialActivity activity = this.createActivity("Title has been updated: edited topic title");
        I18NActivityUtils.addResourceKey((ExoSocialActivity)activity, (String)"update_topic_title", (String[])new String[]{"edited topic title"});
        Locale enLocale = new Locale("en");
        ExoSocialActivity newActivity = this.i18NActivityProcessor.processKeys(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"Title has been updated: edited topic title", (String)newActivity.getTitle());
    }

    public void testCompoundMessagesNewWithNull() throws Exception {
        LinkedHashMap<String, String> activityKeyTypeMapping = new LinkedHashMap<String, String>();
        activityKeyTypeMapping.put("add_topic", "add_topic");
        activityKeyTypeMapping.put("update_topic_title", "FakeResourceBundle.update_topic_title");
        activityKeyTypeMapping.put("update_topic_content", "FakeResourceBundle.update_topic_content");
        this.initActivityResourceBundlePlugin(activityKeyTypeMapping);
        this.i18NActivityProcessor.addActivityResourceBundlePlugin(this.activityResourceBundlePlugin);
        String title = "Title has been updated: ";
        ExoSocialActivity activity = this.createActivity("Title has been updated: ");
        I18NActivityUtils.addResourceKey((ExoSocialActivity)activity, (String)"update_topic_title", (String[])new String[0]);
        Locale enLocale = new Locale("en");
        ExoSocialActivity newActivity = this.i18NActivityProcessor.processKeys(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"Title has been updated: ", (String)newActivity.getTitle());
    }

    public void testCompoundMessagesNewWithEmpty() throws Exception {
        LinkedHashMap<String, String> activityKeyTypeMapping = new LinkedHashMap<String, String>();
        activityKeyTypeMapping.put("add_topic", "add_topic");
        activityKeyTypeMapping.put("update_topic_title", "FakeResourceBundle.update_topic_title");
        activityKeyTypeMapping.put("update_topic_content", "FakeResourceBundle.update_topic_content");
        this.initActivityResourceBundlePlugin(activityKeyTypeMapping);
        this.i18NActivityProcessor.addActivityResourceBundlePlugin(this.activityResourceBundlePlugin);
        String title = "Content has been updated: ";
        ExoSocialActivity activity = this.createActivity("Content has been updated: ");
        I18NActivityUtils.addResourceKey((ExoSocialActivity)activity, (String)"update_topic_content", (String[])new String[]{""});
        Locale enLocale = new Locale("en");
        ExoSocialActivity newActivity = this.i18NActivityProcessor.processKeys(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"Content has been updated: ", (String)newActivity.getTitle());
    }

    public void testProcessKeyForTitle() throws Exception {
        LinkedHashMap<String, String> activityKeyTypeMapping = new LinkedHashMap<String, String>();
        activityKeyTypeMapping.put("update_topic_title", "FakeResourceBundle.update_topic_title");
        this.initActivityResourceBundlePlugin(activityKeyTypeMapping);
        this.i18NActivityProcessor.addActivityResourceBundlePlugin(this.activityResourceBundlePlugin);
        String title = "Title has been updated: ";
        String value = "hello, where are you?";
        ExoSocialActivity activity = this.createActivity("Title has been updated: ");
        I18NActivityUtils.addResourceKey((ExoSocialActivity)activity, (String)"update_topic_title", (String[])new String[]{value});
        Locale enLocale = new Locale("en");
        ExoSocialActivity newActivity = this.i18NActivityProcessor.processKeys(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"Title has been updated: hello, where are you?", (String)newActivity.getTitle());
    }

    public void testCompoundSingleQuote() throws Exception {
        LinkedHashMap<String, String> activityKeyTypeMapping = new LinkedHashMap<String, String>();
        activityKeyTypeMapping.put("add_topic", "add_topic");
        activityKeyTypeMapping.put("update_topic_title", "FakeResourceBundle.update_topic_title");
        activityKeyTypeMapping.put("update_topic_content", "FakeResourceBundle.update_topic_content");
        activityKeyTypeMapping.put("test_single_quote", "FakeResourceBundle.test_single_quote");
        activityKeyTypeMapping.put("test_three_quote", "FakeResourceBundle.test_three_quote");
        this.initActivityResourceBundlePlugin(activityKeyTypeMapping);
        this.i18NActivityProcessor.addActivityResourceBundlePlugin(this.activityResourceBundlePlugin);
        String title = "I'm connected mary";
        ExoSocialActivity activity = this.createActivity(title);
        I18NActivityUtils.addResourceKey((ExoSocialActivity)activity, (String)"test_single_quote", (String[])new String[]{"mary"});
        Locale enLocale = new Locale("en");
        ExoSocialActivity newActivity = this.i18NActivityProcessor.processKeys(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"I'm connected to mary", (String)newActivity.getTitle());
        title = "I'm connected 'mary'";
        activity = this.createActivity(title);
        I18NActivityUtils.addResourceKey((ExoSocialActivity)activity, (String)"test_three_quote", (String[])new String[]{"mary"});
        newActivity = this.i18NActivityProcessor.processKeys(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"I'm connected to 'mary'", (String)newActivity.getTitle());
    }

    public void testNoRegisteredActivityKeyType() throws Exception {
        HashMap<String, String> activityKeyTypeMapping = new HashMap<String, String>();
        activityKeyTypeMapping.put("hello", "FakeResourceBundle.hello");
        this.initActivityResourceBundlePlugin(activityKeyTypeMapping);
        String title = "hello world from title.";
        this.i18NActivityProcessor.addActivityResourceBundlePlugin(this.activityResourceBundlePlugin);
        ExoSocialActivity activity = this.createActivity("hell", "hello world from title.");
        Locale enLocale = new Locale("en");
        ExoSocialActivity newActivity = this.i18NActivityProcessor.process(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"hello world from title.", (String)newActivity.getTitle());
    }

    public void testMissingMessageBundleKey() throws Exception {
        HashMap<String, String> activityKeyTypeMapping = new HashMap<String, String>();
        activityKeyTypeMapping.put("hello", "FakeResourceBundle.hello");
        activityKeyTypeMapping.put("hell", "FakeResourceBundle.hell");
        this.initActivityResourceBundlePlugin(activityKeyTypeMapping);
        String title = "hello world from title.";
        this.i18NActivityProcessor.addActivityResourceBundlePlugin(this.activityResourceBundlePlugin);
        ExoSocialActivity activity = this.createActivity("hell", "hello world from title.");
        Locale enLocale = new Locale("en");
        ExoSocialActivity newActivity = this.i18NActivityProcessor.process(activity, enLocale);
        I18NActivityProcessorTest.assertEquals((String)"hello world from title.", (String)newActivity.getTitle());
    }

    private FakeResourceBundleService getResourceBundleService() throws Exception {
        LocaleConfigService localeService = (LocaleConfigService)this.getContainer().getComponentInstanceOfType(LocaleConfigService.class);
        I18NActivityProcessorTest.assertNotNull((Object)localeService);
        FakeResourceBundleService fakeResourceBundleService = new FakeResourceBundleService(this, localeService);
        ValuesParam valuesParam = new ValuesParam();
        valuesParam.setName("classpath.resources");
        valuesParam.setDescription("register FakeResourceBundle message bundle");
        ArrayList<String> messageBundleKeys = new ArrayList<String>();
        messageBundleKeys.add("FakeResourceBundle");
        valuesParam.setValues(messageBundleKeys);
        InitParams initParams = new InitParams();
        initParams.addParam((Object)valuesParam);
        BaseResourceBundlePlugin resourceBundlePlugin = new BaseResourceBundlePlugin(initParams);
        fakeResourceBundleService.addResourceBundle(resourceBundlePlugin);
        return fakeResourceBundleService;
    }

    private ExoSocialActivity createActivity(String titleId, String title) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setType("fake-type");
        activity.setTitleId(titleId);
        activity.setTitle(title);
        return activity;
    }

    private ExoSocialActivity createActivity(String title) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setType("fake-type");
        activity.setTitle(title);
        return activity;
    }

    private void initActivityResourceBundlePlugin(Map<String, String> activityKeyTypeMapping) {
        InitParams initParams = new InitParams();
        initParams.addParam((Object)this.getObjectParameter("FakeResourceBundle", activityKeyTypeMapping));
        this.activityResourceBundlePlugin = new ActivityResourceBundlePlugin(initParams);
        this.activityResourceBundlePlugin.setName("fake-type");
    }

    private ObjectParameter getObjectParameter(String resourceBundleKeyFile, Map<String, String> activityKeyTypeMapping) {
        ObjectParameter objectParameter = new ObjectParameter();
        objectParameter.setName(resourceBundleKeyFile);
        ActivityResourceBundlePlugin pluginConfig = new ActivityResourceBundlePlugin();
        pluginConfig.setActivityKeyTypeMapping(activityKeyTypeMapping);
        objectParameter.setObject((Object)pluginConfig);
        return objectParameter;
    }

    private class FakeResourceBundleService
    extends BaseResourceBundleService {
        public FakeResourceBundleService(I18NActivityProcessorTest i18NActivityProcessorTest, LocaleConfigService localeService) {
            this.localeService_ = localeService;
        }

        protected ResourceBundle getResourceBundleFromDb(String id, ResourceBundle parent, Locale locale) throws Exception {
            return null;
        }

        public ResourceBundleData getResourceBundleData(String id) {
            return null;
        }

        public ResourceBundleData removeResourceBundleData(String id) {
            return null;
        }

        public void saveResourceBundle(ResourceBundleData data) {
        }

        public PageList<ResourceBundleData> findResourceDescriptions(Query q) {
            return null;
        }
    }
}

