/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.service;

import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.social.core.jpa.storage.dao.jpa.ProfileLabelDAO;
import org.exoplatform.social.core.model.ProfileLabel;
import org.exoplatform.social.core.profilelabel.ProfileLabelService;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.Assert;

public class ProfileLabelServiceTest
extends AbstractCoreTest {
    private ProfileLabelService profileLabelService;
    private ProfileLabelDAO labelDAO;
    private final String objectId = "1";
    private final String objectType = "testObject";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.profileLabelService = (ProfileLabelService)this.getContainer().getComponentInstanceOfType(ProfileLabelService.class);
        this.labelDAO = (ProfileLabelDAO)this.getContainer().getComponentInstanceOfType(ProfileLabelDAO.class);
    }

    @Override
    public void tearDown() throws Exception {
        this.restartTransaction();
        this.labelDAO.deleteAll();
        super.tearDown();
    }

    public void testCreateLabel() {
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.profileLabelService.createLabel(null));
        ProfileLabelServiceTest.assertEquals((String)"ProfileLabel Item Object is mandatory", (String)exception.getMessage());
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.profileLabelService.createLabel(new ProfileLabel()));
        ProfileLabelServiceTest.assertEquals((String)"Object type is mandatory", (String)exception.getMessage());
        ProfileLabel profileLabel = new ProfileLabel();
        profileLabel.setObjectType("testObject");
        ProfileLabel finalProfileLabel = profileLabel;
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.profileLabelService.createLabel(finalProfileLabel));
        ProfileLabelServiceTest.assertEquals((String)"Object Id is mandatory", (String)exception.getMessage());
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.profileLabelService.createLabel(this.createLabel("profileLabel", "")));
        ProfileLabelServiceTest.assertEquals((String)"language is mandatory", (String)exception.getMessage());
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.profileLabelService.createLabel(this.createLabel("", "fr")));
        ProfileLabelServiceTest.assertEquals((String)"profileLabel value is mandatory", (String)exception.getMessage());
        try {
            profileLabel = this.createLabel("test profileLabel fr", "fr");
            this.profileLabelService.createLabel(profileLabel);
            profileLabel = this.profileLabelService.findLabelByObjectTypeAndObjectIdAndLang("testObject", "1", "fr");
            ProfileLabelServiceTest.assertNotNull((Object)profileLabel.getId());
        }
        catch (Exception e) {
            ProfileLabelServiceTest.fail((String)e.getMessage());
        }
    }

    public void testCreateDuplicatedLabel() {
        try {
            this.profileLabelService.createLabel(this.createLabel("test label fr", "fr"));
            Throwable exception1 = Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.profileLabelService.createLabel(this.createLabel("test label fr", "fr")));
            ProfileLabelServiceTest.assertEquals((String)"ProfileLabel already exist", (String)exception1.getMessage());
        }
        catch (Exception e) {
            ProfileLabelServiceTest.fail((String)e.getMessage());
        }
    }

    public void testDeleteLabel() {
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.profileLabelService.deleteLabel(0L));
        ProfileLabelServiceTest.assertEquals((String)"ProfileLabel Technical Identifier is mandatory", (String)exception1.getMessage());
        try {
            this.profileLabelService.createLabel(this.createLabel("test profileLabel fr", "fr"));
            ProfileLabel profileLabel = this.profileLabelService.findLabelByObjectTypeAndObjectIdAndLang("testObject", "1", "fr");
            ProfileLabelServiceTest.assertNotNull((Object)profileLabel.getId());
            this.profileLabelService.deleteLabel(profileLabel.getId().longValue());
            profileLabel = this.profileLabelService.findLabelByObjectTypeAndObjectIdAndLang("testObject", "1", "fr");
            ProfileLabelServiceTest.assertNull((Object)profileLabel);
        }
        catch (Exception e) {
            ProfileLabelServiceTest.fail((String)e.getMessage());
        }
    }

    public void testUpdateLabel() {
        try {
            this.profileLabelService.createLabel(this.createLabel("test profileLabel fr", "fr"));
            ProfileLabel profileLabel = this.profileLabelService.findLabelByObjectTypeAndObjectIdAndLang("testObject", "1", "fr");
            ProfileLabelServiceTest.assertEquals((String)"test profileLabel fr", (String)profileLabel.getLabel());
            profileLabel.setLabel("test profileLabel fr 2");
            this.profileLabelService.updateLabel(profileLabel);
            profileLabel = this.profileLabelService.findLabelByObjectTypeAndObjectIdAndLang("testObject", "1", "fr");
            ProfileLabelServiceTest.assertEquals((String)"test profileLabel fr 2", (String)profileLabel.getLabel());
        }
        catch (Exception e) {
            ProfileLabelServiceTest.fail((String)e.getMessage());
        }
    }

    public void testFindLabelByObjectTypeAndObjectId() {
        try {
            ProfileLabelServiceTest.assertEquals((int)0, (int)this.profileLabelService.findLabelByObjectTypeAndObjectId("testObject", "1").size());
            this.profileLabelService.createLabel(this.createLabel("test label fr", "fr"));
            this.profileLabelService.createLabel(this.createLabel("test label en", "en"));
            this.profileLabelService.createLabel(this.createLabel("test label it", "it"));
            this.profileLabelService.createLabel(this.createLabel("test label de", "de"));
            ProfileLabelServiceTest.assertEquals((int)4, (int)this.profileLabelService.findLabelByObjectTypeAndObjectId("testObject", "1").size());
        }
        catch (Exception e) {
            ProfileLabelServiceTest.fail((String)e.getMessage());
        }
    }

    private ProfileLabel createLabel(String labelValue, String lang) {
        ProfileLabel profileLabel = new ProfileLabel();
        profileLabel.setLanguage(lang);
        profileLabel.setObjectType("testObject");
        profileLabel.setObjectId("1");
        profileLabel.setLabel(labelValue);
        return profileLabel;
    }
}

