/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.search;

import com.fasterxml.jackson.databind.JsonNode;
import io.meeds.social.search.SpaceSearchConnector;
import io.meeds.social.search.model.SpaceSearchFilter;
import io.meeds.social.search.model.SpaceSearchResult;
import io.meeds.social.space.constant.SpaceMembershipStatus;
import io.meeds.social.util.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceSearchConnectorTest {
    private static final String MEMBER = "member";
    private static final String PERMISSIONS_FIELD = "permissions";
    private static final String TERM = "term";
    private static final String PHRASE = "term1 term2";
    private static final long ID = 461L;
    private static final String SEARCH_RESULT = String.format("  {\n     \"hits\":{\n        \"hits\":[\n           {\n              \"_id\":\"%s\",\n              \"_score\":2.6705298,\n              \"highlight\":{\n                 \"displayName\":[\n                    \"<span class='searchMatchExcerpt'>Test</span> space\"\n                 ],\n                 \"description\":[\n                    \"<span class='searchMatchExcerpt'>Test</span> space #TestTag\"\n                 ]\n              }\n           }\n        ]\n     }\n  }\n", 461L);
    private static final String COUNT_RESULT = "        {\n   \"count\":1,\n   \"_shards\":{\n      \"total\":10,\n      \"successful\":10,\n      \"skipped\":0,\n      \"failed\":0\n   }\n}\n";
    private static final String USER_NAME = "testuser";
    private static final long USER_IDENTITY_ID = 25L;
    String index = "_space";
    String searchPath = "spaces-search-query.json";
    String countPath = "spaces-count-query.json";
    @Mock
    ConfigurationManager configurationManager;
    @Mock
    ElasticSearchingClient client;
    @Mock
    InitParams initParams;
    @Mock
    PropertiesParam param;
    SpaceSearchConnector spaceSearchConnector;

    @Before
    public void setup() {
        Mockito.when((Object)this.initParams.getPropertiesParam("constructor.params")).thenReturn((Object)this.param);
        Mockito.when((Object)this.param.getProperty("index")).thenReturn((Object)this.index);
        ValueParam valueParam = (ValueParam)Mockito.mock(ValueParam.class);
        Mockito.when((Object)this.initParams.getValueParam("query.file.path")).thenReturn((Object)valueParam);
        Mockito.when((Object)valueParam.getValue()).thenReturn((Object)this.searchPath);
        valueParam = (ValueParam)Mockito.mock(ValueParam.class);
        Mockito.when((Object)this.initParams.getValueParam("count.file.path")).thenReturn((Object)valueParam);
        Mockito.when((Object)valueParam.getValue()).thenReturn((Object)this.countPath);
        Mockito.when((Object)this.configurationManager.getInputStream(ArgumentMatchers.anyString())).thenAnswer(invocation -> this.getClass().getClassLoader().getResourceAsStream((String)invocation.getArgument(0)));
        this.spaceSearchConnector = new SpaceSearchConnector(this.configurationManager, this.client, this.initParams);
    }

    @Test
    public void testCountFavorites() {
        SpaceSearchFilter filter = new SpaceSearchFilter(USER_NAME, 25L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, true, null, null, null, null);
        Mockito.when((Object)this.client.countRequest((String)ArgumentMatchers.argThat(esQuery -> this.hasUserFavoriteQueryPart((String)esQuery) && this.hasPermissionQueryPart((String)esQuery, MEMBER, 1, USER_NAME)), (String)ArgumentMatchers.eq((Object)this.index))).thenReturn((Object)COUNT_RESULT);
        Assert.assertEquals((long)1L, (long)this.spaceSearchConnector.count(filter));
    }

    @Test
    public void testSearchFavorites() {
        SpaceSearchFilter filter = new SpaceSearchFilter(USER_NAME, 25L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, true, null, null, null, null);
        Mockito.when((Object)this.client.sendRequest((String)ArgumentMatchers.argThat(esQuery -> this.hasUserFavoriteQueryPart((String)esQuery) && this.hasPermissionQueryPart((String)esQuery, MEMBER, 1, USER_NAME)), (String)ArgumentMatchers.eq((Object)this.index))).thenReturn((Object)SEARCH_RESULT);
        List search = this.spaceSearchConnector.search(filter, 0L, 10L);
        Assert.assertEquals((long)1L, (long)search.size());
        Assert.assertNotNull((Object)((SpaceSearchResult)search.get(0)).getNameExcerpts());
        Assert.assertNotNull((Object)((SpaceSearchResult)search.get(0)).getDescriptionExcerpts());
        Assert.assertEquals((long)1L, (long)((SpaceSearchResult)search.get(0)).getNameExcerpts().size());
        Assert.assertEquals((long)1L, (long)((SpaceSearchResult)search.get(0)).getDescriptionExcerpts().size());
    }

    @Test
    public void testSearchManagingSpaces() {
        SpaceSearchFilter filter = new SpaceSearchFilter(USER_NAME, 25L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, true, null, null, null, null);
        filter.setManagingTemplateIds(Collections.singletonList(2L));
        Mockito.when((Object)this.client.sendRequest((String)ArgumentMatchers.argThat(esQuery -> this.hasUserFavoriteQueryPart((String)esQuery) && this.hasPermissionQueryPart((String)esQuery, MEMBER, 2, USER_NAME, String.format("@templateManager@%s", 2L))), (String)ArgumentMatchers.eq((Object)this.index))).thenReturn((Object)SEARCH_RESULT);
        List search = this.spaceSearchConnector.search(filter, 0L, 10L);
        Assert.assertEquals((long)1L, (long)search.size());
        Assert.assertNotNull((Object)((SpaceSearchResult)search.get(0)).getNameExcerpts());
        Assert.assertNotNull((Object)((SpaceSearchResult)search.get(0)).getDescriptionExcerpts());
        Assert.assertEquals((long)1L, (long)((SpaceSearchResult)search.get(0)).getNameExcerpts().size());
        Assert.assertEquals((long)1L, (long)((SpaceSearchResult)search.get(0)).getDescriptionExcerpts().size());
    }

    @Test
    public void testSearchSpacesByCategoryIds() {
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        categoryIds.add(25L);
        categoryIds.add(37L);
        SpaceSearchFilter filter = new SpaceSearchFilter(USER_NAME, 25L, Collections.emptyList(), Collections.emptyList(), categoryIds, Collections.emptyList(), null, true, null, null, null, null);
        Mockito.when((Object)this.client.sendRequest((String)ArgumentMatchers.argThat(esQuery -> this.hasCategoryIdsQueryPart((String)esQuery, (List<Long>)categoryIds)), (String)ArgumentMatchers.eq((Object)this.index))).thenReturn((Object)SEARCH_RESULT);
        List search = this.spaceSearchConnector.search(filter, 0L, 10L);
        Assert.assertEquals((long)1L, (long)search.size());
    }

    @Test
    public void testNotSearchWhenNotUnifiedSearch() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.spaceSearchConnector.search(new SpaceSearchFilter(USER_NAME, 25L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, false, null, SpaceMembershipStatus.MEMBER, null, null), 0L, 10L));
    }

    @Test
    public void testSearchMembers() {
        this.checkPermissionField(SpaceMembershipStatus.MEMBER, MEMBER);
    }

    @Test
    public void testSearchManagers() {
        this.checkPermissionField(SpaceMembershipStatus.MANAGER, "manager");
    }

    @Test
    public void testSearchPending() {
        this.checkPermissionField(SpaceMembershipStatus.PENDING, "pending");
    }

    @Test
    public void testSearchInvited() {
        this.checkPermissionField(SpaceMembershipStatus.INVITED, "invited");
    }

    @Test
    public void testSearchPublisher() {
        this.checkPermissionField(SpaceMembershipStatus.PUBLISHER, "publisher");
    }

    @Test
    public void testSearchRedactor() {
        this.checkPermissionField(SpaceMembershipStatus.REDACTOR, "redactor");
    }

    @Test
    public void testSearchSpaceNoMembership() {
        SpaceSearchFilter filter = new SpaceSearchFilter(USER_NAME, 25L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), PHRASE, false, null, null, null, null);
        Mockito.when((Object)this.client.sendRequest((String)ArgumentMatchers.argThat(esQuery -> this.hasNotUserFavoriteQueryPart((String)esQuery) && this.hasPermissionQueryPart((String)esQuery, PERMISSIONS_FIELD, 2, "all", USER_NAME)), (String)ArgumentMatchers.eq((Object)this.index))).thenReturn((Object)SEARCH_RESULT);
        List search = this.spaceSearchConnector.search(filter, 0L, 10L);
        Assert.assertEquals((long)1L, (long)search.size());
        Assert.assertNotNull((Object)((SpaceSearchResult)search.get(0)).getNameExcerpts());
        Assert.assertNotNull((Object)((SpaceSearchResult)search.get(0)).getDescriptionExcerpts());
        Assert.assertEquals((long)1L, (long)((SpaceSearchResult)search.get(0)).getNameExcerpts().size());
        Assert.assertEquals((long)1L, (long)((SpaceSearchResult)search.get(0)).getDescriptionExcerpts().size());
    }

    @Test
    public void testSearchTags() {
        SpaceSearchFilter filter = new SpaceSearchFilter(USER_NAME, 25L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, false, Arrays.asList("tag1", "tag2"), null, null, null);
        Mockito.when((Object)this.client.sendRequest((String)ArgumentMatchers.argThat(esQuery -> this.hasNotUserFavoriteQueryPart((String)esQuery) && this.hasPermissionQueryPart((String)esQuery, PERMISSIONS_FIELD, 2, "all", USER_NAME) && this.hasTagsQueryPart((String)esQuery, 2, "tag1", "tag2")), (String)ArgumentMatchers.eq((Object)this.index))).thenReturn((Object)SEARCH_RESULT);
        List search = this.spaceSearchConnector.search(filter, 0L, 10L);
        Assert.assertEquals((long)1L, (long)search.size());
        Assert.assertNotNull((Object)((SpaceSearchResult)search.get(0)).getNameExcerpts());
        Assert.assertNotNull((Object)((SpaceSearchResult)search.get(0)).getDescriptionExcerpts());
        Assert.assertEquals((long)1L, (long)((SpaceSearchResult)search.get(0)).getNameExcerpts().size());
        Assert.assertEquals((long)1L, (long)((SpaceSearchResult)search.get(0)).getDescriptionExcerpts().size());
    }

    private void checkPermissionField(SpaceMembershipStatus status, String fieldName) {
        SpaceSearchFilter filter = new SpaceSearchFilter(USER_NAME, 25L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), TERM, false, null, status, null, null);
        Mockito.when((Object)this.client.sendRequest((String)ArgumentMatchers.argThat(esQuery -> this.hasNotUserFavoriteQueryPart((String)esQuery) && this.hasPermissionQueryPart((String)esQuery, fieldName, 1, USER_NAME)), (String)ArgumentMatchers.eq((Object)this.index))).thenReturn((Object)SEARCH_RESULT);
        List search = this.spaceSearchConnector.search(filter, 0L, 10L);
        Assert.assertEquals((long)1L, (long)search.size());
        Assert.assertNotNull((Object)((SpaceSearchResult)search.get(0)).getNameExcerpts());
        Assert.assertNotNull((Object)((SpaceSearchResult)search.get(0)).getDescriptionExcerpts());
        Assert.assertEquals((long)1L, (long)((SpaceSearchResult)search.get(0)).getNameExcerpts().size());
        Assert.assertEquals((long)1L, (long)((SpaceSearchResult)search.get(0)).getDescriptionExcerpts().size());
    }

    private boolean hasUserFavoriteQueryPart(String esQuery) {
        JsonNode favorite = this.getFilterNode(esQuery, "metadatas.favorites.metadataName.keyword");
        return favorite != null && favorite.size() == 1 && String.valueOf(25L).equals(favorite.get(0).asText());
    }

    private boolean hasNotUserFavoriteQueryPart(String esQuery) {
        JsonNode favorite = this.getFilterNode(esQuery, "metadatas.favorites.metadataName.keyword");
        return favorite == null;
    }

    private boolean hasPermissionQueryPart(String esQuery, String permissionField, int size, String ... permissionValues) {
        JsonNode permission = this.getFilterNode(esQuery, permissionField);
        return permission != null && permission.size() == size && StreamSupport.stream(permission.spliterator(), false).allMatch(e -> Stream.of(permissionValues).anyMatch(v -> v.equals(e.asText())));
    }

    private boolean hasCategoryIdsQueryPart(String esQuery, List<Long> categoryIds) {
        JsonNode categoryId = this.getFilterNode(esQuery, "categoryId");
        return categoryId != null && categoryId.size() == 2 && StreamSupport.stream(categoryId.spliterator(), false).allMatch(e -> categoryIds.stream().anyMatch(v -> v.equals(e.asLong())));
    }

    private boolean hasTagsQueryPart(String esQuery, int size, String ... tagValues) {
        return Stream.of(tagValues).allMatch(v -> this.hasTagsNode(esQuery, (String)v));
    }

    private JsonNode getFilterNode(String esQuery, String filterName) {
        JsonNode jsonNode = JsonUtils.OBJECT_MAPPER.readTree(esQuery);
        JsonNode filter = jsonNode.get("query").get("bool").get("filter");
        if (filter == null || filter.size() == 0) {
            return null;
        }
        Iterator filterElements = filter.elements();
        JsonNode filterNode = null;
        while (filterElements.hasNext() && filterNode == null) {
            JsonNode filterElement = (JsonNode)filterElements.next();
            JsonNode terms = filterElement.get("terms");
            filterNode = terms == null ? null : terms.get(filterName);
        }
        return filterNode;
    }

    private boolean hasTagsNode(String esQuery, String tagValue) {
        JsonNode jsonNode = JsonUtils.OBJECT_MAPPER.readTree(esQuery);
        JsonNode filter = jsonNode.get("query").get("bool").get("should");
        if (filter == null || filter.size() == 0) {
            return false;
        }
        return StreamSupport.stream(filter.spliterator(), false).anyMatch(element -> {
            JsonNode term = element.get(TERM);
            JsonNode tagElement = term == null ? null : term.get("metadatas.tags.metadataName.keyword");
            return tagElement != null && tagValue.equals(tagElement.get("value").asText());
        });
    }
}

