/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.plugin;

import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.plugin.ActivityAttachmentPlugin;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivityAttachmentPluginTest {
    private ActivityAttachmentPlugin activityAttachmentplugin;
    @Mock
    private ActivityManager activityManager;

    @Before
    public void setUp() throws Exception {
        this.activityAttachmentplugin = new ActivityAttachmentPlugin(this.activityManager);
    }

    @Test
    public void testHasAccessPermission() throws ObjectNotFoundException {
        String activityId = "10";
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)this.activityManager.getActivity(activityId)).thenReturn((Object)activity);
        Mockito.when((Object)this.activityManager.isActivityEditable(activity, userIdentity)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.activityAttachmentplugin.hasEditPermission(userIdentity, activityId));
    }

    @Test
    public void testHasEditPermission() throws ObjectNotFoundException {
        String activityId = "10";
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)this.activityManager.getActivity(activityId)).thenReturn((Object)activity);
        Mockito.when((Object)this.activityManager.isActivityEditable(activity, userIdentity)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.activityAttachmentplugin.hasEditPermission(userIdentity, activityId));
    }
}

