/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.cms.plugin;

import io.meeds.social.cms.model.ContentLinkIdentifier;
import io.meeds.social.cms.model.ContentObject;
import io.meeds.social.cms.service.ContentLinkService;
import io.meeds.social.html.model.HtmlProcessorContext;
import io.meeds.social.html.plugin.HtmlProcessorPlugin;
import io.meeds.social.html.service.HtmlProcessorService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentLinkHtmlProcessorPlugin
implements HtmlProcessorPlugin {
    private static final String CONTENT_LINK_TAG = "<content-link contenteditable=\"false\" style=\"display: none;\">/%s</content-link>\n";
    private static final String CONTENT_LINK_START_TAG = "<content-link";
    private static final String CONTENT_LINK_END_TAG = "</content-link>";
    private static final String DATA_OBJECT_ATTRIBUTE = "data-object=";
    private static final String DATA_OBJECT_END_TAG = "</a>";
    private static final String DATA_OBJECT_START_TAG = "<a";
    @Autowired
    private ContentLinkService contentLinkService;
    @Autowired
    private PortalContainer portalContainer;

    @PostConstruct
    public void init() {
        ((HtmlProcessorService)this.portalContainer.getComponentInstanceOfType(HtmlProcessorService.class)).addPlugin((HtmlProcessorPlugin)this);
    }

    public String process(String html, HtmlProcessorContext context) {
        String formattedHtml = this.replaceDataObjectTag(html);
        List<ContentLinkIdentifier> links = this.getContentLinkFromTag(formattedHtml, context);
        this.contentLinkService.saveLinks(new ContentObject(context.getObjectType(), context.getObjectId(), context.getFieldName(), context.getLocale()), links);
        return html;
    }

    private List<ContentLinkIdentifier> getContentLinkFromTag(String html, HtmlProcessorContext context) {
        ArrayList<ContentLinkIdentifier> links = new ArrayList<ContentLinkIdentifier>();
        int fromIndex = 0;
        while (html.indexOf(CONTENT_LINK_START_TAG, fromIndex) > -1) {
            String contentLinkTag = this.getContentLinkTag(html, fromIndex);
            ContentLinkIdentifier contentLinkIdentifier = this.getContentLinkIdentifier(contentLinkTag, context);
            if (contentLinkIdentifier != null) {
                links.add(contentLinkIdentifier);
            }
            fromIndex += CONTENT_LINK_START_TAG.length();
        }
        return links;
    }

    private ContentLinkIdentifier getContentLinkIdentifier(String contentLinkTag, HtmlProcessorContext context) {
        String contentLinkObject;
        int startIndex = contentLinkTag.indexOf(">");
        int endIndex = contentLinkTag.indexOf("<", startIndex);
        if (endIndex < 0) {
            endIndex = contentLinkTag.indexOf("'", startIndex);
        }
        if ((contentLinkObject = contentLinkTag.substring(startIndex + 2, endIndex)).contains(":")) {
            String[] parts = contentLinkObject.trim().replace("/", "").trim().split(":");
            return new ContentLinkIdentifier(parts[0], parts[1], context.getFieldName(), context.getLocale());
        }
        return null;
    }

    private String getContentLinkTag(String html, int fromIndex) {
        int startIndex = html.indexOf(CONTENT_LINK_START_TAG, fromIndex);
        int endIndex = html.indexOf(CONTENT_LINK_END_TAG, startIndex);
        return html.substring(startIndex, endIndex + CONTENT_LINK_END_TAG.length());
    }

    private String replaceDataObjectTag(String html) {
        int fromIndex = 0;
        while (html.indexOf(DATA_OBJECT_ATTRIBUTE, fromIndex) > -1) {
            int newFromIndex;
            String dataObjectTag = this.getDataObjectTag(html, fromIndex);
            if (StringUtils.isNotBlank((CharSequence)dataObjectTag)) {
                newFromIndex = html.indexOf(dataObjectTag);
                String dataObjectAttribute = this.getDataObjectAttribute(dataObjectTag);
                if (dataObjectAttribute != null) {
                    html = html.replace(dataObjectTag, String.format(CONTENT_LINK_TAG, dataObjectAttribute));
                }
            } else {
                newFromIndex = html.indexOf(DATA_OBJECT_ATTRIBUTE, fromIndex) + 1;
            }
            fromIndex = newFromIndex;
        }
        return html;
    }

    private String getDataObjectTag(String html, int fromIndex) {
        int attributeIndex = html.indexOf(DATA_OBJECT_ATTRIBUTE, fromIndex);
        int startIndex = html.substring(fromIndex, attributeIndex).lastIndexOf(DATA_OBJECT_START_TAG);
        if (startIndex > -1 && !html.substring(startIndex + 1, attributeIndex).contains("<")) {
            int endIndex = html.indexOf(DATA_OBJECT_END_TAG, attributeIndex);
            return html.substring(fromIndex + startIndex, endIndex + DATA_OBJECT_END_TAG.length());
        }
        return null;
    }

    private String getDataObjectAttribute(String dataObjectTag) {
        String contentLinkObject;
        int startIndex = dataObjectTag.indexOf(DATA_OBJECT_ATTRIBUTE) + DATA_OBJECT_ATTRIBUTE.length() + 1;
        int endIndex = dataObjectTag.indexOf("\"", startIndex);
        if (endIndex < 0) {
            endIndex = dataObjectTag.indexOf("'", startIndex);
        }
        if (endIndex > -1 && (contentLinkObject = dataObjectTag.substring(startIndex, endIndex)).contains(":")) {
            return contentLinkObject;
        }
        return null;
    }
}

