/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.cms.service;

import io.meeds.social.cms.model.ContentLink;
import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkIdentifier;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.model.ContentObject;
import io.meeds.social.cms.model.ContentObjectIdentifier;
import io.meeds.social.cms.service.ContentLinkPluginService;
import io.meeds.social.cms.service.ContentLinkService;
import io.meeds.social.cms.storage.ContentLinkStorage;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.springframework.stereotype.Service;

@Service
public class ContentLinkServiceImpl
implements ContentLinkService {
    private ContentLinkPluginService contentLinkPluginService;
    private UserACL userAcl;
    private ContentLinkStorage contentLinkStorage;

    public List<ContentLinkExtension> getExtensions() {
        return this.contentLinkPluginService.getExtensions();
    }

    public List<ContentLink> getLinks(ContentObject contentObject, Locale locale, String username) throws IllegalAccessException {
        if (!this.canView((ContentObjectIdentifier)contentObject, username)) {
            throw new IllegalAccessException(String.format("User %s can't view object of type %s with id %s", username, contentObject.getObjectType(), contentObject.getObjectId()));
        }
        return this.getLinkIdentifiers(contentObject).stream().filter(linkIdentifier -> this.canView((ContentObjectIdentifier)linkIdentifier, username)).map(this::getLink).filter(Objects::nonNull).toList();
    }

    public List<ContentLinkSearchResult> searchLinks(String objectType, String keyword, String username, Locale locale, int offset, int limit) {
        if (StringUtils.isNumeric((CharSequence)(keyword = StringUtils.trim((String)keyword)))) {
            try {
                ContentLink link = this.getLink(new ContentLinkIdentifier(objectType, keyword, locale), username);
                return Collections.singletonList(new ContentLinkSearchResult(link));
            }
            catch (IllegalAccessException | ObjectNotFoundException e) {
                return Collections.emptyList();
            }
        }
        return this.contentLinkPluginService.searchLinks(objectType, keyword, this.userAcl.getUserIdentity(username), locale, offset, limit);
    }

    public void saveLinks(ContentObject contentObject, List<? extends ContentObjectIdentifier> links, String username) throws IllegalAccessException {
        if (!this.canEdit((ContentObjectIdentifier)contentObject, username)) {
            throw new IllegalAccessException(String.format("User %s can't edit object of type %s with id %s", username, contentObject.getObjectType(), contentObject.getObjectId()));
        }
        if (links.stream().anyMatch(l -> !this.canView((ContentObjectIdentifier)l, username))) {
            throw new IllegalAccessException(String.format("User %s can't access at least one of linked object: %s", username, links));
        }
        this.saveLinks(contentObject, links);
    }

    public void saveLinks(ContentObject contentObject, List<? extends ContentObjectIdentifier> links) {
        this.contentLinkStorage.saveLinks(contentObject, links);
    }

    public void deleteLinks(ContentObjectIdentifier contentObject) {
        this.contentLinkStorage.deleteLinks(contentObject);
    }

    public List<ContentLinkIdentifier> getLinkIdentifiers(ContentObject contentObject) {
        return this.contentLinkStorage.getLinkIdentifiers(contentObject);
    }

    public ContentLink getLink(ContentLinkIdentifier linkIdentifier, String username) throws IllegalAccessException, ObjectNotFoundException {
        ContentLink link = this.getLink(linkIdentifier);
        if (link == null) {
            throw new ObjectNotFoundException(String.format("Content %s:%s doesn't exist", linkIdentifier.getObjectType(), linkIdentifier.getObjectId()));
        }
        if (!this.canView((ContentObjectIdentifier)linkIdentifier, username)) {
            throw new IllegalAccessException(String.format("User %s can't view object of type %s with id %s", username, linkIdentifier.getObjectType(), linkIdentifier.getObjectId()));
        }
        return link;
    }

    public ContentLink getLink(ContentLinkIdentifier link) {
        return this.contentLinkPluginService.getLink(link);
    }

    public boolean canView(ContentObjectIdentifier link, String username) {
        return this.userAcl.hasAccessPermission(link.getObjectType(), link.getObjectId(), username);
    }

    public boolean canEdit(ContentObjectIdentifier contentObject, String username) {
        return this.userAcl.hasEditPermission(contentObject.getObjectType(), contentObject.getObjectId(), username);
    }

    @Generated
    public ContentLinkServiceImpl(ContentLinkPluginService contentLinkPluginService, UserACL userAcl, ContentLinkStorage contentLinkStorage) {
        this.contentLinkPluginService = contentLinkPluginService;
        this.userAcl = userAcl;
        this.contentLinkStorage = contentLinkStorage;
    }
}

