/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.provider;

import java.util.Arrays;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.provider.OrganizationIdentityProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class OrganizationIdentityProviderTest {
    @Mock(extraInterfaces={ComponentRequestLifecycle.class})
    private OrganizationService organizationService;
    @Mock
    private UserHandler userHandler;
    @Mock
    private UserProfileHandler userProfileHandler;

    @Test
    public void shouldUpdateProfileWhenResetingGender() throws Exception {
        Mockito.when((Object)this.userHandler.findUserByName((String)Mockito.eq((Object)"john"))).thenReturn((Object)new UserImpl("john"));
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        UserProfileImpl existingProfile = new UserProfileImpl("john");
        existingProfile.setAttribute("gender", "Male");
        existingProfile.setAttribute("position", "Product Manager");
        Mockito.when((Object)this.userProfileHandler.findUserProfileByName("john")).thenReturn((Object)existingProfile);
        Mockito.when((Object)this.organizationService.getUserProfileHandler()).thenReturn((Object)this.userProfileHandler);
        OrganizationIdentityProvider organizationIdentityProvider = new OrganizationIdentityProvider(this.organizationService);
        Profile updatedProfile = new Profile(new Identity("john"));
        updatedProfile.setProperty("username", (Object)"john");
        updatedProfile.setProperty("gender", (Object)"");
        updatedProfile.setProperty("position", (Object)"Product Manager");
        updatedProfile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
        organizationIdentityProvider.onUpdateProfile(updatedProfile);
        ArgumentCaptor userProfileCaptor = ArgumentCaptor.forClass(UserProfile.class);
        ((UserProfileHandler)Mockito.verify((Object)this.userProfileHandler, (VerificationMode)Mockito.times((int)1))).saveUserProfile((UserProfile)userProfileCaptor.capture(), Mockito.eq((boolean)false));
        UserProfile savedProfile = (UserProfile)userProfileCaptor.getValue();
        Assert.assertEquals((Object)"", (Object)savedProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[4]));
        Assert.assertEquals((Object)"Product Manager", (Object)savedProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[7]));
    }

    @Test
    public void shouldUpdateProfileWhenResetingPosition() throws Exception {
        Mockito.when((Object)this.userHandler.findUserByName((String)Mockito.eq((Object)"john"))).thenReturn((Object)new UserImpl("john"));
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        UserProfileImpl existingProfile = new UserProfileImpl("john");
        existingProfile.setAttribute("position", "Product Manager");
        Mockito.when((Object)this.userProfileHandler.findUserProfileByName((String)Mockito.eq((Object)"john"))).thenReturn((Object)existingProfile);
        Mockito.when((Object)this.organizationService.getUserProfileHandler()).thenReturn((Object)this.userProfileHandler);
        OrganizationIdentityProvider organizationIdentityProvider = new OrganizationIdentityProvider(this.organizationService);
        Profile updatedProfile = new Profile(new Identity("john"));
        updatedProfile.setProperty("username", (Object)"john");
        updatedProfile.setProperty("position", (Object)"");
        updatedProfile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
        organizationIdentityProvider.onUpdateProfile(updatedProfile);
        ArgumentCaptor userProfileCaptor = ArgumentCaptor.forClass(UserProfile.class);
        ((UserProfileHandler)Mockito.verify((Object)this.userProfileHandler, (VerificationMode)Mockito.times((int)1))).saveUserProfile((UserProfile)userProfileCaptor.capture(), Mockito.eq((boolean)false));
        UserProfile savedProfile = (UserProfile)userProfileCaptor.getValue();
        Assert.assertEquals((Object)"", (Object)savedProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[7]));
    }

    @Test
    public void testFindByRemoteId() throws Exception {
        String JOHN_USERNAME = "john";
        UserImpl JOHN = new UserImpl(JOHN_USERNAME);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        OrganizationIdentityProvider organizationIdentityProvider = new OrganizationIdentityProvider(this.organizationService);
        Mockito.lenient().when((Object)this.userHandler.findUserByName(JOHN_USERNAME, UserStatus.ANY)).thenReturn((Object)JOHN);
        Mockito.lenient().when((Object)this.userHandler.findUserByName(JOHN_USERNAME, UserStatus.ENABLED)).thenReturn((Object)JOHN);
        Mockito.lenient().when((Object)this.userHandler.findUserByName(JOHN_USERNAME, UserStatus.DISABLED)).thenReturn(null);
        Assert.assertNotNull((Object)organizationIdentityProvider.findByRemoteId(JOHN_USERNAME));
        Mockito.lenient().when((Object)this.userHandler.findUserByName(JOHN_USERNAME, UserStatus.ANY)).thenReturn((Object)JOHN);
        Mockito.lenient().when((Object)this.userHandler.findUserByName(JOHN_USERNAME, UserStatus.ENABLED)).thenReturn(null);
        Mockito.lenient().when((Object)this.userHandler.findUserByName(JOHN_USERNAME, UserStatus.DISABLED)).thenReturn((Object)JOHN);
        Assert.assertNotNull((Object)organizationIdentityProvider.findByRemoteId(JOHN_USERNAME));
        Mockito.lenient().when((Object)this.userHandler.findUserByName(JOHN_USERNAME, UserStatus.ANY)).thenReturn(null);
        Mockito.lenient().when((Object)this.userHandler.findUserByName(JOHN_USERNAME, UserStatus.ENABLED)).thenReturn(null);
        Mockito.lenient().when((Object)this.userHandler.findUserByName(JOHN_USERNAME, UserStatus.DISABLED)).thenReturn(null);
        Assert.assertNull((Object)organizationIdentityProvider.findByRemoteId(JOHN_USERNAME));
    }
}

