/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.social.core.jpa.storage.dao.jpa.ProfileLabelDAO;
import org.exoplatform.social.core.jpa.storage.entity.ProfileLabelEntity;
import org.exoplatform.social.core.jpa.test.BaseCoreTest;

public class ProfileLabelDAOTest
extends BaseCoreTest {
    private ProfileLabelDAO labelDAO;
    private final String objectId = "1";
    private final String objectType = "testObject";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.labelDAO = this.getService(ProfileLabelDAO.class);
    }

    @Override
    public void tearDown() throws Exception {
        this.labelDAO.deleteAll();
        super.tearDown();
    }

    public void testCreateLabel() {
        ProfileLabelEntity profileLabelEntity = this.createLabel("test label fr", "fr");
        this.labelDAO.create((Object)profileLabelEntity);
        this.restartTransaction();
        ProfileLabelEntity result = (ProfileLabelEntity)this.labelDAO.find((Serializable)profileLabelEntity.getId());
        ProfileLabelDAOTest.assertNotNull((Object)result);
        ProfileLabelDAOTest.assertEquals((Object)result.getId(), (Object)profileLabelEntity.getId());
    }

    public void testFindLabelByObjectTypeAndObjectIdAndLang() {
        ProfileLabelEntity profileLabelEntityFr = this.createLabel("test label fr", "fr");
        profileLabelEntityFr = (ProfileLabelEntity)this.labelDAO.create((Object)profileLabelEntityFr);
        ProfileLabelEntity profileLabelEntityEn = this.createLabel("test label en", "en");
        this.labelDAO.create((Object)profileLabelEntityEn);
        this.restartTransaction();
        ProfileLabelEntity result = this.labelDAO.findLabelByObjectTypeAndObjectIdAndLang("testObject", "1", "fr");
        ProfileLabelDAOTest.assertNotNull((Object)result);
        ProfileLabelDAOTest.assertEquals((Object)result.getId(), (Object)profileLabelEntityFr.getId());
        List results = this.labelDAO.findLabelByObjectTypeAndObjectId("testObject", "1");
        ProfileLabelDAOTest.assertNotNull((Object)results);
        ProfileLabelDAOTest.assertEquals((int)3, (int)results.size());
    }

    public void testFindLabelByObjectTypeAndObjectId() {
        ProfileLabelEntity profileLabelEntityFr = this.createLabel("test label fr", "fr");
        this.labelDAO.create((Object)profileLabelEntityFr);
        ProfileLabelEntity profileLabelEntityEn = this.createLabel("test label en", "en");
        this.labelDAO.create((Object)profileLabelEntityEn);
        ProfileLabelEntity profileLabelEntityDe = this.createLabel("test label de", "de");
        this.labelDAO.create((Object)profileLabelEntityDe);
        this.restartTransaction();
        List results = this.labelDAO.findLabelByObjectTypeAndObjectId("testObject", "1");
        ProfileLabelDAOTest.assertNotNull((Object)results);
        ProfileLabelDAOTest.assertEquals((int)2, (int)results.size());
    }

    private ProfileLabelEntity createLabel(String label, String lang) {
        ProfileLabelEntity profileLabelEntity = new ProfileLabelEntity();
        profileLabelEntity.setLanguage(lang);
        profileLabelEntity.setObjectType("testObject");
        profileLabelEntity.setObjectId("1");
        profileLabelEntity.setLabel(label);
        return profileLabelEntity;
    }
}

