/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.social.core.activity.filter.ActivitySearchFilter;
import org.exoplatform.social.core.activity.model.ActivitySearchResult;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ActivityStreamImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.search.ActivitySearchConnector;
import org.exoplatform.social.core.jpa.search.ActivitySearchProcessor;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.metadata.MetadataService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivitySearchConnectorTest {
    private static final String ES_INDEX = "activity_alias";
    public static final String FAKE_ES_QUERY = "{offset: @offset@, limit: @limit@, @term_query@ permissions: @permissions@}";
    @Mock
    ActivitySearchProcessor activitySearchProcessor;
    @Mock
    IdentityManager identityManager;
    @Mock
    MetadataService metadataService;
    @Mock
    ActivityStorage activityStorage;
    @Mock
    ConfigurationManager configurationManager;
    @Mock
    ElasticSearchingClient client;
    String searchResult = null;
    boolean developpingValue = false;

    @Before
    public void setUp() throws Exception {
        this.searchResult = IOUtil.getStreamContentAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("activities-search-result.json"));
        try {
            Mockito.reset((Object[])new ConfigurationManager[]{this.configurationManager});
            Mockito.when((Object)this.configurationManager.getInputStream("FILE_PATH")).thenReturn((Object)new ByteArrayInputStream(FAKE_ES_QUERY.getBytes()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving ES Query content", e);
        }
        this.developpingValue = PropertyManager.isDevelopping();
        PropertyManager.setProperty((String)"exo.product.developing", (String)"false");
        PropertyManager.refresh();
    }

    @After
    public void tearDown() {
        PropertyManager.setProperty((String)"exo.product.developing", (String)String.valueOf(this.developpingValue));
        PropertyManager.refresh();
    }

    @Test
    public void testSearchArguments() {
        ActivitySearchConnector activitySearchConnector = new ActivitySearchConnector(this.activitySearchProcessor, this.identityManager, this.activityStorage, this.configurationManager, this.client, this.getParams());
        ActivitySearchFilter filter = new ActivitySearchFilter("term");
        try {
            activitySearchConnector.search(null, filter, 0L, 10L);
            Assert.fail((String)"Should throw IllegalArgumentException: viewer identity is mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.lenient().when((Object)identity.getId()).thenReturn((Object)"1");
        try {
            activitySearchConnector.search(identity, null, 0L, 10L);
            Assert.fail((String)"Should throw IllegalArgumentException: filter is mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            activitySearchConnector.search(identity, filter, -1L, 10L);
            Assert.fail((String)"Should throw IllegalArgumentException: offset should be positive");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            activitySearchConnector.search(identity, filter, 0L, -1L);
            Assert.fail((String)"Should throw IllegalArgumentException: limit should be positive");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSearchNoResult() {
        ActivitySearchConnector activitySearchConnector = new ActivitySearchConnector(this.activitySearchProcessor, this.identityManager, this.activityStorage, this.configurationManager, this.client, this.getParams());
        ActivitySearchFilter filter = new ActivitySearchFilter("term");
        HashSet<Long> permissions = new HashSet<Long>(Arrays.asList(10L, 20L, 30L));
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.lenient().when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.lenient().when((Object)this.activityStorage.getStreamFeedOwnerIds((Identity)ArgumentMatchers.eq((Object)identity))).thenReturn(permissions);
        String expectedESQuery = FAKE_ES_QUERY.replaceAll("@term_query@", "\"must\":{  \"query_string\":{    \"fields\": [\"body\", \"posterName\"],    \"default_operator\": \"AND\",    \"query\": \"@term@~\",    \"fuzziness\": 1,    \"phrase_slop\": 1  }},".replace("@term@", filter.getTerm()).replace("@term_query@", filter.getTerm())).replaceAll("@permissions@", StringUtils.join(permissions, (String)",")).replaceAll("@offset@", "0").replaceAll("@limit@", "10");
        Mockito.when((Object)this.client.sendRequest(expectedESQuery, ES_INDEX)).thenReturn((Object)"{}");
        List result = activitySearchConnector.search(identity, filter, 0L, 10L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testSearchWithResult() {
        ActivitySearchConnector activitySearchConnector = new ActivitySearchConnector(this.activitySearchProcessor, this.identityManager, this.activityStorage, this.configurationManager, this.client, this.getParams());
        ActivitySearchFilter filter = new ActivitySearchFilter("term");
        HashSet<Long> permissions = new HashSet<Long>(Arrays.asList(10L, 20L, 30L));
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.activityStorage.getStreamFeedOwnerIds(identity)).thenReturn(permissions);
        String expectedESQuery = FAKE_ES_QUERY.replaceAll("@term_query@", "\"must\":{  \"query_string\":{    \"fields\": [\"body\", \"posterName\"],    \"default_operator\": \"AND\",    \"query\": \"@term@~\",    \"fuzziness\": 1,    \"phrase_slop\": 1  }},".replace("@term@", filter.getTerm()).replace("@term_query@", filter.getTerm())).replaceAll("@permissions@", StringUtils.join(permissions, (String)",")).replaceAll("@offset@", "0").replaceAll("@limit@", "10");
        Mockito.when((Object)this.client.sendRequest(expectedESQuery, ES_INDEX)).thenReturn((Object)this.searchResult);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setId("3");
        activity.setParentId("2");
        activity.setParentCommentId("5");
        activity.setType("type");
        activity.setPosterId("posterId");
        activity.setPostedTime(Long.valueOf(1234L));
        activity.setUpdated(Long.valueOf(4321L));
        ActivityStreamImpl activityStream = new ActivityStreamImpl();
        activity.setActivityStream((ActivityStream)activityStream);
        activityStream.setId("id");
        activityStream.setPrettyId("prettyId");
        activityStream.setType(ActivityStream.Type.USER);
        Identity streamOwner = new Identity("streamOwner");
        Identity poster = new Identity("posterId");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity(ActivityStream.Type.USER.getProviderId(), "prettyId")).thenReturn((Object)streamOwner);
        Mockito.when((Object)this.identityManager.getIdentity("posterId")).thenReturn((Object)poster);
        Mockito.when((Object)this.activityStorage.getActivity("3")).thenReturn((Object)activity);
        List result = activitySearchConnector.search(identity, filter, 0L, 10L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        ActivitySearchResult activitySearchResult = (ActivitySearchResult)result.iterator().next();
        Assert.assertEquals((long)3L, (long)activitySearchResult.getId());
        Assert.assertEquals((Object)"type", (Object)activitySearchResult.getType());
        Assert.assertEquals((Object)poster, (Object)activitySearchResult.getPoster());
        Assert.assertEquals((long)1234L, (long)activitySearchResult.getPostedTime());
        Assert.assertEquals((long)4321L, (long)activitySearchResult.getLastUpdatedTime());
        Assert.assertEquals((Object)streamOwner, (Object)activitySearchResult.getStreamOwner());
        Assert.assertNull((Object)activitySearchResult.getExcerpts());
        ActivitySearchResult commentSearchResult = activitySearchResult.getComment();
        Assert.assertNotNull((Object)commentSearchResult);
        Assert.assertEquals((long)6L, (long)commentSearchResult.getId());
        Assert.assertEquals((Object)"exosocial:spaces", (Object)commentSearchResult.getType());
        Assert.assertNull((Object)commentSearchResult.getPoster());
        Assert.assertEquals((long)1592227545758L, (long)commentSearchResult.getPostedTime());
        Assert.assertEquals((long)1592227545759L, (long)commentSearchResult.getLastUpdatedTime());
        Assert.assertNull((Object)commentSearchResult.getStreamOwner());
    }

    @Test
    public void testSearchWithIdentityResult() throws IOException {
        ActivitySearchConnector activitySearchConnector = new ActivitySearchConnector(this.activitySearchProcessor, this.identityManager, this.activityStorage, this.configurationManager, this.client, this.getParams());
        ActivitySearchFilter filter = new ActivitySearchFilter("John");
        HashSet<Long> permissions = new HashSet<Long>(Arrays.asList(10L, 20L, 30L));
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.lenient().when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.activityStorage.getStreamFeedOwnerIds(identity)).thenReturn(permissions);
        String expectedESQuery = FAKE_ES_QUERY.replaceAll("@term_query@", "\"must\":{  \"query_string\":{    \"fields\": [\"body\", \"posterName\"],    \"default_operator\": \"AND\",    \"query\": \"@term@~\",    \"fuzziness\": 1,    \"phrase_slop\": 1  }},".replace("@term@", filter.getTerm()).replace("@term_query@", filter.getTerm())).replaceAll("@permissions@", StringUtils.join(permissions, (String)",")).replaceAll("@offset@", "0").replaceAll("@limit@", "10");
        this.searchResult = IOUtil.getStreamContentAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("activities-search-result-by-identity.json"));
        Mockito.when((Object)this.client.sendRequest(expectedESQuery, ES_INDEX)).thenReturn((Object)this.searchResult);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setId("7");
        activity.setType("activity-type");
        activity.setPosterId("7");
        activity.setPostedTime(Long.valueOf(1234L));
        activity.setUpdated(Long.valueOf(4321L));
        Identity streamOwner = new Identity("streamOwner");
        streamOwner.setId("10");
        Identity poster = new Identity("posterId");
        Mockito.lenient().when((Object)this.identityManager.getOrCreateIdentity(ActivityStream.Type.USER.getProviderId(), "prettyId")).thenReturn((Object)streamOwner);
        Mockito.when((Object)this.identityManager.getIdentity("2")).thenReturn((Object)poster);
        Mockito.when((Object)this.identityManager.getIdentity("10")).thenReturn((Object)streamOwner);
        Mockito.lenient().when((Object)this.activityStorage.getActivity((String)ArgumentMatchers.eq((Object)"7"))).thenReturn((Object)activity);
        List result = activitySearchConnector.search(identity, filter, 0L, 10L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        ActivitySearchResult activitySearchResult = (ActivitySearchResult)result.iterator().next();
        Assert.assertEquals((long)7L, (long)activitySearchResult.getId());
        Assert.assertEquals((Object)"activity-type", (Object)activitySearchResult.getType());
        Assert.assertEquals((Object)poster, (Object)activitySearchResult.getPoster());
        Assert.assertEquals((long)1234L, (long)activitySearchResult.getPostedTime());
        Assert.assertEquals((long)4321L, (long)activitySearchResult.getLastUpdatedTime());
        Assert.assertNotNull((Object)activitySearchResult.getExcerpts());
        Assert.assertEquals((long)0L, (long)activitySearchResult.getExcerpts().size());
        Assert.assertEquals((Object)streamOwner, (Object)activitySearchResult.getStreamOwner());
    }

    @Test
    public void testSearchInSpaceResult() throws IOException {
        ActivitySearchConnector activitySearchConnector = new ActivitySearchConnector(this.activitySearchProcessor, this.identityManager, this.activityStorage, this.configurationManager, this.client, this.getParams());
        ActivitySearchFilter filter = new ActivitySearchFilter("John");
        Long allowedSpaceStreamOwnerId = 10L;
        Long notAllowedSpaceStreamOwnerId = 20L;
        ArrayList<Long> spaceIdentityIds = new ArrayList<Long>();
        spaceIdentityIds.add(allowedSpaceStreamOwnerId);
        filter.setSpaceIdentityIds(spaceIdentityIds);
        HashSet<Long> permissions = new HashSet<Long>(Arrays.asList(1L, 2L, 10L));
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.lenient().when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.activityStorage.getStreamFeedOwnerIds(identity)).thenReturn(permissions);
        this.searchResult = IOUtil.getStreamContentAsString((InputStream)Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("activities-search-result-by-identity.json")));
        Mockito.when((Object)this.client.sendRequest((String)Mockito.any(String.class), (String)ArgumentMatchers.eq((Object)ES_INDEX))).thenReturn((Object)this.searchResult);
        List result = activitySearchConnector.search(identity, filter, 0L, 10L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        spaceIdentityIds.clear();
        spaceIdentityIds.add(notAllowedSpaceStreamOwnerId);
        result = activitySearchConnector.search(identity, filter, 0L, 10L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    private InitParams getParams() {
        InitParams params = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setName("constructor.params");
        propertiesParam.setProperty("index", ES_INDEX);
        ValueParam valueParam = new ValueParam();
        valueParam.setName("query.file.path");
        valueParam.setValue("FILE_PATH");
        params.addParameter((Parameter)propertiesParam);
        params.addParameter((Parameter)valueParam);
        return params;
    }
}

