/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.social.core.profile.settings;

public class IMType {

  /** The name. */
  private final String name;

  /** The id. */
  private final String id;

  /**
   * Instantiates a new IM type.
   *
   * @param id the id
   * @param name the name
   */
  public IMType(String id, String name) {
    super();
    this.id = id;
    this.name = name;
  }

  /**
   * Gets the IM type ID. ID used for identification and referencing the type in content and i18n resources.
   *
   * @return the IM type ID
   */
  public String getId() {
    return id;
  }

  /**
   * Gets the IM type name. Name used for UI, log, admin screens.
   *
   * @return the IM type name
   */
  public String getName() {
    return name;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return new StringBuilder(getId()).append('[')
                                     .append(getName())
                                     .append(']')
                                     .append(super.toString())
                                     .toString();
  }

}
