/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.service;

import io.meeds.social.category.AbstractCategoryConfigurationTest;
import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryFilter;
import io.meeds.social.category.model.CategoryTree;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.Assert;
import org.junit.Test;

public class CategoryServiceTest
extends AbstractCategoryConfigurationTest {
    @Test
    public void testGetRootCategory() {
        Category rootCategory = this.categoryService.getRootCategory(this.getAdminGroupIdentityId());
        Assert.assertNotNull((Object)rootCategory);
        Assert.assertEquals((long)this.getAdminGroupIdentityId(), (long)rootCategory.getOwnerId());
        Assert.assertNotNull((Object)this.categoryService.getRootCategory(this.getAdminGroupIdentityId()));
        Assert.assertEquals((long)rootCategory.getId(), (long)this.categoryService.getRootCategory(this.getAdminGroupIdentityId()).getId());
        Category johnRootCategory = this.categoryService.getRootCategory(Long.parseLong(this.identityManager.getOrCreateUserIdentity("john").getId()));
        Assert.assertNull((Object)johnRootCategory);
    }

    @Test
    public void testGetCategoryTree() {
        this.buildCategoryTree();
        long ownerId = 0L;
        long parentId = 0L;
        long depth = 1L;
        long offset = 0L;
        long limit = 1L;
        CategoryFilter filter = new CategoryFilter(null, ownerId, parentId, depth, offset, limit, false, false);
        CategoryTree categoryTree = this.categoryService.getCategoryTree(filter, "mary", Locale.FRENCH);
        Assert.assertNotNull((Object)categoryTree);
        Assert.assertNotNull((Object)categoryTree.getCategories());
        Assert.assertEquals((long)this.getAdminGroupIdentityId(), (long)categoryTree.getOwnerId());
        Assert.assertEquals((long)1L, (long)categoryTree.getCategories().size());
        limit = 10L;
        filter = new CategoryFilter(null, ownerId, parentId, depth, offset, limit, false, false);
        categoryTree = this.categoryService.getCategoryTree(filter, "mary", Locale.FRENCH);
        Assert.assertNotNull((Object)categoryTree);
        Assert.assertNotNull((Object)categoryTree.getCategories());
        Assert.assertEquals((long)2L, (long)categoryTree.getCategories().size());
        CategoryTree categoryTree1 = (CategoryTree)categoryTree.getCategories().getFirst();
        Assert.assertNotNull((Object)categoryTree1);
        Assert.assertNotNull((Object)categoryTree1.getName());
        Assert.assertNull((Object)categoryTree1.getCategories());
        CategoryTree categoryTree2 = (CategoryTree)categoryTree.getCategories().get(1);
        Assert.assertNotNull((Object)categoryTree2);
        Assert.assertNotNull((Object)categoryTree2.getName());
        Assert.assertNull((Object)categoryTree2.getCategories());
        parentId = categoryTree1.getId();
        depth = 10L;
        filter = new CategoryFilter(null, ownerId, parentId, depth, offset, limit, false, false);
        categoryTree = this.categoryService.getCategoryTree(filter, "mary", Locale.FRENCH);
        Assert.assertEquals((long)categoryTree1.getId(), (long)categoryTree.getId());
        Assert.assertEquals((Object)categoryTree1.getName(), (Object)categoryTree.getName());
        Assert.assertNotNull((Object)categoryTree.getCategories());
        Assert.assertEquals((long)2L, (long)categoryTree.getCategories().size());
        Assert.assertNotNull((Object)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories());
        Assert.assertNotNull((Object)((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getCategories());
        Assert.assertNotNull((Object)((CategoryTree)((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst()).getCategories());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)((CategoryTree)((CategoryTree)((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst()).getCategories()));
    }

    @Test
    public void testGetAncestorIds() {
        this.buildCategoryTree();
        long ownerId = 0L;
        long parentId = 0L;
        long depth = 5L;
        long offset = 0L;
        long limit = 1L;
        CategoryFilter filter = new CategoryFilter(null, ownerId, parentId, depth, offset, limit, false, false);
        CategoryTree categoryTree = this.categoryService.getCategoryTree(filter, "root", Locale.FRENCH);
        Assert.assertNotNull((Object)categoryTree);
        Assert.assertNotNull((Object)categoryTree.getCategories());
        Assert.assertEquals((long)this.getAdminGroupIdentityId(), (long)categoryTree.getOwnerId());
        Assert.assertEquals((long)1L, (long)categoryTree.getCategories().size());
        CategoryTree categoryLeaf = (CategoryTree)((CategoryTree)((CategoryTree)((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst();
        Assert.assertNotNull((Object)categoryLeaf);
        List ancestorIds = this.categoryService.getAncestorIds(categoryLeaf.getId());
        Assert.assertEquals((long)5L, (long)ancestorIds.size());
        Assert.assertEquals((long)((CategoryTree)((CategoryTree)((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst()).getId(), (long)((Long)ancestorIds.get(0)));
        Assert.assertEquals((long)((CategoryTree)((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst()).getId(), (long)((Long)ancestorIds.get(1)));
        Assert.assertEquals((long)((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getId(), (long)((Long)ancestorIds.get(2)));
        Assert.assertEquals((long)((CategoryTree)categoryTree.getCategories().getFirst()).getId(), (long)((Long)ancestorIds.get(3)));
        Assert.assertEquals((long)categoryTree.getId(), (long)((Long)ancestorIds.get(4)));
    }

    @Test
    public void testCreateCategory() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.categoryService.createCategory(null, "john"));
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Category category = new Category();
            category.setId(5L);
            this.categoryService.createCategory(category, "john");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Category category = new Category();
            category.setOwnerId(-2L);
            this.categoryService.createCategory(category, "john");
        });
        Assert.assertThrows(ObjectNotFoundException.class, () -> {
            Category category = new Category();
            category.setOwnerId(1L);
            category.setParentId(1544863L);
            this.categoryService.createCategory(category, "john");
        });
        Assert.assertThrows(IllegalAccessException.class, () -> {
            Category category = new Category();
            category.setOwnerId(1L);
            this.categoryService.createCategory(category, "mary");
        });
        long adminGroupIdentityId = this.getAdminGroupIdentityId();
        Category rootCategory = this.categoryService.getRootCategory(adminGroupIdentityId);
        Assert.assertNotNull((Object)rootCategory);
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> {
            Category category = new Category();
            category.setOwnerId(adminGroupIdentityId);
            this.categoryService.createCategory(category, "mary");
        });
        Category category = new Category();
        category.setOwnerId(adminGroupIdentityId);
        category.setParentId(rootCategory.getId());
        Category createdCategory = this.categoryService.createCategory(category, "john");
        Assert.assertNotNull((Object)createdCategory);
        Assert.assertTrue((createdCategory.getId() > 0L ? 1 : 0) != 0);
        Assert.assertNotEquals((long)rootCategory.getId(), (long)createdCategory.getId());
    }

    @Test
    public void testUpdateCategory() {
        Category rootCategory = this.categoryService.getRootCategory(this.getAdminGroupIdentityId());
        Assert.assertNotNull((Object)rootCategory);
        Category category = new Category();
        category.setOwnerId(this.getAdminGroupIdentityId());
        category.setParentId(rootCategory.getId());
        category = this.categoryService.createCategory(category, "john");
        long categoryId = category.getId();
        Assert.assertThrows(IllegalArgumentException.class, () -> this.categoryService.createCategory(null, "john"));
        Category categoryToUpdate1 = category;
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            categoryToUpdate1.setId(0L);
            this.categoryService.updateCategory(categoryToUpdate1, "john");
        });
        Category categoryToUpdate2 = category = this.categoryService.getCategory(categoryId);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            categoryToUpdate2.setOwnerId(-2L);
            this.categoryService.updateCategory(categoryToUpdate2, "john");
        });
        Category categoryToUpdate3 = category = this.categoryService.getCategory(categoryId);
        Assert.assertThrows(ObjectNotFoundException.class, () -> {
            categoryToUpdate3.setParentId(1544863L);
            this.categoryService.updateCategory(categoryToUpdate3, "john");
        });
        Category categoryToUpdate4 = category = this.categoryService.getCategory(categoryId);
        Assert.assertThrows(ObjectNotFoundException.class, () -> {
            categoryToUpdate4.setId(22333L);
            this.categoryService.updateCategory(categoryToUpdate4, "john");
        });
        Category categoryToUpdate5 = category = this.categoryService.getCategory(categoryId);
        Assert.assertThrows(IllegalAccessException.class, () -> this.categoryService.updateCategory(categoryToUpdate5, "mary"));
        category = this.categoryService.getCategory(categoryId);
        String icon = "test-icon";
        category.setIcon(icon);
        category = this.categoryService.updateCategory(category, "john");
        Assert.assertEquals((Object)icon, (Object)category.getIcon());
        category = this.categoryService.getCategory(categoryId);
        Assert.assertEquals((Object)icon, (Object)category.getIcon());
    }

    @Test
    public void testCaneEdit() {
        Category rootCategory = this.categoryService.getRootCategory(this.getAdminGroupIdentityId());
        Assert.assertNotNull((Object)rootCategory);
        Category category = new Category();
        category.setOwnerId(this.getAdminGroupIdentityId());
        category.setParentId(rootCategory.getId());
        category = this.categoryService.createCategory(category, "john");
        long categoryId = category.getId();
        Assert.assertTrue((boolean)this.categoryService.canEdit(categoryId, "john"));
        Assert.assertFalse((boolean)this.categoryService.canEdit(categoryId, "mary"));
        Assert.assertFalse((boolean)this.categoryService.canEdit(123456879L, "john"));
    }

    @Test
    public void testGetCategory() {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.categoryService.getCategory(122546L, "mary", Locale.ENGLISH));
        this.buildCategoryTree();
        long ownerId = this.getAdminGroupIdentityId();
        long parentId = 0L;
        long depth = 10L;
        long offset = 0L;
        long limit = 10L;
        CategoryFilter filter = new CategoryFilter(null, ownerId, parentId, depth, offset, limit, false, false);
        CategoryTree categoryTree = this.categoryService.getCategoryTree(filter, "mary", Locale.FRENCH);
        Assert.assertEquals((long)2L, (long)((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getCategories().size());
        CategoryTree categoryTree13 = (CategoryTree)((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst();
        Assert.assertNotNull((Object)this.categoryService.getCategory(categoryTree13.getId(), "mary", Locale.ENGLISH));
        Assert.assertNotNull((Object)this.categoryService.getCategory(((CategoryTree)categoryTree13.getCategories().getFirst()).getId(), "mary", Locale.ENGLISH));
        this.categoryService.updateCategory((Category)categoryTree13, "john");
        categoryTree = this.categoryService.getCategoryTree(filter, "mary", Locale.FRENCH);
        Assert.assertNotNull(((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst());
        filter.setLimit(1L);
        categoryTree = this.categoryService.getCategoryTree(filter, "mary", Locale.FRENCH);
        Assert.assertFalse((boolean)((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getCategories().isEmpty());
        Assert.assertNotNull(((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst());
        Assert.assertNotEquals((long)categoryTree13.getId(), (long)((CategoryTree)((CategoryTree)((CategoryTree)categoryTree.getCategories().getFirst()).getCategories().getFirst()).getCategories().getFirst()).getId());
    }
}

