/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.databind.service;

import io.meeds.social.databind.plugin.DatabindPlugin;
import io.meeds.social.databind.service.DatabindServiceImpl;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DatabindServiceTest {
    @Mock
    private UploadService uploadService;
    @Mock
    private DatabindPlugin databindPlugin;
    @InjectMocks
    private DatabindServiceImpl databindService;
    private final String objectType = "testObject";
    private final String uploadId = "testUploadId";
    private final String username = "testUser";

    @Test
    public void testSerialize() throws Exception {
        Mockito.when((Object)this.databindPlugin.getObjectType()).thenReturn((Object)"testObject");
        Mockito.when((Object)this.databindPlugin.canHandleDatabind((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        this.databindService.addPlugin(this.databindPlugin);
        File file = this.databindService.serialize("testObject", Collections.singletonList("123"), "testUser");
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.getName().endsWith(".zip"));
    }

    @Test
    public void testDeserialize() {
        Mockito.when((Object)this.uploadService.getUploadResource("testUploadId")).thenReturn(null);
        Exception exception = (Exception)Assert.assertThrows(IllegalStateException.class, () -> this.databindService.deserialize("testObject", "testUploadId", new HashMap(), "testUser"));
        Assert.assertEquals((Object)"Can't find uploaded resource with id : testUploadId", (Object)exception.getMessage());
        UploadResource uploadResource = (UploadResource)Mockito.mock(UploadResource.class);
        Mockito.when((Object)this.uploadService.getUploadResource("testUploadId")).thenReturn((Object)uploadResource);
        Mockito.when((Object)uploadResource.getStoreLocation()).thenReturn((Object)"invalid/path");
        exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> this.databindService.deserialize("testObject", "testUploadId", new HashMap(), "testUser"));
        Assert.assertEquals((Object)"ZIP file missing in upload folder.", (Object)exception.getMessage());
    }
}

