/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.plugin.translation;

import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.plugin.translation.SpaceTemplateTranslationPlugin;
import io.meeds.social.space.template.service.SpaceTemplateService;
import io.meeds.social.translation.service.TranslationService;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceTemplateTranslationPluginTest {
    private static final String TEST_USER = "test";
    @Mock
    private SpaceTemplateService spaceTemplateService;
    @Mock
    private TranslationService translationService;
    @Mock
    private SpaceTemplate spaceTemplate;
    private SpaceTemplateTranslationPlugin translationPlugin;

    @Before
    public void init() {
        this.translationPlugin = new SpaceTemplateTranslationPlugin();
        this.translationPlugin.translationService = this.translationService;
        this.translationPlugin.spaceTemplateService = this.spaceTemplateService;
    }

    @Test
    public void testHasEditPermission() {
        Assert.assertFalse((boolean)this.translationPlugin.hasEditPermission("0", TEST_USER));
        Mockito.when((Object)this.spaceTemplateService.canManageTemplates(TEST_USER)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.translationPlugin.hasEditPermission("0", TEST_USER));
    }

    @Test
    public void testHasAccessPermission() {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.translationPlugin.hasAccessPermission("2", TEST_USER));
        Mockito.when((Object)this.spaceTemplateService.canManageTemplates(TEST_USER)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.translationPlugin.hasEditPermission("0", TEST_USER));
        Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(2L)).thenReturn((Object)this.spaceTemplate);
        Assert.assertFalse((boolean)this.translationPlugin.hasAccessPermission("2", TEST_USER));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.translationPlugin.hasAccessPermission("3", TEST_USER));
        Mockito.when((Object)this.spaceTemplateService.canViewTemplate(2L, TEST_USER)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.translationPlugin.hasAccessPermission("2", TEST_USER));
    }

    @Test
    public void getObjectType() {
        Assert.assertEquals((Object)"spaceTemplate", (Object)this.translationPlugin.getObjectType());
    }

    @Test
    public void getAudienceId() {
        Assert.assertEquals((long)0L, (long)this.translationPlugin.getAudienceId("0"));
    }

    @Test
    public void getSpaceId() {
        Assert.assertEquals((long)0L, (long)this.translationPlugin.getSpaceId("0"));
    }
}

