/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.activity.plugin;

import io.meeds.social.AbstractSpringConfigurationTest;
import io.meeds.social.cms.model.ContentObject;
import io.meeds.social.cms.service.ContentLinkService;
import io.meeds.social.html.model.HtmlTransformerContext;
import io.meeds.social.html.utils.HtmlUtils;
import java.util.List;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class ActivityContentLinkPluginTest
extends AbstractSpringConfigurationTest {
    private static final String EXPECTED_RESULT = "<a href=\"/portal/classic/activity?id=1\" data-object=\"activity:1\" contenteditable=\"false\" class=\"content-link\"><i aria-hidden=\"true\" class=\"fa fa-stream v-icon notranslate theme--light icon-default-color\" style=\"font-size: 16px; margin: 0 4px;\"></i>Test Content</a>";
    private static final String SUPER_USER = "root";
    private static final String TEST_CONTENT = "Test Content";
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private ContentLinkService contentLinkService;

    @Test
    public void testNotContentLink() {
        Identity identity = this.identityManager.getOrCreateUserIdentity(SUPER_USER);
        ExoSocialActivity activity = this.createActivity(TEST_CONTENT, identity);
        Assert.assertNotNull((Object)activity);
        Assert.assertNotNull((Object)activity.getId());
        List links = this.contentLinkService.getLinks(new ContentObject("activity", activity.getId()), null, identity.getRemoteId());
        Assert.assertNotNull((Object)links);
        Assert.assertTrue((boolean)links.isEmpty());
    }

    @Test
    public void testForbiddenContentLink() {
        Identity identity = this.identityManager.getOrCreateUserIdentity(SUPER_USER);
        ExoSocialActivity activity = this.createActivity(TEST_CONTENT, identity);
        Assert.assertNotNull((Object)activity);
        Assert.assertNotNull((Object)activity.getId());
        Assert.assertThrows(IllegalAccessException.class, () -> this.contentLinkService.getLinks(new ContentObject("activity", activity.getId()), null, "demo"));
    }

    @Test
    public void testContentLink() {
        Identity identity = this.identityManager.getOrCreateUserIdentity(SUPER_USER);
        ExoSocialActivity activityToLink = this.createActivity(TEST_CONTENT, identity);
        Assert.assertNotNull((Object)activityToLink);
        Assert.assertNotNull((Object)activityToLink.getId());
        ExoSocialActivity activity = this.createActivity(String.format("<content-link>/%s:%s</content-link>", "activity", activityToLink.getId()), identity);
        Assert.assertNotNull((Object)activity);
        Assert.assertNotNull((Object)activity.getId());
        List links = this.contentLinkService.getLinks(new ContentObject("activity", activity.getId()), null, identity.getRemoteId());
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)1L, (long)links.size());
        String transformedActivityContent = HtmlUtils.transform((String)activity.getTitle(), (HtmlTransformerContext)new HtmlTransformerContext(true, null));
        Assert.assertEquals((Object)EXPECTED_RESULT.trim(), (Object)transformedActivityContent.trim());
    }

    private ExoSocialActivity createActivity(String title, Identity identity) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(title);
        activity.setUserId(identity.getId());
        this.activityManager.saveActivityNoReturn(identity, (ExoSocialActivity)activity);
        return activity;
    }
}

