/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.cms.plugin;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.plugin.PermanentLinkPlugin;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.portal.plugin.AclPlugin;
import io.meeds.social.AbstractSpringConfigurationTest;
import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.model.ContentObject;
import io.meeds.social.cms.model.ContentObjectIdentifier;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import io.meeds.social.cms.service.ContentLinkService;
import io.meeds.social.html.model.HtmlProcessorContext;
import io.meeds.social.html.utils.HtmlUtils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class ContentLinkHtmlProcessorPluginTest
extends AbstractSpringConfigurationTest {
    private static final String PLUGIN_TITLE_KEY = "pluginTitleKey";
    private static final String PLUGIN_COMMAND = "pluginCommand";
    private static final String PLUGIN_ICON = "pluginIcon";
    private static final String CONTENT_LINK_TITLE = "contentTitle";
    private static final String TEST_USER = "testUser";
    private static final String NO_PLUGIN = "noPlugin";
    private static final String CONTENT_OBJECT_TYPE = "contentToLinkTo";
    private static final String CONTENT_OBJECT_ID = "556479";
    private static final ContentObject CONTENT_OBJECT = new ContentObject("contentToLinkTo", "556479");
    private static final ContentObject CONTENT_OBJECT_NO_PLUGIN = new ContentObject("noPlugin", "556479");
    private static final HtmlProcessorContext CONTENT_OBJECT_CONTEXT = new HtmlProcessorContext("contentToLinkTo", "556479", null, null);
    private static final String CONTENT_LINK_TYPE = "testContentLink";
    private static final String CONTENT_LINK_ID = "5874";
    private static final String CONTENT_NO_LINK = "Content";
    private static final String CONTENT_LINK = "Content1<content-link contenteditable=\"false\" style=\"display: none;\">/testContentLink:5874</content-link>";
    private static final String CONTENT_LINK_RESULT = "Content1<a href=\"linkToContent\" data-object=\"testContentLink:5874\" contenteditable=\"false\" class=\"content-link\"><i aria-hidden=\"true\" class=\"pluginIcon v-icon notranslate theme--light icon-default-color\" style=\"font-size: 16px; margin: 0 4px;\"></i>contentTitle</a>";
    private static final String CONTENT_LINK_NOT_FOUND = "Content1<content-link contenteditable=\"false\" style=\"display: none;\">/testContentLink:89665</content-link>";
    private static final String CONTENT_LINK_NO_PLUGIN = "Content1<content-link contenteditable=\"false\" style=\"display: none;\">/noPlugin:89665</content-link>";
    @Autowired
    private ContentLinkPluginService contentLinkPluginService;
    @Autowired
    private ContentLinkService contentLinkService;
    @Autowired
    private PermanentLinkService permanentLinkService;
    @Autowired
    private UserACL userAcl;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.addAclPlugin(CONTENT_OBJECT_TYPE);
        this.addAclPlugin(CONTENT_LINK_TYPE);
        this.addPermanentLinkPlugin(CONTENT_LINK_TYPE);
        this.addContentLinkPlugin();
        this.contentLinkService.deleteLinks((ContentObjectIdentifier)CONTENT_OBJECT);
    }

    @Test
    public void testNotContentLink() {
        Assert.assertEquals((Object)CONTENT_NO_LINK, (Object)HtmlUtils.process((String)CONTENT_NO_LINK, null));
    }

    @Test
    public void testNotContentLinkPlugin() {
        Assert.assertEquals((Object)CONTENT_LINK_NO_PLUGIN, (Object)HtmlUtils.process((String)CONTENT_LINK_NO_PLUGIN, null));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.contentLinkService.getLinks(CONTENT_OBJECT_NO_PLUGIN, Locale.ENGLISH, this.userAcl.getSuperUser()));
        this.addAclPlugin(NO_PLUGIN);
        Assert.assertThrows(IllegalAccessException.class, () -> this.contentLinkService.getLinks(CONTENT_OBJECT, Locale.ENGLISH, TEST_USER));
        List links = this.contentLinkService.getLinks(CONTENT_OBJECT, Locale.ENGLISH, this.userAcl.getSuperUser());
        Assert.assertNotNull((Object)links);
        Assert.assertTrue((boolean)links.isEmpty());
    }

    @Test
    public void testContentLinkPlugin() {
        List links = this.contentLinkService.getLinks(CONTENT_OBJECT, Locale.ENGLISH, this.userAcl.getSuperUser());
        Assert.assertNotNull((Object)links);
        Assert.assertTrue((boolean)links.isEmpty());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)CONTENT_LINK, (Object)HtmlUtils.process((String)CONTENT_LINK, (HtmlProcessorContext)CONTENT_OBJECT_CONTEXT));
            links = this.contentLinkService.getLinks(CONTENT_OBJECT, Locale.ENGLISH, this.userAcl.getSuperUser());
            Assert.assertNotNull((Object)links);
            Assert.assertEquals((long)1L, (long)links.size());
        }
        Assert.assertEquals((Object)CONTENT_LINK_NOT_FOUND, (Object)HtmlUtils.process((String)CONTENT_LINK_NOT_FOUND, (HtmlProcessorContext)CONTENT_OBJECT_CONTEXT));
        links = this.contentLinkService.getLinks(CONTENT_OBJECT, Locale.ENGLISH, this.userAcl.getSuperUser());
        Assert.assertNotNull((Object)links);
        Assert.assertTrue((boolean)links.isEmpty());
    }

    @Test
    public void testContentLinkPluginFromATag() {
        List links = this.contentLinkService.getLinks(CONTENT_OBJECT, Locale.ENGLISH, this.userAcl.getSuperUser());
        Assert.assertNotNull((Object)links);
        Assert.assertTrue((boolean)links.isEmpty());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)CONTENT_LINK_RESULT, (Object)HtmlUtils.process((String)CONTENT_LINK_RESULT, (HtmlProcessorContext)CONTENT_OBJECT_CONTEXT));
            links = this.contentLinkService.getLinks(CONTENT_OBJECT, Locale.ENGLISH, this.userAcl.getSuperUser());
            Assert.assertNotNull((Object)links);
            Assert.assertEquals((long)1L, (long)links.size());
        }
    }

    private void addAclPlugin(final String objectType) {
        this.userAcl.addAclPlugin(new AclPlugin(){

            public boolean hasPermission(String objectId, String permissionType, Identity identity) {
                return ContentLinkHtmlProcessorPluginTest.this.userAcl.getSuperUser().equals(identity.getUserId());
            }

            public String getObjectType() {
                return objectType;
            }
        });
    }

    private void addPermanentLinkPlugin(final String objectType) {
        this.permanentLinkService.addPlugin(new PermanentLinkPlugin(){

            public String getObjectType() {
                return objectType;
            }

            public String getDirectAccessUrl(PermanentLinkObject object) throws ObjectNotFoundException {
                return "linkToContent";
            }

            public boolean canAccess(PermanentLinkObject object, Identity identity) throws ObjectNotFoundException {
                return true;
            }
        });
    }

    private void addContentLinkPlugin() {
        this.contentLinkPluginService.addPlugin(new ContentLinkPlugin(this){

            public List<ContentLinkSearchResult> search(String keyword, Identity identity, Locale locale, int offset, int limit) {
                return Collections.singletonList(new ContentLinkSearchResult(ContentLinkHtmlProcessorPluginTest.CONTENT_LINK_TYPE, ContentLinkHtmlProcessorPluginTest.CONTENT_LINK_ID, ContentLinkHtmlProcessorPluginTest.CONTENT_LINK_TITLE, ContentLinkHtmlProcessorPluginTest.PLUGIN_ICON));
            }

            public ContentLinkExtension getExtension() {
                return new ContentLinkExtension(ContentLinkHtmlProcessorPluginTest.CONTENT_LINK_TYPE, ContentLinkHtmlProcessorPluginTest.PLUGIN_TITLE_KEY, ContentLinkHtmlProcessorPluginTest.PLUGIN_ICON, ContentLinkHtmlProcessorPluginTest.PLUGIN_COMMAND);
            }

            public String getContentTitle(String objectId, Locale locale) {
                if (ContentLinkHtmlProcessorPluginTest.CONTENT_LINK_ID.equals(objectId)) {
                    return ContentLinkHtmlProcessorPluginTest.CONTENT_LINK_TITLE;
                }
                return null;
            }
        });
    }
}

