/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao;

import jakarta.persistence.EntityExistsException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.jpa.test.BaseCoreTest;
import org.exoplatform.social.core.relationship.model.Relationship;

public class IdentityDAOTest
extends BaseCoreTest {
    private IdentityDAO identityDAO;
    private ConnectionDAO connectionDAO;
    private List<IdentityEntity> deleteIdentities = new ArrayList<IdentityEntity>();
    private List<ConnectionEntity> connectionIdentities = new ArrayList<ConnectionEntity>();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityDAO = this.getService(IdentityDAO.class);
        this.connectionDAO = this.getService(ConnectionDAO.class);
        IdentityDAOTest.assertNotNull((String)"IdentityDAO must not be null", (Object)this.identityDAO);
        this.deleteIdentities = new ArrayList<IdentityEntity>();
    }

    @Override
    public void tearDown() throws Exception {
        for (ConnectionEntity connectionEntity : this.connectionIdentities) {
            this.connectionDAO.delete((Object)connectionEntity);
        }
        for (IdentityEntity e : this.deleteIdentities) {
            this.identityDAO.delete((Object)e);
        }
        super.tearDown();
    }

    public void testGetAllIds() {
        List allIds = this.identityDAO.getAllIds(0, 0);
        IdentityDAOTest.assertNotNull((Object)allIds);
        int initialSize = allIds.size();
        IdentityEntity identityUser1 = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("organization", "user1"));
        IdentityEntity identityUser2 = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("organization", "user2"));
        IdentityEntity identitySpace1 = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("space", "space1"));
        allIds = this.identityDAO.getAllIds(0, 0);
        IdentityDAOTest.assertNotNull((Object)allIds);
        IdentityDAOTest.assertEquals((int)(3 + initialSize), (int)allIds.size());
        IdentityDAOTest.assertTrue((boolean)allIds.contains(identityUser1.getId()));
        IdentityDAOTest.assertTrue((boolean)allIds.contains(identityUser2.getId()));
        IdentityDAOTest.assertTrue((boolean)allIds.contains(identitySpace1.getId()));
        this.deleteIdentities.add(identityUser1);
        this.deleteIdentities.add(identityUser2);
        this.deleteIdentities.add(identitySpace1);
    }

    public void testFindAllIdentitiesWithConnections() {
        IdentityEntity identityUser0 = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("organization", "userWithConn0"));
        this.deleteIdentities.add(identityUser0);
        for (int i = 1; i < 21; ++i) {
            IdentityEntity identityUser = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("organization", "userWithConn" + i));
            this.deleteIdentities.add(identityUser);
            if (i % 2 != 0) continue;
            ConnectionEntity connectionEntity = new ConnectionEntity(identityUser0, identityUser);
            connectionEntity.setUpdatedDate(new Date());
            if (i % 3 == 0) {
                connectionEntity.setStatus(Relationship.Type.CONFIRMED);
            } else {
                connectionEntity.setStatus(Relationship.Type.PENDING);
            }
            this.connectionDAO.create((Object)connectionEntity);
            this.connectionIdentities.add(connectionEntity);
        }
        IdentityEntity space0 = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("space", "spaceAB"));
        this.deleteIdentities.add(space0);
        IdentityEntity space1 = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("space", "spaceABC"));
        this.deleteIdentities.add(space1);
        ListAccess identities = this.identityDAO.findAllIdentitiesWithConnections(identityUser0.getId(), null, null);
        try {
            IdentityDAOTest.assertTrue((String)"The identities count is incoherent", ((long)identities.getSize() >= 20L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            IdentityDAOTest.fail((String)"Can't get the identities count", (Throwable)e);
        }
        Map.Entry[] identitiesArray = null;
        try {
            identitiesArray = (Map.Entry[])identities.load(0, identities.getSize());
        }
        catch (Exception e) {
            IdentityDAOTest.fail((String)"An error occured while getting identities from result query", (Throwable)e);
        }
        IdentityDAOTest.assertNotNull((String)"Returned identities list is empty", (Object)identitiesArray);
        IdentityDAOTest.assertTrue((String)"The identities count is incoherent", ((long)identitiesArray.length >= 20L ? 1 : 0) != 0);
        int count = 0;
        for (Map.Entry tuple : identitiesArray) {
            IdentityDAOTest.assertNotNull((String)"First element returnd in tuple is null", tuple.getKey());
            IdentityEntity identityEntity = (IdentityEntity)tuple.getKey();
            ConnectionEntity connectionEntity = (ConnectionEntity)tuple.getValue();
            String userId = identityEntity.getRemoteId();
            IdentityDAOTest.assertEquals((String)"", (String)identityEntity.getProviderId(), (String)"organization");
            if (!userId.startsWith("userWithConn") || userId.equals("userWithConn0")) continue;
            ++count;
            int index = Integer.parseInt(userId.replace("userWithConn", ""));
            if (index % 2 == 0) {
                IdentityDAOTest.assertNotNull((String)("The connection with user " + userId + " should exist"), (Object)connectionEntity);
                if (index % 3 == 0) {
                    IdentityDAOTest.assertEquals((String)("The connection status is incoherent with user " + userId), (Object)Relationship.Type.CONFIRMED, (Object)connectionEntity.getStatus());
                    continue;
                }
                IdentityDAOTest.assertEquals((String)("The connection status is incoherent with user " + userId), (Object)Relationship.Type.PENDING, (Object)connectionEntity.getStatus());
                continue;
            }
            IdentityDAOTest.assertNull((String)("The connection with user " + userId + " shouldn't exist"), (Object)connectionEntity);
        }
        IdentityDAOTest.assertEquals((String)"The returned number of users with prefix 'userWithConn' is incoherent", (int)20, (int)count);
    }

    public void testFindAllIdentitiesSorted() {
        String userPrefix = "userSorted";
        for (int i = 20; i > 0; --i) {
            String remoteId = userPrefix + i;
            IdentityEntity identityUser = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("organization", remoteId));
            this.deleteIdentities.add(identityUser);
            identityUser.getProperties().put("fullName", remoteId);
            this.identityDAO.update((Object)identityUser);
        }
        List identitiesList = this.identityDAO.getAllIdsByProviderSorted("organization", null, null, true, null, null, null, 0L, Integer.MAX_VALUE);
        IdentityDAOTest.assertTrue((identitiesList.size() >= 20 ? 1 : 0) != 0);
        Iterator iterator = identitiesList.iterator();
        while (iterator.hasNext()) {
            String username = (String)iterator.next();
            if (username.startsWith(userPrefix)) continue;
            iterator.remove();
        }
        ArrayList identitiesListBackup = new ArrayList(identitiesList);
        Collections.sort(identitiesList);
        IdentityDAOTest.assertEquals((String)("List '" + String.valueOf(identitiesList) + "' is not sorted"), (Object)identitiesList, identitiesListBackup);
    }

    public void testFindAllIdentitiesWithConnectionsSorted() throws Exception {
        String userPrefix = "userSorted";
        for (int i = 20; i > 0; --i) {
            String remoteId = userPrefix + i;
            IdentityEntity identityUser = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("organization", remoteId));
            this.deleteIdentities.add(identityUser);
            identityUser.getProperties().put("fullName", remoteId);
            this.identityDAO.update((Object)identityUser);
        }
        IdentityEntity identityUser0 = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("organization", "userWithConn0"));
        this.deleteIdentities.add(identityUser0);
        ListAccess identitiesListAccess = this.identityDAO.findAllIdentitiesWithConnections(identityUser0.getId(), null, null);
        Map.Entry[] identitiesEntries = (Map.Entry[])identitiesListAccess.load(0, Integer.MAX_VALUE);
        List identitiesList = Arrays.stream(identitiesEntries).map(entry -> ((IdentityEntity)entry.getKey()).getRemoteId()).collect(Collectors.toList());
        IdentityDAOTest.assertTrue((identitiesList.size() >= 20 ? 1 : 0) != 0);
        Iterator iterator = identitiesList.iterator();
        while (iterator.hasNext()) {
            String username = (String)iterator.next();
            if (username.startsWith(userPrefix)) continue;
            iterator.remove();
        }
        ArrayList identitiesListBackup = new ArrayList(identitiesList);
        Collections.sort(identitiesList);
        IdentityDAOTest.assertEquals((String)("List '" + String.valueOf(identitiesList) + "' is not sorted"), identitiesList, identitiesListBackup);
    }

    public void testGetAllIdsByProvider() {
        List allOrganizationIds = this.identityDAO.getAllIdsByProvider("organization", 0, 0);
        IdentityDAOTest.assertNotNull((Object)allOrganizationIds);
        List allSpaceIds = this.identityDAO.getAllIdsByProvider("space", 0, 0);
        IdentityDAOTest.assertNotNull((Object)allSpaceIds);
        int initialUserSize = allOrganizationIds.size();
        int initialSpaceSize = allSpaceIds.size();
        IdentityEntity identityUser1 = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("organization", "user1"));
        IdentityEntity identityUser2 = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("organization", "user2"));
        IdentityEntity identitySpace1 = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("space", "space1"));
        allOrganizationIds = this.identityDAO.getAllIdsByProvider("organization", 0, 0);
        allSpaceIds = this.identityDAO.getAllIdsByProvider("space", 0, 0);
        IdentityDAOTest.assertNotNull((Object)allOrganizationIds);
        IdentityDAOTest.assertEquals((int)(2 + initialUserSize), (int)allOrganizationIds.size());
        IdentityDAOTest.assertTrue((boolean)allOrganizationIds.contains(identityUser1.getId()));
        IdentityDAOTest.assertTrue((boolean)allOrganizationIds.contains(identityUser2.getId()));
        IdentityDAOTest.assertNotNull((Object)allSpaceIds);
        IdentityDAOTest.assertEquals((int)(1 + initialSpaceSize), (int)allSpaceIds.size());
        IdentityDAOTest.assertTrue((boolean)allSpaceIds.contains(identitySpace1.getId()));
        this.deleteIdentities.add(identityUser1);
        this.deleteIdentities.add(identityUser2);
        this.deleteIdentities.add(identitySpace1);
    }

    public void testSaveNewIdentity() {
        IdentityEntity entity = this.createIdentity();
        this.identityDAO.create((Object)entity);
        IdentityEntity e = (IdentityEntity)this.identityDAO.find((Serializable)Long.valueOf(entity.getId()));
        IdentityDAOTest.assertNotNull((Object)e);
        IdentityDAOTest.assertEquals((String)"usera", (String)e.getRemoteId());
        IdentityDAOTest.assertEquals((String)"organization", (String)e.getProviderId());
        this.deleteIdentities.add(e);
    }

    public void testDeleteIdentity() {
        IdentityEntity identity = this.createIdentity();
        long id = (identity = (IdentityEntity)this.identityDAO.create((Object)identity)).getId();
        IdentityDAOTest.assertTrue((id > 0L ? 1 : 0) != 0);
        identity = (IdentityEntity)this.identityDAO.find((Serializable)Long.valueOf(id));
        IdentityDAOTest.assertNotNull((Object)identity);
        IdentityDAOTest.assertEquals((String)"organization", (String)identity.getProviderId());
        IdentityDAOTest.assertEquals((String)"usera", (String)identity.getRemoteId());
        this.identityDAO.delete((Object)identity);
        IdentityDAOTest.assertNull((Object)this.identityDAO.find((Serializable)Long.valueOf(id)));
    }

    public void testUpdateIdentity() {
        IdentityEntity identity = this.createIdentity();
        this.identityDAO.create((Object)identity);
        identity = (IdentityEntity)this.identityDAO.find((Serializable)Long.valueOf(identity.getId()));
        IdentityDAOTest.assertFalse((boolean)identity.isDeleted());
        IdentityDAOTest.assertTrue((boolean)identity.isEnabled());
        identity.setEnabled(false);
        this.identityDAO.update((Object)identity);
        identity = (IdentityEntity)this.identityDAO.find((Serializable)Long.valueOf(identity.getId()));
        IdentityDAOTest.assertFalse((boolean)identity.isDeleted());
        IdentityDAOTest.assertFalse((boolean)identity.isEnabled());
        this.deleteIdentities.add(identity);
    }

    public void testCreateDuplicateIdentity() {
        IdentityEntity identity1 = this.createIdentity();
        IdentityEntity identity2 = this.createIdentity();
        this.deleteIdentities.add((IdentityEntity)this.identityDAO.create((Object)identity1));
        try {
            this.identityDAO.create((Object)identity2);
            IdentityDAOTest.fail((String)"EntityExistsException should be thrown");
        }
        catch (EntityExistsException entityExistsException) {
            // empty catch block
        }
    }

    private IdentityEntity createIdentity() {
        return this.createIdentity("organization", "usera");
    }

    private IdentityEntity createIdentity(String providerId, String remoteId) {
        IdentityEntity entity = new IdentityEntity();
        entity.setProviderId(providerId);
        entity.setRemoteId(remoteId);
        entity.setEnabled(true);
        entity.setDeleted(false);
        return entity;
    }
}

