/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.translation.service;

import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.service.TranslationServiceImpl;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.Assert;

public class TranslationServiceTest
extends AbstractCoreTest {
    private static final String OBJECT_TYPE = "activity";
    private TranslationServiceImpl translationService;
    private String objectType = "activity";
    private String objectId = "322";
    private String fieldName = "title";
    private String username = "test";
    private Locale locale = Locale.ENGLISH;
    private String label = "Test Label";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.translationService = (TranslationServiceImpl)ExoContainerContext.getService(TranslationServiceImpl.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.translationService.deleteTranslationLabels(this.objectType, this.objectId);
        this.removeTranslationPlugin();
        super.tearDown();
    }

    public void testSaveTranslationLabels() throws IllegalAccessException, ObjectNotFoundException {
        HashMap<Locale, String> labels = new HashMap<Locale, String>();
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels(null, this.objectId, this.fieldName, labels, false));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels(this.objectType, 0L, this.fieldName, labels));
        Assert.assertThrows(IllegalStateException.class, () -> this.translationService.saveTranslationLabels(this.objectType, this.objectId, this.fieldName, labels, this.username, false));
        this.setTranslationPlugin(true, false, 2L, 1L);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels(this.objectType, this.objectId, null, labels, false));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels(this.objectType, this.objectId, this.fieldName, null, false));
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.saveTranslationLabels(this.objectType, this.objectId, this.fieldName, labels, null, false));
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.saveTranslationLabels(this.objectType, this.objectId, this.fieldName, labels, this.username, false));
        this.setTranslationPlugin(true, true, 2L, 1L);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels(this.objectType, this.objectId, this.fieldName, labels, this.username, false));
        labels.put(this.locale, this.label);
        this.translationService.saveTranslationLabels(this.objectType, this.objectId, this.fieldName, labels, this.username, false);
    }

    public void testSaveTranslationLabel() throws ObjectNotFoundException {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabel(null, this.objectId, this.fieldName, this.locale, this.label));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabel(this.objectType, 0L, this.fieldName, this.locale, this.label));
        Assert.assertThrows(IllegalStateException.class, () -> this.translationService.saveTranslationLabel(this.objectType, this.objectId, this.fieldName, this.locale, this.label));
        this.setTranslationPlugin(false, false, 2L, 1L);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabel(this.objectType, this.objectId, null, this.locale, this.label));
        this.translationService.saveTranslationLabel(this.objectType, this.objectId, this.fieldName, this.locale, this.label);
    }

    public void testDeleteTranslationLabels() throws IllegalAccessException, ObjectNotFoundException {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.deleteTranslationLabels(null, this.objectId, this.username));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.deleteTranslationLabels(this.objectType, 0L, this.username));
        Assert.assertThrows(IllegalStateException.class, () -> this.translationService.deleteTranslationLabels(this.objectType, this.objectId, this.username));
        this.setTranslationPlugin(true, false, 2L, 1L);
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.deleteTranslationLabels(this.objectType, this.objectId, null));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.deleteTranslationLabels(null, this.objectId));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.deleteTranslationLabels(this.objectType, 0L));
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.deleteTranslationLabels(this.objectType, this.objectId, this.username));
        this.setTranslationPlugin(true, true, 2L, 1L);
        this.translationService.deleteTranslationLabels(this.objectType, this.objectId, this.username);
    }

    public void testDeleteTranslationLabel() throws ObjectNotFoundException {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.deleteTranslationLabel(null, this.objectId, this.fieldName, this.locale));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.deleteTranslationLabel(this.objectType, 0L, this.fieldName, this.locale));
        Assert.assertThrows(IllegalStateException.class, () -> this.translationService.deleteTranslationLabel(this.objectType, this.objectId, this.fieldName, null));
        this.setTranslationPlugin(false, false, 2L, 1L);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.deleteTranslationLabel(this.objectType, this.objectId, null, this.locale));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.deleteTranslationLabel(this.objectType, this.objectId, this.fieldName, null));
        this.translationService.deleteTranslationLabel(this.objectType, this.objectId, this.fieldName, this.locale);
    }

    public void testGetTranslationLabels() throws IllegalAccessException, ObjectNotFoundException {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.getTranslationField(null, this.objectId, this.fieldName, this.username));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.getTranslationField(this.objectType, 0L, this.fieldName, this.username));
        Assert.assertThrows(IllegalStateException.class, () -> this.translationService.getTranslationField(this.objectType, this.objectId, this.fieldName, this.username));
        this.setTranslationPlugin(false, false, 2L, 1L);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.getTranslationField(this.objectType, this.objectId, null, this.username));
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.getTranslationField(this.objectType, this.objectId, this.fieldName, null));
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.getTranslationField(this.objectType, this.objectId, this.fieldName, this.username));
        this.setTranslationPlugin(true, false, 2L, 1L);
        TranslationField translationField = this.translationService.getTranslationField(this.objectType, this.objectId, this.fieldName, this.username);
        TranslationServiceTest.assertNotNull((Object)translationField);
        Map translationLabels = translationField.getLabels();
        TranslationServiceTest.assertNotNull((Object)translationLabels);
        TranslationServiceTest.assertTrue((boolean)translationLabels.isEmpty());
        this.setTranslationPlugin(true, true, 2L, 1L);
        HashMap<Locale, Object> labels = new HashMap<Locale, Object>();
        labels.put(this.locale, this.label);
        this.translationService.saveTranslationLabels(this.objectType, this.objectId, this.fieldName, labels, false);
        translationField = this.translationService.getTranslationField(this.objectType, this.objectId, this.fieldName, this.username);
        TranslationServiceTest.assertNotNull((Object)translationField);
        translationLabels = translationField.getLabels();
        TranslationServiceTest.assertNotNull((Object)translationLabels);
        TranslationServiceTest.assertFalse((boolean)translationLabels.isEmpty());
        TranslationServiceTest.assertEquals((String)this.label, (String)((String)translationLabels.get(this.locale)));
        String labelFr = this.label + "FR";
        labels.put(Locale.FRENCH, labelFr);
        this.translationService.saveTranslationLabels(this.objectType, this.objectId, this.fieldName, labels, false);
        translationField = this.translationService.getTranslationField(this.objectType, this.objectId, this.fieldName, this.username);
        TranslationServiceTest.assertNotNull((Object)translationField);
        translationLabels = translationField.getLabels();
        TranslationServiceTest.assertNotNull((Object)translationLabels);
        TranslationServiceTest.assertFalse((boolean)translationLabels.isEmpty());
        TranslationServiceTest.assertEquals((String)this.label, (String)((String)translationLabels.get(this.locale)));
        TranslationServiceTest.assertEquals((String)labelFr, (String)((String)translationLabels.get(Locale.FRENCH)));
    }

    public void testGetTranslationLabel() throws IllegalAccessException, ObjectNotFoundException {
        this.setTranslationPlugin(true, true, 2L, 1L);
        TranslationField translationField = this.translationService.getTranslationField(this.objectType, this.objectId, this.fieldName, this.username);
        TranslationServiceTest.assertNotNull((Object)translationField);
        Map translationLabels = translationField.getLabels();
        TranslationServiceTest.assertNotNull((Object)translationLabels);
        TranslationServiceTest.assertTrue((boolean)translationLabels.isEmpty());
        HashMap<Locale, Object> labels = new HashMap<Locale, Object>();
        labels.put(this.locale, this.label);
        this.translationService.saveTranslationLabels(this.objectType, this.objectId, this.fieldName, labels, false);
        String value = this.translationService.getTranslationLabel(this.objectType, this.objectId, this.fieldName, this.locale);
        TranslationServiceTest.assertEquals((String)this.label, (String)value);
        String labelFr = this.label + "FR";
        labels.put(Locale.FRENCH, labelFr);
        this.translationService.saveTranslationLabels(this.objectType, this.objectId, this.fieldName, labels, false);
        value = this.translationService.getTranslationLabel(this.objectType, this.objectId, this.fieldName, Locale.FRENCH);
        TranslationServiceTest.assertEquals((String)labelFr, (String)value);
    }

    private void removeTranslationPlugin() {
        this.translationService.removePlugin(OBJECT_TYPE);
    }

    private void setTranslationPlugin(final boolean hasAccessPermission, final boolean hasEditPermission, final long spaceId, final long audienceId) {
        this.removeTranslationPlugin();
        TranslationPlugin translationPlugin = new TranslationPlugin(this){

            public String getObjectType() {
                return TranslationServiceTest.OBJECT_TYPE;
            }

            public boolean hasEditPermission(String objectId, String username) throws ObjectNotFoundException {
                return hasEditPermission;
            }

            public boolean hasAccessPermission(String objectId, String username) throws ObjectNotFoundException {
                return hasAccessPermission;
            }

            public long getSpaceId(String objectId) throws ObjectNotFoundException {
                return spaceId;
            }

            public long getAudienceId(String objectId) throws ObjectNotFoundException {
                return audienceId;
            }
        };
        this.translationService.addPlugin(translationPlugin);
    }

    public void testGetAllTranslationFields() throws IllegalAccessException, ObjectNotFoundException {
        String field1 = "title1";
        String field2 = "title2";
        this.setTranslationPlugin(true, true, 2L, 1L);
        HashMap<Locale, Object> labels = new HashMap<Locale, Object>();
        labels.put(this.locale, this.label);
        labels.put(Locale.GERMAN, this.label + "-de");
        this.translationService.saveTranslationLabels(this.objectType, this.objectId, field1, labels, false);
        this.translationService.saveTranslationLabels(this.objectType, this.objectId, field2, labels, false);
        Map translationfields = this.translationService.getAllTranslationFields(this.objectType, this.objectId, this.username);
        TranslationServiceTest.assertNotNull((Object)translationfields);
        TranslationServiceTest.assertEquals((int)2, (int)translationfields.size());
        TranslationServiceTest.assertTrue((boolean)translationfields.containsKey(field1));
        TranslationServiceTest.assertTrue((boolean)translationfields.containsKey(field2));
        for (TranslationField translationField : translationfields.values()) {
            Map translationLabels = translationField.getLabels();
            TranslationServiceTest.assertNotNull((Object)translationLabels);
            TranslationServiceTest.assertFalse((boolean)translationLabels.isEmpty());
            TranslationServiceTest.assertEquals((int)2, (int)translationfields.size());
            TranslationServiceTest.assertTrue((boolean)translationField.getLabels().containsKey(this.locale));
            TranslationServiceTest.assertEquals((String)this.label, (String)((String)translationField.getLabels().get(this.locale)));
        }
        String labelFr = this.label + "FR";
        labels.put(Locale.FRENCH, labelFr);
        this.translationService.saveTranslationLabels(this.objectType, this.objectId, field1, labels, false);
        this.translationService.saveTranslationLabels(this.objectType, this.objectId, field2, labels, false);
        translationfields = this.translationService.getAllTranslationFields(this.objectType, this.objectId, this.username);
        TranslationServiceTest.assertNotNull((Object)translationfields);
        TranslationServiceTest.assertEquals((int)2, (int)translationfields.size());
        TranslationServiceTest.assertTrue((boolean)translationfields.containsKey(field1));
        TranslationServiceTest.assertTrue((boolean)translationfields.containsKey(field2));
        for (TranslationField translationField : translationfields.values()) {
            TranslationServiceTest.assertNotNull((Object)translationField);
            Map translationLabels = translationField.getLabels();
            TranslationServiceTest.assertNotNull((Object)translationLabels);
            TranslationServiceTest.assertFalse((boolean)translationLabels.isEmpty());
            TranslationServiceTest.assertEquals((String)this.label, (String)((String)translationLabels.get(this.locale)));
            TranslationServiceTest.assertEquals((String)labelFr, (String)((String)translationLabels.get(Locale.FRENCH)));
        }
    }
}

