/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.service;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class LinkProviderTest
extends AbstractCoreTest {
    public void testGetProfileLink() {
        String portalOwner = "classic";
        Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        LinkProviderTest.assertNotNull((Object)rootIdentity);
        LinkProviderTest.assertNotNull((Object)rootIdentity.getProfile());
        String rootFullName = rootIdentity.getProfile().getFullName();
        LinkProviderTest.assertNotNull((String)"rootFullName must not be null.", (Object)rootFullName);
        String actualLink = LinkProvider.getProfileLink((String)rootIdentity.getRemoteId(), (String)"classic");
        Object external = rootIdentity.getProfile().getProperty("external");
        String expected = "<a class=\"user-suggester\" href=\"http://localhost:8080/portal/classic/profile/" + rootIdentity.getRemoteId() + "\" target=\"_parent\" v-identity-popover=\"{id: '" + rootIdentity.getId() + "',username: '" + rootIdentity.getRemoteId() + "',fullName: '" + rootIdentity.getProfile().getFullName() + "',avatar: '" + rootIdentity.getProfile().getAvatarUrl() + "',position: '" + StringUtils.trimToEmpty((String)rootIdentity.getProfile().getPosition()) + "',external: '" + String.valueOf(external == null ? "false" : external) + "',enabled: '" + (rootIdentity.isEnable() && !rootIdentity.isDeleted()) + "',}\">" + rootFullName + "</a>";
        LinkProviderTest.assertEquals((String)expected, (String)actualLink);
    }
}

