/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.plugin;

import io.meeds.social.category.model.Category;
import io.meeds.social.category.service.CategoryService;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CategoryTranslationPlugin
extends TranslationPlugin {
    public static final String OBJECT_TYPE = "category";
    public static final String NAME_FIELD = "name";
    @Autowired
    private TranslationService translationService;
    @Autowired
    private CategoryService categoryService;

    @PostConstruct
    public void init() {
        this.translationService.addPlugin((TranslationPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasAccessPermission(String categoryId, String username) throws ObjectNotFoundException {
        return true;
    }

    public boolean hasEditPermission(String categoryId, String username) throws ObjectNotFoundException {
        return this.categoryService.canEdit(Long.parseLong(categoryId), username);
    }

    public long getAudienceId(String categoryId) throws ObjectNotFoundException {
        Category category = this.categoryService.getCategory(Long.parseLong(categoryId));
        return category == null ? 0L : category.getOwnerId();
    }

    public long getSpaceId(String categoryId) throws ObjectNotFoundException {
        return 0L;
    }
}

