/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.authorization;

import io.meeds.social.authorization.AuthorizationManager;
import io.meeds.social.space.template.model.SpaceTemplate;
import java.util.Arrays;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthorizationManagerTest {
    private static final String TEST_USER = "testuser";
    private static final String PAGE_EDIT_PERMISSION = "pageEditPermission";
    private static final String[] PAGE_ACCESS_PERMISSION = new String[]{"pageAccessPermission"};
    private static final String TEST_PAGE = "testPage";
    private static final String TEST_SITE = "testSite";
    private static final String PAGE_KEY_FORMAT = "%s::%s::%s";
    private static final PageKey PORTAL_PAGE_KEY = PageKey.parse((String)String.format("%s::%s::%s", PortalConfig.PORTAL_TYPE, "testSite", "testPage"));
    private static final PageKey SPACE_PAGE_KEY = PageKey.parse((String)String.format("%s::%s::%s", PortalConfig.GROUP_TYPE, "/spaces/testSite", "testPage"));
    private static final PageKey SPACE_TEMPLATE_PAGE_KEY = PageKey.parse((String)String.format("%s::%s::%s", PortalConfig.GROUP_TEMPLATE, "/spaces/testSite", "testPage"));
    private static final MembershipEntry ADMIN_SPACES_MEMBERSHIP = new MembershipEntry("/group", "*");
    @Mock
    SpaceService spaceService;
    @Mock
    LayoutService layoutService;
    @Mock
    UserACL userAcl;
    @Mock
    InitParams params;
    @Mock
    Page page;
    @Mock
    PageContext pageContext;
    @Mock
    PageState pageState;
    @Mock
    PortalConfig portalConfig;
    @Mock
    Identity identity;
    @Mock
    SpaceTemplate spaceTemplate;
    @Mock
    Space space;
    AuthorizationManager authorizationManager;

    @Before
    public void setup() {
        ValueParam adminGroupsParam = (ValueParam)Mockito.mock(ValueParam.class);
        Mockito.when((Object)this.params.getValueParam("portal.administrator.groups")).thenReturn((Object)adminGroupsParam);
        Mockito.when((Object)adminGroupsParam.getValue()).thenReturn((Object)ADMIN_SPACES_MEMBERSHIP.getGroup());
        ValueParam adminMSTypeParam = (ValueParam)Mockito.mock(ValueParam.class);
        Mockito.when((Object)this.params.getValueParam("portal.administrator.mstype")).thenReturn((Object)adminMSTypeParam);
        Mockito.when((Object)adminMSTypeParam.getValue()).thenReturn((Object)ADMIN_SPACES_MEMBERSHIP.getMembershipType());
        this.authorizationManager = new AuthorizationManager(this.params);
        this.authorizationManager.setSpaceService(this.spaceService);
        this.authorizationManager.setLayoutService(this.layoutService);
    }

    @Test
    public void testHasNotEditPermissionWhenSiteNotSpace() {
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)TEST_USER);
        Mockito.when((Object)this.page.getOwnerType()).thenReturn((Object)PORTAL_PAGE_KEY.getSite().getTypeName());
        Mockito.when((Object)this.page.getOwnerId()).thenReturn((Object)PORTAL_PAGE_KEY.getSite().getName());
        Mockito.when((Object)this.page.getEditPermission()).thenReturn((Object)PAGE_EDIT_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.page, this.identity));
        Mockito.when((Object)this.pageContext.getKey()).thenReturn((Object)PORTAL_PAGE_KEY);
        Mockito.when((Object)this.pageContext.getState()).thenReturn((Object)this.pageState);
        Mockito.when((Object)this.pageState.getEditPermission()).thenReturn((Object)PAGE_EDIT_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.pageContext, this.identity));
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)PORTAL_PAGE_KEY.getSite().getTypeName());
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)PORTAL_PAGE_KEY.getSite().getName());
        Mockito.when((Object)this.portalConfig.getEditPermission()).thenReturn((Object)PAGE_EDIT_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.portalConfig, this.identity));
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.page, this.identity));
        Mockito.when((Object)this.identity.isMemberOf(ADMIN_SPACES_MEMBERSHIP.getGroup(), ADMIN_SPACES_MEMBERSHIP.getMembershipType())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.authorizationManager.hasEditPermission(this.page, this.identity));
    }

    @Test
    public void testHasEditPermissionWhenSiteIsASpace() {
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)TEST_USER);
        Mockito.when((Object)this.page.getOwnerType()).thenReturn((Object)SPACE_PAGE_KEY.getSite().getTypeName());
        Mockito.when((Object)this.page.getOwnerId()).thenReturn((Object)SPACE_PAGE_KEY.getSite().getName());
        Mockito.when((Object)this.page.getEditPermission()).thenReturn((Object)PAGE_EDIT_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.page, this.identity));
        Mockito.when((Object)this.pageContext.getKey()).thenReturn((Object)SPACE_PAGE_KEY);
        Mockito.when((Object)this.pageContext.getState()).thenReturn((Object)this.pageState);
        Mockito.when((Object)this.pageState.getEditPermission()).thenReturn((Object)PAGE_EDIT_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.pageContext, this.identity));
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)SPACE_PAGE_KEY.getSite().getTypeName());
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)SPACE_PAGE_KEY.getSite().getName());
        Mockito.when((Object)this.portalConfig.getEditPermission()).thenReturn((Object)PAGE_EDIT_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.portalConfig, this.identity));
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.page, this.identity));
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(SPACE_PAGE_KEY.getSite().getName())).thenReturn((Object)this.space);
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.portalConfig, this.identity));
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.page, this.identity));
        Mockito.when((Object)this.spaceService.canManageSpaceLayout(this.space, TEST_USER)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.authorizationManager.hasEditPermission(this.portalConfig, this.identity));
        Assert.assertTrue((boolean)this.authorizationManager.hasEditPermission(this.page, this.identity));
    }

    @Test
    public void testHasEditPermissionWhenSiteIsASpaceTemplate() {
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)TEST_USER);
        Mockito.when((Object)this.page.getOwnerType()).thenReturn((Object)SPACE_TEMPLATE_PAGE_KEY.getSite().getTypeName());
        Mockito.when((Object)this.page.getOwnerId()).thenReturn((Object)SPACE_TEMPLATE_PAGE_KEY.getSite().getName());
        Mockito.when((Object)this.page.getEditPermission()).thenReturn((Object)PAGE_EDIT_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.page, this.identity));
        Mockito.when((Object)this.pageContext.getKey()).thenReturn((Object)SPACE_TEMPLATE_PAGE_KEY);
        Mockito.when((Object)this.pageContext.getState()).thenReturn((Object)this.pageState);
        Mockito.when((Object)this.pageState.getEditPermission()).thenReturn((Object)PAGE_EDIT_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.pageContext, this.identity));
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)SPACE_TEMPLATE_PAGE_KEY.getSite().getTypeName());
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)SPACE_TEMPLATE_PAGE_KEY.getSite().getName());
        Mockito.when((Object)this.portalConfig.getEditPermission()).thenReturn((Object)PAGE_EDIT_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.portalConfig, this.identity));
        Mockito.when((Object)this.identity.isMemberOf(ADMIN_SPACES_MEMBERSHIP.getGroup(), ADMIN_SPACES_MEMBERSHIP.getMembershipType())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.authorizationManager.hasEditPermission(this.page, this.identity));
    }

    @Test
    public void testHasAccessPermissionWhenSiteNotSpace() {
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)TEST_USER);
        Mockito.when((Object)this.page.getOwnerType()).thenReturn((Object)PORTAL_PAGE_KEY.getSite().getTypeName());
        Mockito.when((Object)this.page.getOwnerId()).thenReturn((Object)PORTAL_PAGE_KEY.getSite().getName());
        Mockito.when((Object)this.page.getAccessPermissions()).thenReturn((Object)PAGE_ACCESS_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasAccessPermission(this.page, this.identity));
        Mockito.when((Object)this.pageContext.getKey()).thenReturn((Object)PORTAL_PAGE_KEY);
        Mockito.when((Object)this.pageContext.getState()).thenReturn((Object)this.pageState);
        Mockito.when((Object)this.pageState.getAccessPermissions()).thenReturn(Arrays.asList(PAGE_ACCESS_PERMISSION));
        Assert.assertFalse((boolean)this.authorizationManager.hasAccessPermission(this.pageContext, this.identity));
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)PORTAL_PAGE_KEY.getSite().getTypeName());
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)PORTAL_PAGE_KEY.getSite().getName());
        Mockito.when((Object)this.portalConfig.getAccessPermissions()).thenReturn((Object)PAGE_ACCESS_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasAccessPermission(this.portalConfig, this.identity));
        Mockito.when((Object)this.identity.isMemberOf(ADMIN_SPACES_MEMBERSHIP.getGroup(), ADMIN_SPACES_MEMBERSHIP.getMembershipType())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.authorizationManager.hasAccessPermission(this.page, this.identity));
    }

    @Test
    public void testHasAccessPermissionWhenSiteIsASpace() {
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)TEST_USER);
        Mockito.when((Object)this.page.getOwnerType()).thenReturn((Object)SPACE_PAGE_KEY.getSite().getTypeName());
        Mockito.when((Object)this.page.getOwnerId()).thenReturn((Object)SPACE_PAGE_KEY.getSite().getName());
        Mockito.when((Object)this.page.getAccessPermissions()).thenReturn((Object)PAGE_ACCESS_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasAccessPermission(this.page, this.identity));
        Mockito.when((Object)this.pageContext.getKey()).thenReturn((Object)SPACE_PAGE_KEY);
        Mockito.when((Object)this.pageContext.getState()).thenReturn((Object)this.pageState);
        Mockito.when((Object)this.pageState.getAccessPermissions()).thenReturn(Arrays.asList(PAGE_ACCESS_PERMISSION));
        Assert.assertFalse((boolean)this.authorizationManager.hasAccessPermission(this.pageContext, this.identity));
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)SPACE_PAGE_KEY.getSite().getTypeName());
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)SPACE_PAGE_KEY.getSite().getName());
        Mockito.when((Object)this.portalConfig.getAccessPermissions()).thenReturn((Object)PAGE_ACCESS_PERMISSION);
        Assert.assertFalse((boolean)this.authorizationManager.hasAccessPermission(this.portalConfig, this.identity));
        Mockito.when((Object)this.identity.isMemberOf(ADMIN_SPACES_MEMBERSHIP.getGroup(), ADMIN_SPACES_MEMBERSHIP.getMembershipType())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.authorizationManager.hasAccessPermission(this.page, this.identity));
    }

    @Test
    public void testCanEditWhenSiteIsSpacePublicSite() {
        String spaceId = "2";
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)TEST_USER);
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)PortalConfig.PORTAL_TYPE);
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)"publicSite");
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.portalConfig, this.identity));
        Mockito.when((Object)this.layoutService.getPortalConfig(PortalConfig.PORTAL_TYPE, "publicSite")).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.portalConfig.getProperty("SPACE_ID")).thenReturn((Object)spaceId);
        Mockito.when((Object)this.spaceService.getSpaceById(spaceId)).thenReturn((Object)this.space);
        Assert.assertFalse((boolean)this.authorizationManager.hasEditPermission(this.portalConfig, this.identity));
        Mockito.when((Object)this.spaceService.canManageSpacePublicSite(this.space, TEST_USER)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.authorizationManager.hasEditPermission(this.portalConfig, this.identity));
    }
}

