/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.cms.plugin;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.plugin.PermanentLinkPlugin;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.portal.plugin.AclPlugin;
import io.meeds.social.AbstractSpringConfigurationTest;
import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import io.meeds.social.html.model.HtmlTransformerContext;
import io.meeds.social.html.utils.HtmlUtils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class ContentLinkHtmlTransformerPluginTest
extends AbstractSpringConfigurationTest {
    private static final String ADDITIONAL_CONTENT = "Content1";
    private static final String PLUGIN_TITLE_KEY = "pluginTitleKey";
    private static final String PLUGIN_COMMAND = "pluginCommand";
    private static final String PLUGIN_ICON = "pluginIcon";
    private static final String CONTENT_LINK_TITLE = "contentTitle";
    private static final HtmlTransformerContext CONTENT_LINK_CONTEXT = new HtmlTransformerContext(Locale.ENGLISH);
    private static final HtmlTransformerContext CONTENT_LINK_USER_CONTEXT = new HtmlTransformerContext(new Identity("test"), Locale.ENGLISH);
    private static final String CONTENT_LINK_TYPE = "testContentLink";
    private static final String CONTENT_LINK_ID = "5874";
    private static final String CONTENT_LINK_RESTRICTED_ID = "5875";
    private static final String CONTENT_LINK = "Content1<content-link contenteditable=\"false\" style=\"display:none;\">/testContentLink:5874</content-link>";
    private static final String CONTENT_LINK_OLD = "Content1<a href=\"linkToContent\" data-object=\"testContentLink:5874\" contenteditable=\"false\" class=\"content-link\"><i aria-hidden=\"true\" class=\"v-icon notranslate theme--light icon-default-color\" style=\"font-size: 16px; margin: 0 4px;\"></i>Wrong Title</a>";
    private static final String CONTENT_LINK_RESULT = "Content1<a href=\"linkToContent\" data-object=\"testContentLink:5874\" contenteditable=\"false\" class=\"content-link\"><i aria-hidden=\"true\" class=\"pluginIcon v-icon notranslate theme--light icon-default-color\" style=\"font-size: 16px; margin: 0 4px;\"></i>contentTitle</a>";
    private static final String CONTENT_LINK_OBJECT_RESTRICTED = "Content1<a data-object=\"testContentLink:5875\" contenteditable=\"false\" class=\"content-link\"><i aria-hidden=\"true\" class=\"v-icon notranslate fa %s theme--light error--text\" style=\"font-size: 16px; margin: 0 4px;\"></i>(Access is restricted)</a>";
    private static final String CONTENT_LINK_OBJECT_NOT_FOUND = "Content1<a data-object=\"testContentLink:89665\" contenteditable=\"false\" class=\"content-link\"><i aria-hidden=\"true\" class=\"v-icon notranslate fa %s theme--light error--text\" style=\"font-size: 16px; margin: 0 4px;\"></i>(Content has been deleted)</a>";
    private static final String CONTENT_LINK_RESTRICTED = "Content1<content-link contenteditable=\"false\" style=\"display: none;\">/testContentLink:5875</content-link>";
    private static final String CONTENT_LINK_NOT_FOUND = "Content1<content-link contenteditable=\"false\" style=\"display: none;\">/testContentLink:89665</content-link>";
    private static final String CONTENT_LINK_NO_PLUGIN = "Content1<content-link contenteditable=\"false\" style=\"display: none;\">/noPlugin:89665</content-link>";
    @Autowired
    private ContentLinkPluginService contentLinkPluginService;
    @Autowired
    private PermanentLinkService permanentLinkService;
    @Autowired
    private UserACL userAcl;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.addAclPlugin(CONTENT_LINK_TYPE);
        this.addPermanentLinkPlugin(CONTENT_LINK_TYPE);
        this.addContentLinkPlugin();
    }

    @Test
    public void testNotContentLinkPlugin() {
        Assert.assertEquals((Object)CONTENT_LINK_NO_PLUGIN, (Object)HtmlUtils.transform((String)CONTENT_LINK_NO_PLUGIN, null).trim());
    }

    @Test
    public void testContentLinkPluginRestricted() {
        Assert.assertEquals((Object)String.format(CONTENT_LINK_OBJECT_RESTRICTED, PLUGIN_ICON).trim(), (Object)HtmlUtils.transform((String)CONTENT_LINK_RESTRICTED, (HtmlTransformerContext)CONTENT_LINK_USER_CONTEXT).trim());
    }

    @Test
    public void testContentLinkPluginNotFound() {
        Assert.assertEquals((Object)String.format(CONTENT_LINK_OBJECT_NOT_FOUND, PLUGIN_ICON).trim(), (Object)HtmlUtils.transform((String)CONTENT_LINK_NOT_FOUND, (HtmlTransformerContext)CONTENT_LINK_CONTEXT).trim());
    }

    @Test
    public void testContentLinkPlugin() {
        Assert.assertEquals((Object)CONTENT_LINK_RESULT.trim(), (Object)HtmlUtils.transform((String)CONTENT_LINK, (HtmlTransformerContext)CONTENT_LINK_CONTEXT).trim());
    }

    @Test
    public void testContentLinkPluginWhenRefresh() {
        Assert.assertEquals((Object)CONTENT_LINK_RESULT.trim(), (Object)HtmlUtils.transform((String)CONTENT_LINK_OLD, (HtmlTransformerContext)CONTENT_LINK_CONTEXT).trim());
    }

    private void addAclPlugin(final String objectType) {
        this.userAcl.addAclPlugin(new AclPlugin(){

            public boolean hasPermission(String objectId, String permissionType, Identity identity) {
                return ContentLinkHtmlTransformerPluginTest.this.userAcl.getSuperUser().equals(identity.getUserId());
            }

            public String getObjectType() {
                return objectType;
            }
        });
    }

    private void addPermanentLinkPlugin(final String objectType) {
        this.permanentLinkService.addPlugin(new PermanentLinkPlugin(){

            public String getObjectType() {
                return objectType;
            }

            public String getDirectAccessUrl(PermanentLinkObject object) throws ObjectNotFoundException {
                return "linkToContent";
            }

            public boolean canAccess(PermanentLinkObject object, Identity identity) throws ObjectNotFoundException {
                return ContentLinkHtmlTransformerPluginTest.CONTENT_LINK_ID.equals(object.getObjectId());
            }
        });
    }

    private void addContentLinkPlugin() {
        this.contentLinkPluginService.addPlugin(new ContentLinkPlugin(this){

            public List<ContentLinkSearchResult> search(String keyword, Identity identity, Locale locale, int offset, int limit) {
                return Collections.singletonList(new ContentLinkSearchResult(ContentLinkHtmlTransformerPluginTest.CONTENT_LINK_TYPE, ContentLinkHtmlTransformerPluginTest.CONTENT_LINK_ID, ContentLinkHtmlTransformerPluginTest.CONTENT_LINK_TITLE, ContentLinkHtmlTransformerPluginTest.PLUGIN_ICON));
            }

            public ContentLinkExtension getExtension() {
                return new ContentLinkExtension(ContentLinkHtmlTransformerPluginTest.CONTENT_LINK_TYPE, ContentLinkHtmlTransformerPluginTest.PLUGIN_TITLE_KEY, ContentLinkHtmlTransformerPluginTest.PLUGIN_ICON, ContentLinkHtmlTransformerPluginTest.PLUGIN_COMMAND);
            }

            public String getContentTitle(String objectId, Locale locale) {
                if (ContentLinkHtmlTransformerPluginTest.CONTENT_LINK_ID.equals(objectId) || ContentLinkHtmlTransformerPluginTest.CONTENT_LINK_RESTRICTED_ID.equals(objectId)) {
                    return ContentLinkHtmlTransformerPluginTest.CONTENT_LINK_TITLE;
                }
                return null;
            }
        });
    }
}

