/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.core.plugin;

import io.meeds.social.core.plugin.SiteAttachmentPlugin;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class SiteAttachmentPluginTest {
    private static final long SITE_ID = 123L;
    private static final String SITE_ID_STRING = String.valueOf(123L);
    private static final String SITE_NAME = "classic";
    private static final String SPACE_GROUP_ID = "/spaces/demo";
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private LayoutService layoutService;
    @Mock
    private UserACL userAcl;
    @Mock
    private AttachmentService attachmentService;
    @Mock
    private org.exoplatform.services.security.Identity userIdentity;
    @Mock
    private PortalConfig portalConfig;
    @Mock
    private Space space;
    @Mock
    private Identity socialIdentity;
    @InjectMocks
    private SiteAttachmentPlugin plugin;

    @Before
    public void setUp() {
        this.plugin.init();
    }

    @Test
    public void testGetObjectType() {
        Assert.assertEquals((Object)"site", (Object)this.plugin.getObjectType());
    }

    @Test
    public void testHasAccessPermission() {
        Mockito.when((Object)this.userAcl.hasAccessPermission("site", SITE_ID_STRING, this.userIdentity)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.plugin.hasAccessPermission(this.userIdentity, SITE_ID_STRING));
    }

    @Test
    public void testHasEditPermission() {
        Mockito.when((Object)this.userAcl.hasEditPermission("site", SITE_ID_STRING, this.userIdentity)).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.plugin.hasEditPermission(this.userIdentity, SITE_ID_STRING));
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testGetAudienceIdPortalConfigNull() {
        Mockito.when((Object)this.layoutService.getPortalConfig(123L)).thenReturn(null);
        this.plugin.getAudienceId(SITE_ID_STRING);
    }

    @Test
    public void testGetAudienceIdSpaceSite() {
        Mockito.when((Object)this.layoutService.getPortalConfig(123L)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)PortalConfig.GROUP_TYPE);
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)SPACE_GROUP_ID);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(SPACE_GROUP_ID)).thenReturn((Object)this.space);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity(this.space.getPrettyName())).thenReturn((Object)this.socialIdentity);
        Mockito.when((Object)this.socialIdentity.getIdentityId()).thenReturn((Object)42L);
        long id = this.plugin.getAudienceId(SITE_ID_STRING);
        Assert.assertEquals((long)42L, (long)id);
    }

    @Test
    public void testGetAudienceIdUserSite() {
        Mockito.when((Object)this.layoutService.getPortalConfig(123L)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)PortalConfig.USER_TYPE);
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)"john");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("john")).thenReturn((Object)this.socialIdentity);
        Mockito.when((Object)this.socialIdentity.getIdentityId()).thenReturn((Object)99L);
        long id = this.plugin.getAudienceId(SITE_ID_STRING);
        Assert.assertEquals((long)99L, (long)id);
    }

    @Test
    public void testGetAudienceIdOtherSite() {
        Mockito.when((Object)this.layoutService.getPortalConfig(123L)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)PortalConfig.PORTAL_TYPE);
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)SITE_NAME);
        long id = this.plugin.getAudienceId(SITE_ID_STRING);
        Assert.assertEquals((long)0L, (long)id);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testGetSpaceIdPortalConfigNull() {
        Mockito.when((Object)this.layoutService.getPortalConfig(123L)).thenReturn(null);
        this.plugin.getSpaceId(SITE_ID_STRING);
    }

    @Test
    public void testGetSpaceIdSpaceSite() {
        Mockito.when((Object)this.layoutService.getPortalConfig(123L)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)PortalConfig.GROUP_TYPE);
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)SPACE_GROUP_ID);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(SPACE_GROUP_ID)).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getSpaceId()).thenReturn((Object)55L);
        long id = this.plugin.getSpaceId(SITE_ID_STRING);
        Assert.assertEquals((long)55L, (long)id);
    }

    @Test
    public void testGetSpaceIdSpaceSiteNullSpace() {
        Mockito.when((Object)this.layoutService.getPortalConfig(123L)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)PortalConfig.GROUP_TYPE);
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)SPACE_GROUP_ID);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(SPACE_GROUP_ID)).thenReturn(null);
        long id = this.plugin.getSpaceId(SITE_ID_STRING);
        Assert.assertEquals((long)0L, (long)id);
    }

    @Test
    public void testGetSpaceIdOtherSite() {
        Mockito.when((Object)this.layoutService.getPortalConfig(123L)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)PortalConfig.PORTAL_TYPE);
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)SITE_NAME);
        long id = this.plugin.getSpaceId(SITE_ID_STRING);
        Assert.assertEquals((long)0L, (long)id);
    }
}

