/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.social.navigation.AbstractNavigationConfigurationTest;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class SiteSidebarPluginTest
extends AbstractNavigationConfigurationTest {
    @Test
    public void testGetType() {
        Assert.assertEquals((Object)SidebarItemType.SITE, (Object)this.siteSidebarPlugin.getType());
    }

    @Test
    public void testGetDefaultItems() {
        List defaultItems = this.siteSidebarPlugin.getDefaultItems();
        Assert.assertNotNull((Object)defaultItems);
        Assert.assertFalse((boolean)defaultItems.isEmpty());
        Assert.assertTrue((boolean)defaultItems.stream().anyMatch(item -> StringUtils.equals((CharSequence)item.getName(), (CharSequence)"classic")));
    }

    @Test
    public void testItemExists() {
        Assert.assertFalse((boolean)this.siteSidebarPlugin.itemExists(null, null));
        Assert.assertFalse((boolean)this.siteSidebarPlugin.itemExists(new SidebarItem(), null));
        SidebarItem item = new SidebarItem(SidebarItemType.SITE);
        HashMap<String, String> properties = new HashMap<String, String>();
        item.setProperties(properties);
        properties.put("siteType", "portal");
        properties.put("siteName", "notfound");
        Assert.assertFalse((boolean)this.siteSidebarPlugin.itemExists(item, null));
        properties.put("siteName", "contribute");
        Assert.assertTrue((boolean)this.siteSidebarPlugin.itemExists(item, null));
    }

    @Test
    public void testResolveProperties() {
        SidebarItem item = new SidebarItem(SidebarItemType.SITE);
        HashMap<String, String> properties = new HashMap<String, String>();
        item.setProperties(properties);
        properties.put("siteType", "portal");
        properties.put("siteName", "contribute");
        this.siteSidebarPlugin.resolveProperties(item, this.userAcl.getSuperUser(), Locale.ENGLISH);
        Assert.assertEquals((Object)"contribute", (Object)item.getName());
        Assert.assertEquals((Object)"/portal/contribute", (Object)item.getUrl());
        Assert.assertNull((Object)item.getTarget());
        Assert.assertNull((Object)item.getAvatar());
        Assert.assertNull((Object)item.getItems());
        Assert.assertEquals((Object)"a-icon", (Object)item.getIcon());
    }
}

