/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.key;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.storage.cache.model.key.CacheKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityKey;

public class IdentityFilterKey
implements CacheKey {
    private static final long serialVersionUID = 6711481249085725845L;
    private String providerId;
    private String remoteId;
    private String name;
    private String position;
    private String company;
    private String skills;
    private List<IdentityKey> excluded;
    private List<String> onlineRemoteIds;
    private List<String> remoteIds;
    private String all;
    private Sorting sorting;
    private String userType;
    private Boolean isConnected;
    private boolean isEnabled;
    private String enrollmentStatus;

    public IdentityFilterKey(String providerId, String remoteId, ProfileFilter filter) {
        this.remoteId = remoteId;
        this.providerId = providerId;
        if (filter != null) {
            this.name = filter.getName();
            this.position = filter.getPosition();
            this.company = filter.getCompany();
            this.skills = filter.getSkills();
            this.userType = filter.getUserType();
            this.isConnected = filter.isConnected();
            this.isEnabled = filter.isEnabled();
            this.enrollmentStatus = filter.getEnrollmentStatus();
            ArrayList<IdentityKey> keys = new ArrayList<IdentityKey>();
            for (Identity i : filter.getExcludedIdentityList()) {
                keys.add(new IdentityKey(i));
            }
            this.excluded = Collections.unmodifiableList(keys);
            this.onlineRemoteIds = Collections.unmodifiableList(filter.getOnlineRemoteIds());
            this.remoteIds = filter.getRemoteIds() == null ? null : Collections.unmodifiableList(filter.getRemoteIds());
            this.all = filter.getAll();
            this.sorting = filter.getSorting();
        }
    }

    public IdentityFilterKey(String providerId, ProfileFilter filter) {
        this(providerId, null, filter);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getName() {
        return this.name;
    }

    public String getPosition() {
        return this.position;
    }

    public String getCompany() {
        return this.company;
    }

    public String getSkills() {
        return this.skills;
    }

    public List<IdentityKey> getExcluded() {
        return this.excluded;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentityFilterKey)) {
            return false;
        }
        IdentityFilterKey other = (IdentityFilterKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled != other.isEnabled) {
            return false;
        }
        Boolean this$isConnected = this.isConnected;
        Boolean other$isConnected = other.isConnected;
        if (this$isConnected == null ? other$isConnected != null : !((Object)this$isConnected).equals(other$isConnected)) {
            return false;
        }
        String this$providerId = this.getProviderId();
        String other$providerId = other.getProviderId();
        if (this$providerId == null ? other$providerId != null : !this$providerId.equals(other$providerId)) {
            return false;
        }
        String this$remoteId = this.remoteId;
        String other$remoteId = other.remoteId;
        if (this$remoteId == null ? other$remoteId != null : !this$remoteId.equals(other$remoteId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$position = this.getPosition();
        String other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        String this$company = this.getCompany();
        String other$company = other.getCompany();
        if (this$company == null ? other$company != null : !this$company.equals(other$company)) {
            return false;
        }
        String this$skills = this.getSkills();
        String other$skills = other.getSkills();
        if (this$skills == null ? other$skills != null : !this$skills.equals(other$skills)) {
            return false;
        }
        List<IdentityKey> this$excluded = this.getExcluded();
        List<IdentityKey> other$excluded = other.getExcluded();
        if (this$excluded == null ? other$excluded != null : !((Object)this$excluded).equals(other$excluded)) {
            return false;
        }
        List<String> this$onlineRemoteIds = this.onlineRemoteIds;
        List<String> other$onlineRemoteIds = other.onlineRemoteIds;
        if (this$onlineRemoteIds == null ? other$onlineRemoteIds != null : !((Object)this$onlineRemoteIds).equals(other$onlineRemoteIds)) {
            return false;
        }
        List<String> this$remoteIds = this.remoteIds;
        List<String> other$remoteIds = other.remoteIds;
        if (this$remoteIds == null ? other$remoteIds != null : !((Object)this$remoteIds).equals(other$remoteIds)) {
            return false;
        }
        String this$all = this.all;
        String other$all = other.all;
        if (this$all == null ? other$all != null : !this$all.equals(other$all)) {
            return false;
        }
        Sorting this$sorting = this.sorting;
        Sorting other$sorting = other.sorting;
        if (this$sorting == null ? other$sorting != null : !this$sorting.equals(other$sorting)) {
            return false;
        }
        String this$userType = this.userType;
        String other$userType = other.userType;
        if (this$userType == null ? other$userType != null : !this$userType.equals(other$userType)) {
            return false;
        }
        String this$enrollmentStatus = this.enrollmentStatus;
        String other$enrollmentStatus = other.enrollmentStatus;
        return !(this$enrollmentStatus == null ? other$enrollmentStatus != null : !this$enrollmentStatus.equals(other$enrollmentStatus));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IdentityFilterKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled ? 79 : 97);
        Boolean $isConnected = this.isConnected;
        result = result * 59 + ($isConnected == null ? 43 : ((Object)$isConnected).hashCode());
        String $providerId = this.getProviderId();
        result = result * 59 + ($providerId == null ? 43 : $providerId.hashCode());
        String $remoteId = this.remoteId;
        result = result * 59 + ($remoteId == null ? 43 : $remoteId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        String $company = this.getCompany();
        result = result * 59 + ($company == null ? 43 : $company.hashCode());
        String $skills = this.getSkills();
        result = result * 59 + ($skills == null ? 43 : $skills.hashCode());
        List<IdentityKey> $excluded = this.getExcluded();
        result = result * 59 + ($excluded == null ? 43 : ((Object)$excluded).hashCode());
        List<String> $onlineRemoteIds = this.onlineRemoteIds;
        result = result * 59 + ($onlineRemoteIds == null ? 43 : ((Object)$onlineRemoteIds).hashCode());
        List<String> $remoteIds = this.remoteIds;
        result = result * 59 + ($remoteIds == null ? 43 : ((Object)$remoteIds).hashCode());
        String $all = this.all;
        result = result * 59 + ($all == null ? 43 : $all.hashCode());
        Sorting $sorting = this.sorting;
        result = result * 59 + ($sorting == null ? 43 : $sorting.hashCode());
        String $userType = this.userType;
        result = result * 59 + ($userType == null ? 43 : $userType.hashCode());
        String $enrollmentStatus = this.enrollmentStatus;
        result = result * 59 + ($enrollmentStatus == null ? 43 : $enrollmentStatus.hashCode());
        return result;
    }
}

