/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.social.navigation.AbstractNavigationConfigurationTest;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.junit.Assert;
import org.junit.Test;

public class PageSidebarPluginTest
extends AbstractNavigationConfigurationTest {
    @Test
    public void testGetType() {
        Assert.assertEquals((Object)SidebarItemType.PAGE, (Object)this.pageSidebarPlugin.getType());
    }

    @Test
    public void testGetDefaultItems() {
        List defaultItems = this.pageSidebarPlugin.getDefaultItems();
        Assert.assertNotNull((Object)defaultItems);
        Assert.assertTrue((boolean)defaultItems.isEmpty());
    }

    @Test
    public void testItemExists() {
        Assert.assertFalse((boolean)this.pageSidebarPlugin.itemExists(null, null));
        Assert.assertFalse((boolean)this.pageSidebarPlugin.itemExists(new SidebarItem(), null));
        SidebarItem item = new SidebarItem(SidebarItemType.PAGE);
        item.setProperties(Collections.singletonMap("navigationNodeId", "3555"));
        Assert.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, null));
        NodeContext node = this.navigationService.loadNode(SiteKey.portal((String)"contribute"));
        Assert.assertNotNull((Object)node);
        item.setProperties(Collections.singletonMap("navigationNodeId", node.get("a").getId()));
        Assert.assertTrue((boolean)this.pageSidebarPlugin.itemExists(item, this.userAcl.getSuperUser()));
        Assert.assertTrue((boolean)this.pageSidebarPlugin.itemExists(item, "demo"));
        Assert.assertTrue((boolean)this.pageSidebarPlugin.itemExists(item, null));
        item.setProperties(Collections.singletonMap("navigationNodeId", node.get("b").getId()));
        Assert.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, this.userAcl.getSuperUser()));
        Assert.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, "demo"));
        Assert.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, null));
        item.setProperties(Collections.singletonMap("navigationNodeId", node.get("c").getId()));
        Assert.assertTrue((boolean)this.pageSidebarPlugin.itemExists(item, this.userAcl.getSuperUser()));
        Assert.assertTrue((boolean)this.pageSidebarPlugin.itemExists(item, "demo"));
        Assert.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, null));
        item.setProperties(Collections.singletonMap("navigationNodeId", node.get("d").getId()));
        Assert.assertTrue((boolean)this.pageSidebarPlugin.itemExists(item, this.userAcl.getSuperUser()));
        Assert.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, "demo"));
        Assert.assertFalse((boolean)this.pageSidebarPlugin.itemExists(item, null));
    }

    @Test
    public void testResolveProperties() {
        SiteKey siteKey = SiteKey.portal((String)"contribute");
        SidebarItem item = new SidebarItem(SidebarItemType.PAGE);
        NodeContext node = this.navigationService.loadNode(siteKey);
        item.setProperties(Collections.singletonMap("navigationNodeId", node.get("d").getId()));
        this.pageSidebarPlugin.resolveProperties(item, this.userAcl.getSuperUser(), Locale.ENGLISH);
        Assert.assertEquals((Object)"d", (Object)item.getName());
        Assert.assertEquals((Object)"/portal/contribute/d", (Object)item.getUrl());
        Assert.assertNull((Object)item.getTarget());
        Assert.assertNull((Object)item.getAvatar());
        Assert.assertNull((Object)item.getItems());
        Assert.assertEquals((Object)"d-icon", (Object)item.getIcon());
        PortalConfig site = this.layoutService.getPortalConfig(siteKey);
        String siteId = site.getStorageId().split("_")[1];
        Assert.assertEquals((Object)siteId, item.getProperties().get("siteId"));
        Assert.assertEquals((Object)siteKey.getTypeName(), item.getProperties().get("siteType"));
        Assert.assertEquals((Object)siteKey.getName(), item.getProperties().get("siteName"));
        Assert.assertEquals((Object)"a-icon", item.getProperties().get("siteIcon"));
        Assert.assertEquals((Object)"contribute", item.getProperties().get("siteDisplayName"));
    }
}

