/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.social.navigation.AbstractNavigationConfigurationTest;
import io.meeds.social.util.JsonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpaceListSidebarPluginTest
extends AbstractNavigationConfigurationTest {
    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
        for (int i = 0; i < 5; ++i) {
            Space space = new Space();
            space.setRegistration("open");
            space.setVisibility("public");
            this.spaceService.createSpace(space, this.userAcl.getSuperUser());
        }
    }

    @Test
    public void testGetType() {
        Assert.assertEquals((Object)SidebarItemType.SPACES, (Object)this.spaceListSidebarPlugin.getType());
    }

    @Test
    public void testGetDefaultItems() {
        List defaultItems = this.spaceListSidebarPlugin.getDefaultItems();
        Assert.assertNotNull((Object)defaultItems);
        Assert.assertTrue((boolean)defaultItems.stream().anyMatch(item -> StringUtils.contains((CharSequence)((CharSequence)item.getProperties().get("names")), (CharSequence)"sidebar.viewAllSpaces")));
    }

    @Test
    public void testItemExists() {
        Assert.assertFalse((boolean)this.spaceListSidebarPlugin.itemExists(null, null));
        Assert.assertFalse((boolean)this.spaceListSidebarPlugin.itemExists(new SidebarItem(), null));
        SidebarItem item = new SidebarItem(SidebarItemType.SPACES);
        Assert.assertFalse((boolean)this.spaceListSidebarPlugin.itemExists(item, null));
        item.setProperties(Collections.singletonMap("names", "{}"));
        Assert.assertTrue((boolean)this.spaceListSidebarPlugin.itemExists(item, null));
    }

    @Test
    public void testResolveProperties() {
        String enName = "Test EN";
        String frName = "Test FR";
        HashMap<String, String> names = new HashMap<String, String>();
        names.put(Locale.ENGLISH.toLanguageTag(), enName);
        names.put(Locale.FRENCH.toLanguageTag(), frName);
        String namesJsonString = JsonUtils.toJsonString(names);
        SidebarItem item = new SidebarItem("fakeName", "url", "target", "avatar", "icon", SidebarItemType.SPACES, null, Collections.singletonMap("names", namesJsonString), false);
        SidebarItem result = this.spaceListSidebarPlugin.resolveProperties(item, null, Locale.ENGLISH);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)enName, (Object)result.getName());
        result = this.spaceListSidebarPlugin.resolveProperties(item, null, Locale.FRENCH);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)frName, (Object)result.getName());
        Assert.assertNotNull((Object)result.getItems());
        Assert.assertTrue((boolean)result.getItems().isEmpty());
        Assert.assertFalse((boolean)item.isDefaultPath());
        result = this.spaceListSidebarPlugin.resolveProperties(item, this.userAcl.getSuperUser(), Locale.FRENCH);
        Assert.assertNotNull((Object)result.getItems());
        Assert.assertEquals((long)4L, (long)item.getItems().size());
        Assert.assertTrue((boolean)((SidebarItem)item.getItems().get(0)).isDefaultPath());
    }
}

