/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.core.identity.service;

import io.meeds.social.core.identity.model.UserImportResult;
import io.meeds.social.core.identity.service.UserImportService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class UserImportServiceTest {
    private static final String UPLOAD_ID = "id";
    private static final String NOT_FOUND_ID = "x";
    private static final String COMPANY_VALUE = "ACME";
    private static final String COMPANY_PROP = "company";
    private static final String TEST_USER_2 = "mod";
    private static final String TEST_USER_1 = "ghost";
    private static final String HEADER_LINE_1 = "userName,password,enabled,email,firstName,lastName";
    private static final String HEADER_LINE_2 = "userName,password,enabled,email,firstName,lastName,onboardUser";
    private static final String HEADER_LINE_3 = "userName,password,enabled,email,firstName,lastName,aboutMe";
    private static final String HEADER_LINE_4 = "userName,password,email,firstName,lastName";
    private static final String HEADER_LINE_5 = "userName,email,firstName,lastName";
    private static final String URL = "http://localhost";
    @Rule
    public final MockitoRule rule = MockitoJUnit.rule();
    @Mock
    private IdentityManager identityManager;
    @Mock
    private OrganizationService organizationService;
    @Mock
    private ProfilePropertyService profilePropertyService;
    @Mock
    private LocaleConfigService localeConfigService;
    @Mock
    private PasswordRecoveryService passwordRecoveryService;
    @Mock
    private UploadService uploadService;
    @Mock
    private UserHandler userHandler;
    @Mock
    private GroupHandler groupHandler;
    @Mock
    private MembershipTypeHandler membershipTypeHandler;
    @Mock
    private MembershipHandler membershipHandler;
    @Mock
    private Identity userIdentity;
    @Mock
    private Profile profile;
    @Mock
    private UploadResource uploadResource;
    @Mock
    private ExecutorService executorService;
    @Mock
    private UserACL userAcl;
    @InjectMocks
    private UserImportService service;
    private File tempDir;

    @Before
    public void setUp() {
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.organizationService.getGroupHandler()).thenReturn((Object)this.groupHandler);
        Mockito.when((Object)this.organizationService.getMembershipTypeHandler()).thenReturn((Object)this.membershipTypeHandler);
        Mockito.when((Object)this.organizationService.getMembershipHandler()).thenReturn((Object)this.membershipHandler);
        Mockito.when((Object)this.userIdentity.getProfile()).thenReturn((Object)this.profile);
        LocaleConfigImpl localeConfig = new LocaleConfigImpl();
        localeConfig.setLocale(Locale.ENGLISH);
        Mockito.when((Object)this.localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)localeConfig);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(ArgumentMatchers.anyString())).thenReturn((Object)this.userIdentity);
        this.tempDir = Files.createTempDirectory("uimport-test", new FileAttribute[0]).toFile();
        this.service.init();
        this.service.importExecutorService = this.executorService;
        ((ExecutorService)Mockito.doAnswer(invocation -> {
            ((Runnable)invocation.getArgument(0, Runnable.class)).run();
            return null;
        }).when((Object)this.executorService)).execute((Runnable)ArgumentMatchers.any());
    }

    @After
    public void tearDown() {
        this.service.stop();
        UserImportServiceTest.deleteRecursively(this.tempDir);
    }

    @Test
    public void testGetAndCleanUsersImportResult() {
        UserImportResult r = new UserImportResult();
        this.service.importUsersProcessing = new HashMap();
        Assert.assertNull((Object)this.service.getUsersImportResult(NOT_FOUND_ID));
        this.service.importUsersProcessing.put(UPLOAD_ID, r);
        Assert.assertEquals((Object)r, (Object)this.service.getUsersImportResult(UPLOAD_ID));
        this.service.cleanUsersImportResult(UPLOAD_ID);
        Assert.assertNull((Object)this.service.getUsersImportResult(UPLOAD_ID));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportUsersUploadIdNotFound() {
        this.service.importUsers(NOT_FOUND_ID, TEST_USER_2, Locale.ENGLISH, URL, true);
    }

    @Test(expected=IllegalStateException.class)
    public void testImportUsersFileMissingOnDisk() {
        File nonExisting = new File(this.tempDir, "nope.csv");
        Mockito.when((Object)this.uploadResource.getStoreLocation()).thenReturn((Object)nonExisting.getAbsolutePath());
        Mockito.when((Object)this.uploadService.getUploadResource("u1")).thenReturn((Object)this.uploadResource);
        this.service.importUsers("u1", TEST_USER_2, Locale.ENGLISH, URL, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportUsersEmptyFile() {
        File f = this.csv("empty.csv", "userName,password,enabled");
        Mockito.when((Object)this.uploadResource.getStoreLocation()).thenReturn((Object)f.getAbsolutePath());
        Mockito.when((Object)this.uploadService.getUploadResource("u2")).thenReturn((Object)this.uploadResource);
        this.service.importUsers("u2", TEST_USER_2, Locale.ENGLISH, URL, true);
    }

    @Test
    public void testImportUsersSyncPathSuccess() throws Exception {
        File f = this.csv("one.csv", HEADER_LINE_1, "john,Secret123,true,john@ex.com,John,Doe");
        Mockito.when((Object)this.uploadResource.getStoreLocation()).thenReturn((Object)f.getAbsolutePath());
        Mockito.when((Object)this.uploadService.getUploadResource("u3")).thenReturn((Object)this.uploadResource);
        Mockito.when((Object)this.userHandler.findUserByName("john", UserStatus.ANY)).thenReturn(null);
        ((UserHandler)Mockito.doAnswer(i -> null).when((Object)this.userHandler)).createUser((User)ArgumentMatchers.any(User.class), ArgumentMatchers.eq((boolean)true));
        ListAccess none = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)none.getSize()).thenReturn((Object)0);
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (UserStatus)ArgumentMatchers.eq((Object)UserStatus.ANY))).thenReturn((Object)none);
        Assertions.assertDoesNotThrow(() -> this.service.importUsers("u3", TEST_USER_2, Locale.ENGLISH, URL, true));
    }

    @Test
    public void testImportUsersHeaderBlankReturnsEarly() {
        File f = this.csv("blankHeader.csv", "");
        UserImportResult r = new UserImportResult();
        this.service.importUsers(f.getAbsolutePath(), r, TEST_USER_2, Locale.ENGLISH, URL);
        Assert.assertEquals((long)0L, (long)r.getProcessedCount());
    }

    @Test
    public void testImportUsersBadLineMissingUserName() throws Exception {
        File f = this.csv("badLine.csv", HEADER_LINE_1, ",Secret123,true,jane@ex.com,Jane,Doe");
        UserImportResult r = new UserImportResult();
        Mockito.when((Object)this.userHandler.findUserByName(ArgumentMatchers.anyString(), (UserStatus)ArgumentMatchers.any())).thenReturn(null);
        ListAccess none = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)none.getSize()).thenReturn((Object)0);
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (UserStatus)ArgumentMatchers.any())).thenReturn((Object)none);
        this.service.importUsers(f.getAbsolutePath(), r, TEST_USER_2, Locale.ENGLISH, URL);
        Assert.assertEquals((long)1L, (long)r.getProcessedCount());
    }

    @Test
    public void testImportUsersExistingUserUpdateAndOnboarding() throws Exception {
        File f = this.csv("exists.csv", HEADER_LINE_2, "john,Secret123,true,john@ex.com,John,Doe,true");
        User existing = (User)Mockito.mock(User.class);
        Date now = Calendar.getInstance().getTime();
        Mockito.when((Object)existing.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)existing.getCreatedDate()).thenReturn((Object)now);
        Mockito.when((Object)existing.getLastLoginTime()).thenReturn((Object)now);
        Mockito.when((Object)this.userHandler.findUserByName("john", UserStatus.ANY)).thenReturn((Object)existing);
        Mockito.when((Object)this.passwordRecoveryService.sendOnboardingEmail((User)ArgumentMatchers.any(UserImpl.class), (Locale)ArgumentMatchers.eq((Object)Locale.ENGLISH), (StringBuilder)ArgumentMatchers.any(StringBuilder.class))).thenReturn((Object)true);
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName(ArgumentMatchers.anyString())).thenReturn(null);
        UserImportResult r = new UserImportResult();
        this.service.importUsers(f.getAbsolutePath(), r, TEST_USER_2, Locale.ENGLISH, URL);
        ((IdentityManager)Mockito.verify((Object)this.identityManager, (VerificationMode)Mockito.atLeastOnce())).updateProfile((Profile)ArgumentMatchers.any(Profile.class), (String)ArgumentMatchers.eq((Object)TEST_USER_2), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void testImportUsersEmailAlreadyExistsCreateRejected() throws Exception {
        File f = this.csv("dupemail.csv", HEADER_LINE_1, "alice,Secret123,true,dup@ex.com,Alice,Smith");
        Mockito.when((Object)this.userHandler.findUserByName("alice", UserStatus.ANY)).thenReturn(null);
        ListAccess one = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)one.getSize()).thenReturn((Object)1);
        User other = (User)Mockito.mock(User.class);
        Mockito.when((Object)other.getUserName()).thenReturn((Object)"bob");
        Mockito.when((Object)((User[])one.load(0, 1))).thenReturn((Object)new User[]{other});
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (UserStatus)ArgumentMatchers.eq((Object)UserStatus.ANY))).thenReturn((Object)one);
        UserImportResult r = new UserImportResult();
        this.service.importUsers(f.getAbsolutePath(), r, TEST_USER_2, Locale.ENGLISH, URL);
        Assert.assertEquals((long)1L, (long)r.getProcessedCount());
    }

    @Test
    public void testImportUsersNewUserCreatedEnabledFlag() throws Exception {
        File f = this.csv("create.csv", HEADER_LINE_1, "neo,Secret123,false,neo@ex.com,Neo,Anderson");
        Mockito.when((Object)this.userHandler.findUserByName("neo", UserStatus.ANY)).thenReturn(null);
        ListAccess none = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)none.getSize()).thenReturn((Object)0);
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (UserStatus)ArgumentMatchers.eq((Object)UserStatus.ANY))).thenReturn((Object)none);
        UserImportResult r = new UserImportResult();
        this.service.importUsers(f.getAbsolutePath(), r, TEST_USER_2, Locale.ENGLISH, URL);
        ((UserHandler)Mockito.verify((Object)this.userHandler)).createUser((User)ArgumentMatchers.any(User.class), ArgumentMatchers.eq((boolean)true));
        ((UserHandler)Mockito.verify((Object)this.userHandler)).setEnabled("neo", false, true);
    }

    @Test
    public void testUpdateUserProfilePropertiesObjectNotFoundWarn() throws Exception {
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(TEST_USER_1)).thenReturn(null);
        File f = this.csv("profile_notfound.csv", HEADER_LINE_3, "ghost,Secret123,true,g@e.com,Gh,Ost,hello");
        Mockito.when((Object)this.userHandler.findUserByName(TEST_USER_1, UserStatus.ANY)).thenReturn(null);
        ListAccess none = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)none.getSize()).thenReturn((Object)0);
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (UserStatus)ArgumentMatchers.eq((Object)UserStatus.ANY))).thenReturn((Object)none);
        UserImportResult r = new UserImportResult();
        Assertions.assertDoesNotThrow(() -> this.service.importUsers(f.getAbsolutePath(), r, TEST_USER_2, Locale.ENGLISH, URL));
    }

    @Test
    public void testComputeFieldsWarnings() throws Exception {
        ProfilePropertySetting parent = new ProfilePropertySetting();
        parent.setPropertyName("phones");
        parent.setMultiValued(true);
        parent.setHasChildProperties(true);
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName("unknown")).thenReturn(null);
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName("phones")).thenReturn((Object)parent);
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName("child")).thenReturn(null);
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setPropertyName("customMulti");
        profilePropertySetting.setMultiValued(true);
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName("customMulti")).thenReturn((Object)profilePropertySetting);
        File f = this.csv("headers.csv", "userName,unknown,phones,phones.child,customMulti,emails.too.many.parents,email", "john,,,,,,john@ex.com");
        ListAccess none = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)none.getSize()).thenReturn((Object)0);
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (UserStatus)ArgumentMatchers.eq((Object)UserStatus.ANY))).thenReturn((Object)none);
        Mockito.when((Object)this.userHandler.findUserByName("john", UserStatus.ANY)).thenReturn(null);
        UserImportResult r = new UserImportResult();
        this.service.importUsers(f.getAbsolutePath(), r, TEST_USER_2, Locale.ENGLISH, URL);
        Assert.assertEquals((long)1L, (long)r.getProcessedCount());
    }

    @Test(expected=IllegalAccessException.class)
    public void testUpdateProfileFieldNotEditable() throws IllegalAccessException, IOException {
        ProfilePropertySetting s = new ProfilePropertySetting();
        s.setPropertyName(COMPANY_PROP);
        s.setEditable(false);
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName(COMPANY_PROP)).thenReturn((Object)s);
        Mockito.when((Object)this.userAcl.getSuperUser()).thenReturn((Object)"root");
        this.service.updateProfileField(this.profile, COMPANY_PROP, (Object)COMPANY_VALUE, false, TEST_USER_2);
    }

    @Test(expected=IllegalAccessException.class)
    public void testUpdateProfileFieldReservedExternal() throws IllegalAccessException, IOException {
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName("external")).thenReturn(null);
        this.service.updateProfileField(this.profile, "external", (Object)"true", false, TEST_USER_2);
    }

    @Test(expected=IllegalAccessException.class)
    public void testUpdateProfileFieldReservedUsername() throws IllegalAccessException, IOException {
        this.service.updateProfileField(this.profile, "username", (Object)"john", false, TEST_USER_2);
    }

    @Test(expected=IllegalStateException.class)
    public void testUpdateProfileFieldAvatarUploadMissing() throws IllegalAccessException, IOException {
        Mockito.when((Object)this.uploadService.getUploadResource("nope")).thenReturn(null);
        this.service.updateProfileField(this.profile, "avatar", (Object)"nope", false, TEST_USER_2);
    }

    @Test
    public void testUpdateProfileFieldAvatarSuccess() throws IllegalAccessException, IOException {
        File f = this.csv("avatar.bin", "content");
        UploadResource ur = (UploadResource)Mockito.mock(UploadResource.class);
        Mockito.when((Object)ur.getStoreLocation()).thenReturn((Object)f.getAbsolutePath());
        Mockito.when((Object)ur.getFileName()).thenReturn((Object)"pic.png");
        Mockito.when((Object)ur.getMimeType()).thenReturn((Object)"image/png");
        Mockito.when((Object)this.uploadService.getUploadResource("up1")).thenReturn((Object)ur);
        this.service.updateProfileField(this.profile, "avatar", (Object)"up1", true, TEST_USER_2);
        ((IdentityManager)Mockito.verify((Object)this.identityManager, (VerificationMode)Mockito.atLeastOnce())).updateProfile((Profile)ArgumentMatchers.any(Profile.class), (String)ArgumentMatchers.eq((Object)TEST_USER_2), ArgumentMatchers.eq((boolean)true));
        ((UploadService)Mockito.verify((Object)this.uploadService)).removeUploadResource("up1");
    }

    @Test
    public void testUpdateProfileFieldBannerSuccess() throws IllegalAccessException, IOException {
        File f = this.csv("banner.bin", "content");
        UploadResource ur = (UploadResource)Mockito.mock(UploadResource.class);
        Mockito.when((Object)ur.getStoreLocation()).thenReturn((Object)f.getAbsolutePath());
        Mockito.when((Object)ur.getFileName()).thenReturn((Object)"ban.png");
        Mockito.when((Object)ur.getMimeType()).thenReturn((Object)"image/png");
        Mockito.when((Object)this.uploadService.getUploadResource("up2")).thenReturn((Object)ur);
        this.service.updateProfileField(this.profile, "banner", (Object)"up2", true, TEST_USER_2);
        ((IdentityManager)Mockito.verify((Object)this.identityManager, (VerificationMode)Mockito.atLeastOnce())).updateProfile((Profile)ArgumentMatchers.any(Profile.class), (String)ArgumentMatchers.eq((Object)TEST_USER_2), ArgumentMatchers.eq((boolean)true));
        ((UploadService)Mockito.verify((Object)this.uploadService)).removeUploadResource("up2");
    }

    @Test
    public void testUpdateProfileFieldSimpleProperty() throws IllegalAccessException, IOException {
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName("department")).thenReturn(null);
        this.service.updateProfileField(this.profile, "department", (Object)"R&D", true, TEST_USER_2);
        ((IdentityManager)Mockito.verify((Object)this.identityManager, (VerificationMode)Mockito.atLeastOnce())).updateProfile((Profile)ArgumentMatchers.any(Profile.class), (String)ArgumentMatchers.eq((Object)TEST_USER_2), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void testSendOnBoardingEmailFalseNoUpdate() throws Exception {
        Mockito.when((Object)this.passwordRecoveryService.sendOnboardingEmail((User)ArgumentMatchers.any(UserImpl.class), (Locale)ArgumentMatchers.any(Locale.class), (StringBuilder)ArgumentMatchers.any(StringBuilder.class))).thenReturn((Object)false);
        File f = this.csv("onboard2.csv", HEADER_LINE_2, "sam,Secret123,true,sam@ex.com,Sam,S, true");
        Mockito.when((Object)this.userHandler.findUserByName("sam", UserStatus.ANY)).thenReturn(null);
        ListAccess none = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)none.getSize()).thenReturn((Object)0);
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (UserStatus)ArgumentMatchers.eq((Object)UserStatus.ANY))).thenReturn((Object)none);
        UserImportResult r = new UserImportResult();
        Assertions.assertDoesNotThrow(() -> this.service.importUsers(f.getAbsolutePath(), r, TEST_USER_2, Locale.ENGLISH, URL));
    }

    @Test
    public void testAddUserMembershipsWarningsForMissingGroupAndMembershipType() throws Exception {
        File f = this.csv("memberships_warn.csv", "userName,password,enabled,email,firstName,lastName,groups", "mia,Secret123,true,mia@ex.com,Mia,M, manager:/unknown;ghost:/g");
        Mockito.when((Object)this.userHandler.findUserByName("mia", UserStatus.ANY)).thenReturn(null);
        ListAccess none = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)none.getSize()).thenReturn((Object)0);
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (UserStatus)ArgumentMatchers.eq((Object)UserStatus.ANY))).thenReturn((Object)none);
        Mockito.when((Object)this.groupHandler.findGroupById("/unknown")).thenReturn(null);
        Group g = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)this.groupHandler.findGroupById("/g")).thenReturn((Object)g);
        Mockito.when((Object)this.membershipTypeHandler.findMembershipType(TEST_USER_1)).thenReturn(null);
        Assertions.assertDoesNotThrow(() -> this.service.importUsers(f.getAbsolutePath(), new UserImportResult(), TEST_USER_2, Locale.ENGLISH, URL));
    }

    @Test
    public void testValidateUserPasswordMissingUsesNoPasswordValidators() throws Exception {
        File f = this.csv("validators.csv", HEADER_LINE_5, "val,valid@ex.com,V,Alid");
        Mockito.when((Object)this.userHandler.findUserByName("val", UserStatus.ANY)).thenReturn(null);
        ListAccess none = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)none.getSize()).thenReturn((Object)0);
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (UserStatus)ArgumentMatchers.eq((Object)UserStatus.ANY))).thenReturn((Object)none);
        Assertions.assertDoesNotThrow(() -> this.service.importUsers(f.getAbsolutePath(), new UserImportResult(), TEST_USER_2, Locale.ENGLISH, URL));
    }

    @Test
    public void testSaveProfileSuccess() throws ObjectNotFoundException, IllegalAccessException, IOException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("aboutMe", "Hello");
        this.service.saveProfile("john", props, TEST_USER_2);
        ((IdentityManager)Mockito.verify((Object)this.identityManager)).updateProfile((Profile)ArgumentMatchers.any(Profile.class), (String)ArgumentMatchers.eq((Object)TEST_USER_2), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void testEmailAlreadyExistsZeroOrSameUserFalse() throws Exception {
        File f = this.csv("email_none.csv", HEADER_LINE_4, "tom,Secret123,tom@ex.com,Tom,M");
        Mockito.when((Object)this.userHandler.findUserByName("tom", UserStatus.ANY)).thenReturn(null);
        ListAccess none = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)none.getSize()).thenReturn((Object)0);
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (UserStatus)ArgumentMatchers.eq((Object)UserStatus.ANY))).thenReturn((Object)none);
        this.service.importUsers(f.getAbsolutePath(), new UserImportResult(), TEST_USER_2, Locale.ENGLISH, URL);
        ListAccess oneSame = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)oneSame.getSize()).thenReturn((Object)1);
        User same = (User)Mockito.mock(User.class);
        Mockito.when((Object)same.getUserName()).thenReturn((Object)"tom");
        Mockito.when((Object)((User[])oneSame.load(0, 1))).thenReturn((Object)new User[]{same});
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (UserStatus)ArgumentMatchers.eq((Object)UserStatus.ANY))).thenReturn((Object)oneSame);
        Assertions.assertDoesNotThrow(() -> this.service.importUsers(f.getAbsolutePath(), new UserImportResult(), TEST_USER_2, Locale.ENGLISH, URL));
    }

    @Test
    public void testEmailAlreadyExistsMultipleTrue() throws Exception {
        File f = this.csv("email_many.csv", HEADER_LINE_4, "tina,Secret123,tina@ex.com,Tina,N");
        Mockito.when((Object)this.userHandler.findUserByName("tina", UserStatus.ANY)).thenReturn(null);
        ListAccess listAccess = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)listAccess.getSize()).thenReturn((Object)2);
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (UserStatus)ArgumentMatchers.eq((Object)UserStatus.ANY))).thenReturn((Object)listAccess);
        Assertions.assertDoesNotThrow(() -> this.service.importUsers(f.getAbsolutePath(), new UserImportResult(), TEST_USER_2, Locale.ENGLISH, URL));
    }

    private static void deleteRecursively(File f) {
        if (f == null || !f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            for (File c : Objects.requireNonNull(f.listFiles())) {
                UserImportServiceTest.deleteRecursively(c);
            }
        }
        try {
            Files.deleteIfExists(Path.of(f.getAbsolutePath(), new String[0]));
        }
        catch (IOException e) {
            f.deleteOnExit();
        }
    }

    private File csv(String name, String ... lines) {
        File file = new File(this.tempDir, name);
        Files.write(file.toPath(), String.join((CharSequence)"\n", lines).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return file;
    }
}

