/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.service;

import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.service.SecuritySettingService;
import io.meeds.social.category.model.Category;
import io.meeds.social.category.service.CategoryService;
import io.meeds.social.space.model.SpaceDirectorySettings;
import io.meeds.social.space.service.SpaceDirectoryService;
import io.meeds.social.space.storage.SpaceDirectoryStorage;
import java.util.Arrays;
import java.util.Collections;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.service.LayoutService;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.junit4.SpringRunner;

@SpringBootTest(classes={SpaceDirectoryService.class})
@RunWith(value=SpringRunner.class)
public class SpaceDirectoryServiceTest {
    private static final String USERS_PERMISSION = "users";
    private static final String FILTER_TYPE_TEMPLATE = "template";
    private static final String FILTER_TYPE_CATEGORY = "category";
    private static final String PAGE_REFERENCE = "pageReference";
    private static final String SETTING_NAME = "settingName";
    @MockBean
    private CategoryService categoryService;
    @MockBean
    private LayoutService layoutService;
    @MockBean
    private SpaceDirectoryStorage spaceDirectoryStorage;
    @MockBean
    private SecuritySettingService securitySettingService;
    @Autowired
    private SpaceDirectoryService spaceDirectoryService;

    @Test
    public void testSaveSpacesDirectorySettings() {
        SpaceDirectorySettings spaceDirectorySettings = new SpaceDirectorySettings();
        this.spaceDirectoryService.saveSpacesDirectorySettings(SETTING_NAME, spaceDirectorySettings);
        ((SpaceDirectoryStorage)Mockito.verify((Object)this.spaceDirectoryStorage)).save(SETTING_NAME, spaceDirectorySettings);
    }

    @Test
    public void testRemoveSpacesDirectorySettings() {
        this.spaceDirectoryService.removeSpacesDirectorySettings(SETTING_NAME);
        ((SpaceDirectoryStorage)Mockito.verify((Object)this.spaceDirectoryStorage)).remove(SETTING_NAME);
    }

    @Test
    public void testCanAccessSpacesDirectoryWithNoFilterWhenRegistrationOpen() {
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME));
        Mockito.when((Object)this.securitySettingService.getRegistrationType()).thenReturn((Object)UserRegistrationType.OPEN);
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME));
    }

    @Test
    public void testCanAccessSpacesDirectoryWithNoFilterWhenRegistrationNotOpen() {
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME));
        SpaceDirectorySettings spaceDirectorySettings = new SpaceDirectorySettings();
        Mockito.when((Object)this.spaceDirectoryStorage.get(SETTING_NAME)).thenReturn((Object)spaceDirectorySettings);
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME));
        spaceDirectorySettings.setPageReference(PAGE_REFERENCE);
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME));
        Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)this.layoutService.getPage(PAGE_REFERENCE)).thenReturn((Object)page);
        Mockito.when((Object)page.getAccessPermissions()).thenReturn((Object)new String[]{USERS_PERMISSION});
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME));
        Mockito.when((Object)page.getAccessPermissions()).thenReturn((Object)new String[]{USERS_PERMISSION, "Everyone"});
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME));
    }

    @Test
    public void testCanAccessSpacesDirectoryWithFilterWhenRegistrationOpen() {
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        Mockito.when((Object)this.securitySettingService.getRegistrationType()).thenReturn((Object)UserRegistrationType.OPEN);
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
    }

    @Test
    public void testCanAccessSpacesDirectoryWithFiltersWhenRegistrationNotOpen() {
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        SpaceDirectorySettings spaceDirectorySettings = new SpaceDirectorySettings();
        Mockito.when((Object)this.spaceDirectoryStorage.get(SETTING_NAME)).thenReturn((Object)spaceDirectorySettings);
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        spaceDirectorySettings.setPageReference(PAGE_REFERENCE);
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)this.layoutService.getPage(PAGE_REFERENCE)).thenReturn((Object)page);
        Mockito.when((Object)page.getAccessPermissions()).thenReturn((Object)new String[]{USERS_PERMISSION});
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        Mockito.when((Object)page.getAccessPermissions()).thenReturn((Object)new String[]{USERS_PERMISSION, "Everyone"});
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        spaceDirectorySettings.setFilterType(FILTER_TYPE_CATEGORY);
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        spaceDirectorySettings.setFilterType(FILTER_TYPE_TEMPLATE);
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
    }

    @Test
    public void testCanAccessSpacesDirectoryWithTemplateFilters() {
        SpaceDirectorySettings spaceDirectorySettings = new SpaceDirectorySettings();
        Mockito.when((Object)this.spaceDirectoryStorage.get(SETTING_NAME)).thenReturn((Object)spaceDirectorySettings);
        spaceDirectorySettings.setPageReference(PAGE_REFERENCE);
        Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)this.layoutService.getPage(PAGE_REFERENCE)).thenReturn((Object)page);
        Mockito.when((Object)page.getAccessPermissions()).thenReturn((Object)new String[]{"Everyone"});
        spaceDirectorySettings.setFilterType(FILTER_TYPE_TEMPLATE);
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        spaceDirectorySettings.setTemplateIds(Collections.singletonList(5L));
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, Collections.singletonList(5L)));
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(257895L), Collections.singletonList(5L)));
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, Collections.singletonList(15L)));
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, Arrays.asList(5L, 15L)));
    }

    @Test
    public void testCanAccessSpacesDirectoryWithCategoryFilters() {
        SpaceDirectorySettings spaceDirectorySettings = new SpaceDirectorySettings();
        Mockito.when((Object)this.spaceDirectoryStorage.get(SETTING_NAME)).thenReturn((Object)spaceDirectorySettings);
        spaceDirectorySettings.setPageReference(PAGE_REFERENCE);
        Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)this.layoutService.getPage(PAGE_REFERENCE)).thenReturn((Object)page);
        Mockito.when((Object)page.getAccessPermissions()).thenReturn((Object)new String[]{"Everyone"});
        spaceDirectorySettings.setFilterType(FILTER_TYPE_CATEGORY);
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        spaceDirectorySettings.setCategoryIds(Collections.singletonList(5L));
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(5L), null));
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(5L), Collections.singletonList(257895L)));
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(15L), null));
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Arrays.asList(5L, 15L), null));
        Category category = new Category();
        category.setId(5L);
        Mockito.when((Object)this.categoryService.getCategory(5L)).thenReturn((Object)category);
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(5L), null));
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(5L), Collections.singletonList(257895L)));
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(15L), null));
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Arrays.asList(5L, 15L), null));
        Category otherCategory = new Category();
        otherCategory.setId(15L);
        Mockito.when((Object)this.categoryService.getCategory(15L)).thenReturn((Object)otherCategory);
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(5L), null));
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(5L), Collections.singletonList(257895L)));
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(15L), null));
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Arrays.asList(5L, 15L), null));
        Mockito.when((Object)this.categoryService.getAncestorIds(15L)).thenReturn(Arrays.asList(5L, 27L));
        Assertions.assertFalse((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, null, null));
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(5L), null));
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(5L), Collections.singletonList(257895L)));
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Collections.singletonList(15L), null));
        Assertions.assertTrue((boolean)this.spaceDirectoryService.canAccessSpacesDirectory(SETTING_NAME, Arrays.asList(5L, 15L), null));
    }
}

