/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.service.injection;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.social.space.template.service.injection.SpaceTemplateTranslationImportService$AjcClosure1;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceTemplateTranslationImportService {
    private static final Log LOG;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private LocaleConfigService localeConfigService;
    @Autowired
    private ResourceBundleService resourceBundleService;
    private Map<String, List<Runnable>> postImportProcessors = new ConcurrentHashMap<String, List<Runnable>>();
    private Map<Locale, ResourceBundle> bundles = new ConcurrentHashMap<Locale, ResourceBundle>();
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PreDestroy
    protected void destroy() {
        this.executorService.shutdownNow();
    }

    public void saveTranslationLabels(String objectType, long objectId, String fieldName, Map<String, String> labels, boolean isRichText) {
        this.postImportProcessors.computeIfAbsent(objectType, k -> new ArrayList()).add(() -> this.saveTranslationLabelsForAllLanguages(objectType, objectId, fieldName, labels, this.getI18NLabel((String)labels.get("en"), Locale.ENGLISH), isRichText));
    }

    public void postImport(String objectType) {
        this.postImportProcessors.computeIfAbsent(objectType, k -> new ArrayList()).forEach(this.executorService::execute);
        this.postImportProcessors.remove(objectType);
        this.bundles.clear();
    }

    @ContainerTransactional
    private void saveTranslationLabelsForAllLanguages(String objectType, long objectId, String fieldName, Map<String, String> labels, String defaultLabel, boolean isRichText) {
        String string = objectType;
        long l = objectId;
        String string2 = fieldName;
        Map<String, String> map = labels;
        String string3 = defaultLabel;
        boolean bl = isRichText;
        Object[] objectArray = new Object[]{string, Conversions.longObject((long)l), string2, map, string3, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, Conversions.longObject((long)l), string2, map, string3, Conversions.booleanObject((boolean)bl), joinPoint};
        SpaceTemplateTranslationImportService$AjcClosure1 spaceTemplateTranslationImportService$AjcClosure1 = new SpaceTemplateTranslationImportService$AjcClosure1(objectArray2);
        ContainerTransactionalAspect.aspectOf().around(spaceTemplateTranslationImportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private String getI18NLabel(String label, Locale locale) {
        return this.getI18NLabel(label, locale, null);
    }

    private String getI18NLabel(String label, Locale locale, String defaultLabel) {
        try {
            ResourceBundle resourceBundle = this.getResourceBundle(locale);
            if (resourceBundle != null && resourceBundle.containsKey(label)) {
                return resourceBundle.getString(label);
            }
        }
        catch (Exception e) {
            LOG.debug("Resource Bundle not found with locale {}", new Object[]{locale, e});
        }
        return defaultLabel == null ? label : defaultLabel;
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return this.bundles.computeIfAbsent(locale, l -> this.resourceBundleService.getResourceBundle(new String[]{"locale.portlet.Portlets", "locale.social.Core"}, l, PortalContainer.getInstance().getPortalClassLoader()));
    }

    static {
        SpaceTemplateTranslationImportService.ajc$preClinit();
        LOG = ExoLogger.getLogger(SpaceTemplateTranslationImportService.class);
    }

    static final /* synthetic */ void saveTranslationLabelsForAllLanguages_aroundBody0(SpaceTemplateTranslationImportService ajc$this, String objectType, long objectId, String fieldName, Map labels, String defaultLabel, boolean isRichText, JoinPoint joinPoint) {
        String i18nKey = (String)labels.get("en");
        HashMap translations = new HashMap();
        ajc$this.localeConfigService.getLocalConfigs().stream().filter(config -> !StringUtils.equals((CharSequence)config.getLocale().toLanguageTag(), (CharSequence)"ma")).forEach(config -> translations.put(config.getLocale(), this.getI18NLabel(i18nKey, config.getLocale(), defaultLabel)));
        ajc$this.translationService.saveTranslationLabels(objectType, objectId == 0L ? null : String.valueOf(objectId), fieldName, translations, isRichText);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpaceTemplateTranslationImportService.java", SpaceTemplateTranslationImportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "saveTranslationLabelsForAllLanguages", "io.meeds.social.space.template.service.injection.SpaceTemplateTranslationImportService", "java.lang.String:long:java.lang.String:java.util.Map:java.lang.String:boolean", "objectType:objectId:fieldName:labels:defaultLabel:isRichText", "", "void"), 101);
    }
}

