/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.common.lifecycle.LifeCycleCompletionService;
import org.exoplatform.social.common.lifecycle.LifeCycleListener;
import org.exoplatform.social.core.space.SpaceLifecycle;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class SpaceLifeCycleTest
extends AbstractCoreTest {
    private LifeCycleCompletionService completionService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.completionService = (LifeCycleCompletionService)ExoContainerContext.getService(LifeCycleCompletionService.class);
    }

    public void testSimpleBroadcast() {
        SpaceLifecycle lifecycle = new SpaceLifecycle();
        MockListener capture = new MockListener(this);
        lifecycle.addListener((LifeCycleListener)capture);
        MockListener capture2 = new MockListener(this);
        lifecycle.addListener((LifeCycleListener)capture2);
        lifecycle.addInvitedUser(null, "foo");
        lifecycle.addInvitedUser(null, "bar");
        this.end();
        this.completionService.waitCompletionFinished();
        this.begin();
        SpaceLifeCycleTest.assertTrue((boolean)capture.hasEvent("bar"));
        SpaceLifeCycleTest.assertTrue((boolean)capture.hasEvent("foo"));
        SpaceLifeCycleTest.assertTrue((boolean)capture2.hasEvent("bar"));
        SpaceLifeCycleTest.assertTrue((boolean)capture2.hasEvent("foo"));
    }

    public void testBroadcastWithFailingListener() {
        SpaceLifecycle lifecycle = new SpaceLifecycle();
        MockListener capture = new MockListener(this);
        lifecycle.addListener((LifeCycleListener)capture);
        MockFailingListener failing = new MockFailingListener(this);
        lifecycle.addListener((LifeCycleListener)failing);
        MockListener capture2 = new MockListener(this);
        lifecycle.addListener((LifeCycleListener)capture2);
        lifecycle.addInvitedUser(null, "foo");
        lifecycle.addInvitedUser(null, "bar");
        this.end();
        this.completionService.waitCompletionFinished();
        this.begin();
        SpaceLifeCycleTest.assertTrue((boolean)capture.hasEvent("bar"));
        SpaceLifeCycleTest.assertTrue((boolean)capture.hasEvent("foo"));
        SpaceLifeCycleTest.assertTrue((boolean)capture2.hasEvent("bar"));
        SpaceLifeCycleTest.assertTrue((boolean)capture2.hasEvent("foo"));
        SpaceLifeCycleTest.assertFalse((boolean)failing.hasEvent("bar"));
        SpaceLifeCycleTest.assertFalse((boolean)failing.hasEvent("foo"));
    }

    class MockListener
    implements SpaceLifeCycleListener {
        protected List<String> events = new ArrayList<String>();

        MockListener(SpaceLifeCycleTest this$0) {
        }

        public boolean hasEvent(String event) {
            return this.events.contains(event);
        }

        protected void recordEvent(SpaceLifeCycleEvent event) {
            this.events.add(event.getTarget());
        }

        public void grantedLead(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }

        public void joined(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }

        public void left(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }

        public void revokedLead(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }

        public void spaceCreated(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }

        public void spaceRemoved(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }

        public void spaceRenamed(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }

        public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }

        public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }

        public void spaceAccessEdited(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }

        public void addInvitedUser(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }

        public void addPendingUser(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }

        public void spaceBannerEdited(SpaceLifeCycleEvent event) {
            this.recordEvent(event);
        }
    }

    class MockFailingListener
    extends MockListener {
        MockFailingListener(SpaceLifeCycleTest this$0) {
            super(this$0);
        }

        @Override
        protected void recordEvent(SpaceLifeCycleEvent event) {
            throw new IllegalStateException("fake runtime exception thrown on purpose"){
                private static final long serialVersionUID = 6615691329774228817L;

                @Override
                public StackTraceElement[] getStackTrace() {
                    return new StackTraceElement[0];
                }
            };
        }
    }
}

