/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.service.injection;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.social.common.ContainerStartableService;
import io.meeds.social.space.constant.SpaceRegistration;
import io.meeds.social.space.constant.SpaceVisibility;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.injection.SpaceTemplateImportService$AjcClosure1;
import io.meeds.social.space.template.service.injection.SpaceTemplateTranslationImportService;
import io.meeds.social.space.template.service.injection.model.SpaceTemplateDescriptor;
import io.meeds.social.space.template.service.injection.model.SpaceTemplateDescriptorList;
import io.meeds.social.space.template.storage.SpaceTemplateStorage;
import io.meeds.social.util.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelUnmarshaller;
import org.exoplatform.portal.config.model.UnmarshalledObject;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.upload.UploadResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SpaceTemplateImportService
implements ContainerStartableService {
    private static final Scope SPACE_TEMPLATE_IMPORT_SCOPE;
    private static final Context SPACE_TEMPLATE_CONTEXT;
    private static final String SPACE_TEMPLATE_VERSION = "version";
    public static final String SPACE_TEMPLATES_INTIALIZED_EVENT = "space.templates.initialized";
    private static final Log LOG;
    private static final Random RANDOM;
    private ListenerService listenerService;
    @Autowired
    private SpaceTemplateTranslationImportService layoutTranslationService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private SpaceTemplateStorage spaceTemplateStorage;
    @Autowired
    private SettingService settingService;
    @Autowired
    private ConfigurationManager configurationManager;
    @Value(value="${meeds.space.template.import.override:false}")
    private boolean forceReimportTemplates;
    @Value(value="${meeds.space.template.import.version:2}")
    private long version;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public int getOrder() {
        return 10;
    }

    @ContainerTransactional
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        SpaceTemplateImportService$AjcClosure1 spaceTemplateImportService$AjcClosure1 = new SpaceTemplateImportService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(spaceTemplateImportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    protected List<SpaceTemplateDescriptor> parseDescriptors(URL url) {
        List<SpaceTemplateDescriptor> list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                SpaceTemplateDescriptorList list2 = (SpaceTemplateDescriptorList)JsonUtils.fromJsonString((String)content, SpaceTemplateDescriptorList.class);
                list = list2.getDescriptors();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("An unkown error happened while parsing space templates from url {}", new Object[]{url, e});
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    protected void importDescriptor(SpaceTemplateDescriptor descriptor) {
        String descriptorId = descriptor.getId();
        long existingTemplateId = this.getSettingValue(descriptorId);
        if (this.forceReimportTemplates || existingTemplateId == 0L) {
            this.importSpaceTemplate(descriptor, existingTemplateId);
        } else {
            LOG.debug("Ignore re-importing Space Template {}", new Object[]{descriptorId});
        }
    }

    protected void importSpaceTemplate(SpaceTemplateDescriptor d, long oldTemplateId) {
        LOG.info("Importing Space Template {}", new Object[]{d.getId()});
        try {
            SpaceTemplate spaceTemplate = this.createSpaceTemplate(d, oldTemplateId);
            if (this.forceReimportTemplates || oldTemplateId == 0L || spaceTemplate.getId() != oldTemplateId) {
                LOG.info("Importing Space Template {} title translations", new Object[]{d.getId()});
                this.saveNames(d, spaceTemplate);
                LOG.info("Importing Space Template {} description translations", new Object[]{d.getId()});
                this.saveDescriptions(d, spaceTemplate);
                LOG.info("Importing Space Template {} illustration", new Object[]{d.getId()});
                this.saveBanner(spaceTemplate.getId(), d.getBannerPath());
                this.setSettingValue(d.getId(), spaceTemplate.getId());
            }
            LOG.info("Importing Space Template {} finished successfully", new Object[]{d.getId()});
        }
        catch (Exception e) {
            LOG.warn("An error occurred while importing Space template {}", new Object[]{d.getId(), e});
        }
    }

    protected void saveNames(SpaceTemplateDescriptor d, SpaceTemplate spaceTemplate) {
        this.layoutTranslationService.saveTranslationLabels("spaceTemplate", spaceTemplate.getId(), "name", d.getNames(), false);
    }

    protected void saveDescriptions(SpaceTemplateDescriptor d, SpaceTemplate spaceTemplate) {
        this.layoutTranslationService.saveTranslationLabels("spaceTemplate", spaceTemplate.getId(), "description", d.getDescriptions(), true);
    }

    protected SpaceTemplate createSpaceTemplate(SpaceTemplateDescriptor d, long oldTemplateId) {
        boolean isNew;
        SpaceTemplate spaceTemplate = null;
        if (oldTemplateId > 0L) {
            spaceTemplate = this.spaceTemplateStorage.getSpaceTemplate(oldTemplateId);
        }
        boolean bl = isNew = spaceTemplate == null;
        if (isNew) {
            spaceTemplate = new SpaceTemplate();
        }
        spaceTemplate.setSystem(d.isSystem());
        spaceTemplate.setIcon(d.getIcon());
        spaceTemplate.setEnabled(d.isEnabled());
        spaceTemplate.setLayout(d.getLayout());
        spaceTemplate.setSpaceFields(d.getSpaceFields());
        spaceTemplate.setPermissions(d.getPermissions());
        spaceTemplate.setSpaceLayoutPermissions(d.getSpaceLayoutPermissions());
        spaceTemplate.setSpacePublicSitePermissions(d.getSpacePublicSitePermissions());
        spaceTemplate.setSpaceDeletePermissions(d.getSpaceDeletePermissions());
        spaceTemplate.setSpaceDefaultRegistration(SpaceRegistration.valueOf((String)d.getSpaceDefaultRegistration().toUpperCase()));
        spaceTemplate.setSpaceDefaultVisibility(SpaceVisibility.valueOf((String)d.getSpaceDefaultVisibility().toUpperCase()));
        spaceTemplate.setSpaceAllowContentCreation(d.isSpaceAllowContentCreation());
        if (isNew) {
            return this.spaceTemplateStorage.createSpaceTemplate(spaceTemplate);
        }
        return this.spaceTemplateStorage.updateSpaceTemplate(spaceTemplate);
    }

    protected void saveBanner(long templateId, String imagePath) {
        File tempFile = null;
        try {
            tempFile = this.getIllustrationFile(imagePath);
            String uploadId = "SpaceTemplateBanner" + RANDOM.nextLong();
            UploadResource uploadResource = new UploadResource(uploadId);
            uploadResource.setFileName(tempFile.getName());
            uploadResource.setMimeType("image/png");
            uploadResource.setStatus(1);
            uploadResource.setStoreLocation(tempFile.getPath());
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
            this.attachmentService.deleteAttachments("spaceTemplateBanner", String.valueOf(templateId));
            this.attachmentService.saveAttachment(uploadedAttachmentDetail, "spaceTemplateBanner", String.valueOf(templateId), null, 1L);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving Image '%s' as attachment for template '%s'", imagePath, templateId), e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (IOException e) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    protected Container fromXML(String xml) {
        UnmarshalledObject obj = ModelUnmarshaller.unmarshall(Container.class, (byte[])xml.getBytes(StandardCharsets.UTF_8));
        return (Container)obj.getObject();
    }

    protected void setSettingValue(String name, long value) {
        this.settingService.set(SPACE_TEMPLATE_CONTEXT, SPACE_TEMPLATE_IMPORT_SCOPE, name, SettingValue.create((String)String.valueOf(value)));
    }

    protected long getSettingValue(String name) {
        try {
            SettingValue settingValue = this.settingService.get(SPACE_TEMPLATE_CONTEXT, SPACE_TEMPLATE_IMPORT_SCOPE, name);
            return settingValue == null || settingValue.getValue() == null ? 0L : Long.parseLong(settingValue.getValue().toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private File getIllustrationFile(String imagePath) throws Exception {
        try (InputStream inputStream = this.configurationManager.getInputStream(imagePath);){
            File tempFile = File.createTempFile("temp", ".png");
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
            File file = tempFile;
            return file;
        }
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)ExoContainerContext.getService(ListenerService.class);
        }
        return this.listenerService;
    }

    static {
        SpaceTemplateImportService.ajc$preClinit();
        SPACE_TEMPLATE_IMPORT_SCOPE = Scope.APPLICATION.id("SPACE_TEMPLATE_IMPORT");
        SPACE_TEMPLATE_CONTEXT = Context.GLOBAL.id("SPACE_TEMPLATE");
        LOG = ExoLogger.getLogger(SpaceTemplateImportService.class);
        RANDOM = new Random();
    }

    static final /* synthetic */ void start_aroundBody0(SpaceTemplateImportService ajc$this, JoinPoint joinPoint) {
        LOG.info((Object)"Importing Space Templates");
        if (!ajc$this.forceReimportTemplates && ajc$this.getSettingValue(SPACE_TEMPLATE_VERSION) != ajc$this.version) {
            ajc$this.forceReimportTemplates = true;
        }
        try {
            Enumeration<URL> templateFiles = PortalContainer.getInstance().getPortalClassLoader().getResources("space-templates.json");
            Collections.list(templateFiles).stream().map(ajc$this::parseDescriptors).flatMap(Collection::stream).forEach(ajc$this::importDescriptor);
            LOG.info((Object)"Importing Space Templates finished successfully");
            if (ajc$this.getSettingValue(SPACE_TEMPLATE_VERSION) == 0L) {
                ajc$this.getListenerService().broadcast(SPACE_TEMPLATES_INTIALIZED_EVENT, null, null);
            }
            LOG.info((Object)"Processing Post Space Templates import");
            ajc$this.layoutTranslationService.postImport("spaceTemplate");
            LOG.info((Object)"Processing Post Space Templates import finished");
            ajc$this.setSettingValue(SPACE_TEMPLATE_VERSION, ajc$this.version);
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while importing space templates", (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpaceTemplateImportService.java", SpaceTemplateImportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "io.meeds.social.space.template.service.injection.SpaceTemplateImportService", "", "", "", "void"), 115);
    }
}

