/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.service;

import io.meeds.social.category.AbstractCategoryConfigurationTest;
import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryFilter;
import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.category.model.CategoryTree;
import java.util.Collections;
import java.util.Locale;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Assert;
import org.junit.Test;

public class CategoryLinkServiceTest
extends AbstractCategoryConfigurationTest {
    @Test
    public void testIsLinked() {
        Assert.assertFalse((boolean)this.categoryLinkService.isLinked(12254689L, new CategoryObject("space", "5566", 0L)));
        Space space = new Space();
        space.setRegistration("open");
        space.setVisibility("public");
        space = this.spaceService.createSpace(space, "root");
        Category rootCategory = this.categoryService.getRootCategory(this.getAdminGroupIdentityId());
        CategoryObject object = new CategoryObject("space", space.getId(), space.getSpaceId());
        this.categoryLinkService.link(rootCategory.getId(), object);
        Assert.assertTrue((boolean)this.categoryLinkService.isLinked(rootCategory.getId(), object));
    }

    @Test
    public void testLink() {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.categoryLinkService.link(12254689L, new CategoryObject("space", "5566", 0L), "mary"));
        Category rootCategory = this.categoryService.getRootCategory(this.getAdminGroupIdentityId());
        Assert.assertThrows(IllegalAccessException.class, () -> this.categoryLinkService.link(rootCategory.getId(), new CategoryObject("space", "5566", 0L), "mary"));
        Space space = new Space();
        space.setRegistration("open");
        space.setVisibility("public");
        space = this.spaceService.createSpace(space, "root");
        CategoryObject object = new CategoryObject("space", space.getId(), space.getSpaceId());
        Assert.assertThrows(IllegalAccessException.class, () -> this.categoryLinkService.link(rootCategory.getId(), object, "mary"));
        this.categoryLinkService.link(rootCategory.getId(), object, "root");
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.categoryLinkService.link(rootCategory.getId(), object, "root"));
        this.buildCategoryTree();
        CategoryFilter filter = new CategoryFilter(null, 0L, 0L, 1L, 0L, 1L, false, false);
        CategoryTree categoryTree = this.categoryService.getCategoryTree(filter, "mary", Locale.FRENCH);
        CategoryTree category = (CategoryTree)categoryTree.getCategories().getFirst();
        category.setLinkPermissions(Collections.singletonList("*:/platform/users"));
        this.categoryService.updateCategory((Category)category, "john");
        Assert.assertFalse((boolean)this.categoryLinkService.isLinked(category.getId(), object));
        Assert.assertThrows(IllegalAccessException.class, () -> this.categoryLinkService.link(rootCategory.getId(), object, "mary"));
        Assert.assertFalse((boolean)this.categoryLinkService.isLinked(category.getId(), object));
        this.spaceService.addMember(space, "mary");
        this.spaceService.setManager(space, "mary", true);
        this.categoryLinkService.link(category.getId(), object, "mary");
        Assert.assertTrue((boolean)this.categoryLinkService.isLinked(category.getId(), object));
    }

    @Test
    public void testUnLink() {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.categoryLinkService.unlink(12254689L, new CategoryObject("space", "5566", 0L), "mary"));
        Category rootCategory = this.categoryService.getRootCategory(this.getAdminGroupIdentityId());
        Assert.assertThrows(IllegalAccessException.class, () -> this.categoryLinkService.unlink(rootCategory.getId(), new CategoryObject("space", "5566", 0L), "mary"));
        Space space = new Space();
        space.setRegistration("open");
        space.setVisibility("public");
        space = this.spaceService.createSpace(space, "root");
        CategoryObject object = new CategoryObject("space", space.getId(), space.getSpaceId());
        this.categoryLinkService.link(rootCategory.getId(), object, "root");
        Assert.assertThrows(IllegalAccessException.class, () -> this.categoryLinkService.unlink(rootCategory.getId(), object, "mary"));
        Assert.assertTrue((boolean)this.categoryLinkService.isLinked(rootCategory.getId(), object));
        this.categoryLinkService.unlink(rootCategory.getId(), object, "root");
        Assert.assertFalse((boolean)this.categoryLinkService.isLinked(rootCategory.getId(), object));
        this.categoryLinkService.link(rootCategory.getId(), object, "root");
        rootCategory.setLinkPermissions(Collections.singletonList("*:/platform/users"));
        this.categoryService.updateCategory(rootCategory, "john");
        Assert.assertThrows(IllegalAccessException.class, () -> this.categoryLinkService.unlink(rootCategory.getId(), object, "mary"));
        Assert.assertTrue((boolean)this.categoryLinkService.isLinked(rootCategory.getId(), object));
        this.spaceService.addMember(space, "mary");
        this.spaceService.setManager(space, "mary", true);
        this.categoryLinkService.unlink(rootCategory.getId(), object, "mary");
        Assert.assertFalse((boolean)this.categoryLinkService.isLinked(rootCategory.getId(), object));
    }
}

